package com.ejianc.business.jlincome.performance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 绩效管理-销售预报-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_performance_forecast")
public class ForecastEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 区域主键
    @TableField(value="org_name")
    private String orgName; // 区域名称
    @TableField(value="org_code")
    private String orgCode; // 区域编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="org_person_id")
    private Long orgPersonId; // 区域统计员id
    @TableField(value="org_person_name")
    private String orgPersonName; // 区域统计员
    @TableField(value="forecast_month")
        private Date forecastMonth; // 预报月份
    @TableField(value="forecast_name")
    private String forecastName; // 销售预报标题
    @TableField(value="forecast_date")
    private Date forecastDate; // 预报提交日期
    @TableField(value="sale_forecast_mny")
    private BigDecimal saleForecastMny; // 销售任务总额（万元）
    @TableField(value="invoice_forecast_mny")
    private BigDecimal invoiceForecastMny; // 开票任务总额（万元）
    @TableField(value="income_forecast_mny")
    private BigDecimal incomeForecastMny; // 收款任务总额（万元
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="change_id")
    private Long changeId; // 变更单主键
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="change_employee_id")
    private Long changeEmployeeId; // 变更经办人
    @TableField(value="change_employee_name")
    private String changeEmployeeName; // 变更经办人名称
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="change_state")
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    @TableField(value="latest_flag")
    private Boolean latestFlag; // 是否最新版本
    @TableField(value="enable_state")
    private Boolean enableState; // 是否生效
    @TableField(value="forecast_version")
    private Integer forecastVersion; // 版本号
    @TableField(value="effect_date")
    private Date effectDate; //生效时间

    @TableField(value="before_forecast_version")
    private Integer beforeForecastVersion; // 历史版本号
    @TableField(value="last_forecast_id")
    private Long lastForecastId; // 上一版本主键
    @TableField(value="one_time")
    private Date oneTime; // 第一版本创建时间
    @TableField(value="base_forecast_id")
    private Long baseForecastId; // 原始版本主键

    @TableField(exist=false)
    @SubEntity(serviceName="forecastDetailService")
    private List<ForecastDetailEntity> forecastDetailList = new ArrayList<>(); // 绩效管理-销售预报-子表


    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getOrgPersonId() {
        return orgPersonId;
    }

    public void setOrgPersonId(Long orgPersonId) {
        this.orgPersonId = orgPersonId;
    }
    public String getOrgPersonName() {
        return orgPersonName;
    }

    public void setOrgPersonName(String orgPersonName) {
        this.orgPersonName = orgPersonName;
    }
    public Date getForecastMonth() {
        return forecastMonth;
    }

    public void setForecastMonth(Date forecastMonth) {
        this.forecastMonth = forecastMonth;
    }
    public String getForecastName() {
        return forecastName;
    }

    public void setForecastName(String forecastName) {
        this.forecastName = forecastName;
    }
    public Date getForecastDate() {
        return forecastDate;
    }

    public void setForecastDate(Date forecastDate) {
        this.forecastDate = forecastDate;
    }
    public BigDecimal getSaleForecastMny() {
        return saleForecastMny;
    }

    public void setSaleForecastMny(BigDecimal saleForecastMny) {
        this.saleForecastMny = saleForecastMny;
    }
    public BigDecimal getInvoiceForecastMny() {
        return invoiceForecastMny;
    }

    public void setInvoiceForecastMny(BigDecimal invoiceForecastMny) {
        this.invoiceForecastMny = invoiceForecastMny;
    }
    public BigDecimal getIncomeForecastMny() {
        return incomeForecastMny;
    }

    public void setIncomeForecastMny(BigDecimal incomeForecastMny) {
        this.incomeForecastMny = incomeForecastMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }
    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }
    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }
    public Integer getForecastVersion() {
        return forecastVersion;
    }

    public void setForecastVersion(Integer forecastVersion) {
        this.forecastVersion = forecastVersion;
    }
    public Integer getBeforeForecastVersion() {
        return beforeForecastVersion;
    }

    public void setBeforeForecastVersion(Integer beforeForecastVersion) {
        this.beforeForecastVersion = beforeForecastVersion;
    }
    public Long getLastForecastId() {
        return lastForecastId;
    }

    public void setLastForecastId(Long lastForecastId) {
        this.lastForecastId = lastForecastId;
    }
    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }
    public Long getBaseForecastId() {
        return baseForecastId;
    }

    public void setBaseForecastId(Long baseForecastId) {
        this.baseForecastId = baseForecastId;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public List<ForecastDetailEntity> getForecastDetailList() {
        return forecastDetailList;
    }

    public void setForecastDetailList(List<ForecastDetailEntity> forecastDetailList) {
        this.forecastDetailList = forecastDetailList;
    }
}
