package com.ejianc.business.jlincome.performance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlincome.performance.bean.TaskDetailEntity;
/**
 * 任务下达-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_performance_task")
public class TaskEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称/区域名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="org_person_id")
    private Long orgPersonId; // 区域负责人id
    @TableField(value="org_person_name")
    private String orgPersonName; // 区域负责人
    @TableField(value="task_year")
    private Date taskYear; // 任务年度
    @TableField(value="task_name")
    private String taskName; // 任务下达标题
    @TableField(value="task_date")
    private Date taskDate; // 任务下达日期
    @TableField(value="sale_task_mny")
    private BigDecimal saleTaskMny; // 销售任务总额（万元）
    @TableField(value="invoice_task_mny")
    private BigDecimal invoiceTaskMny; // 开票任务总额（万元）
    @TableField(value="income_task_mny")
    private BigDecimal incomeTaskMny; // 收款任务总额（万元）
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="change_id")
    private Long changeId; // 变更单主键
    @TableField(value="change_state")
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    @TableField(value="latest_flag")
    private Boolean latestFlag; // 是否最新版本
    @TableField(value="enable_state")
    private Boolean enableState; // 是否生效
    @TableField(value="effect_date")
    private Date effectDate; // 生效时间
    @TableField(value="task_version")
    private Integer taskVersion; // 版本号
    @TableField(value="before_task_version")
    private Integer beforeTaskVersion; // 历史版本号
    @TableField(value="last_task_id")
    private Long lastTaskId; // 上一版本主键
    @TableField(value="one_time")
    private Date oneTime; // 第一版本创建时间
    @TableField(value="base_task_id")
    private Long baseTaskId; // 原始版本主键


    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="change_employee_id")
    private Long changeEmployeeId; // 变更经办人
    @TableField(value="change_employee_name")
    private String changeEmployeeName; // 变更经办人名称
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="change_effect_date")
    private Date changeEffectDate; // 变更生效时间

    @TableField(value="quarter_one_ratio")
    private Integer quarterOneRatio; // 第一季度比例
    @TableField(value="quarter_two_ratio")
    private Integer quarterTwoRatio; // 第二季度比例
    @TableField(value="quarter_three_ratio")
    private Integer quarterThreeRatio; // 第三季度比例
    @TableField(value="quarter_four_ratio")
    private Integer quarterFourRatio; // 第四季度比例
    
    @TableField(exist=false)
    @SubEntity(serviceName="taskDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<TaskDetailEntity> detailList = new ArrayList<>(); // 任务下达-子表
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getOrgPersonId() {
        return orgPersonId;
    }

    public void setOrgPersonId(Long orgPersonId) {
        this.orgPersonId = orgPersonId;
    }
    public String getOrgPersonName() {
        return orgPersonName;
    }

    public void setOrgPersonName(String orgPersonName) {
        this.orgPersonName = orgPersonName;
    }
    public Date getTaskYear() {
        return taskYear;
    }

    public void setTaskYear(Date taskYear) {
        this.taskYear = taskYear;
    }
    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }
    public Date getTaskDate() {
        return taskDate;
    }

    public void setTaskDate(Date taskDate) {
        this.taskDate = taskDate;
    }
    public BigDecimal getSaleTaskMny() {
        return saleTaskMny;
    }

    public void setSaleTaskMny(BigDecimal saleTaskMny) {
        this.saleTaskMny = saleTaskMny;
    }
    public BigDecimal getInvoiceTaskMny() {
        return invoiceTaskMny;
    }

    public void setInvoiceTaskMny(BigDecimal invoiceTaskMny) {
        this.invoiceTaskMny = invoiceTaskMny;
    }
    public BigDecimal getIncomeTaskMny() {
        return incomeTaskMny;
    }

    public void setIncomeTaskMny(BigDecimal incomeTaskMny) {
        this.incomeTaskMny = incomeTaskMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }

    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }

    public Integer getTaskVersion() {
        return taskVersion;
    }

    public void setTaskVersion(Integer taskVersion) {
        this.taskVersion = taskVersion;
    }
    public Integer getBeforeTaskVersion() {
        return beforeTaskVersion;
    }

    public void setBeforeTaskVersion(Integer beforeTaskVersion) {
        this.beforeTaskVersion = beforeTaskVersion;
    }
    public Long getLastTaskId() {
        return lastTaskId;
    }

    public void setLastTaskId(Long lastTaskId) {
        this.lastTaskId = lastTaskId;
    }
    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }
    public Long getBaseTaskId() {
        return baseTaskId;
    }

    public void setBaseTaskId(Long baseTaskId) {
        this.baseTaskId = baseTaskId;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public List<TaskDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TaskDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Integer getQuarterOneRatio() {
        return quarterOneRatio;
    }

    public void setQuarterOneRatio(Integer quarterOneRatio) {
        this.quarterOneRatio = quarterOneRatio;
    }

    public Integer getQuarterTwoRatio() {
        return quarterTwoRatio;
    }

    public void setQuarterTwoRatio(Integer quarterTwoRatio) {
        this.quarterTwoRatio = quarterTwoRatio;
    }

    public Integer getQuarterThreeRatio() {
        return quarterThreeRatio;
    }

    public void setQuarterThreeRatio(Integer quarterThreeRatio) {
        this.quarterThreeRatio = quarterThreeRatio;
    }

    public Integer getQuarterFourRatio() {
        return quarterFourRatio;
    }

    public void setQuarterFourRatio(Integer quarterFourRatio) {
        this.quarterFourRatio = quarterFourRatio;
    }

    public Date getChangeEffectDate() {
        return changeEffectDate;
    }

    public void setChangeEffectDate(Date changeEffectDate) {
        this.changeEffectDate = changeEffectDate;
    }
}
