package com.ejianc.business.jlincome.performance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.jlincome.performance.bean.TaskEntity;
import com.ejianc.business.jlincome.performance.service.ITaskService;
import com.ejianc.business.jlincome.performance.vo.TaskVO;

/**
 * 任务下达-主表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("task")
public class TaskController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TASK_CODE";//此处需要根据实际修改

    @Autowired
    private ITaskService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TaskVO> saveOrUpdate(@RequestBody TaskVO saveOrUpdateVO) {
        return service.insertOrUpdate(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TaskVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @Description queryChangeDetail 复制为变更单 取详情 （场景：点击变更）
     * @param id
     */
    @RequestMapping(value = "/queryChangeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TaskVO> queryChangeDetail(Long id) {
        TaskVO changeVO = service.queryChangeDetail(id);
        return CommonResponse.success("查询详情数据成功！", changeVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TaskVO> vos) {
        return service.deleteVos(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //单据编码、任务下达标题、区域名称、区域负责人、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("taskName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");

        if(null != param.getParams().get("taskYear")) {
            String taskYear = (String) param.getParams().get("taskYear").getValue();
            param.getParams().remove("taskYear");
            taskYear = taskYear.substring(0, 4);
            param.getParams().put("taskYear", new Parameter(QueryParam.BETWEEN, (taskYear + "-01" + "-01") + "," + (taskYear + "-12" + "-31")));
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效单据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");

        //不生效（只有第一版本的 不生效的能被查出来，其他版本的都是生效的，不生效的是从变更中进入的）
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);

        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("taskVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);


        IPage<TaskEntity> page = service.queryPage(param,false);
        IPage<TaskVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TaskVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("taskName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");

        if(null != param.getParams().get("taskYear")) {
            String taskYear = (String) param.getParams().get("taskYear").getValue();
            param.getParams().remove("taskYear");
            taskYear = taskYear.substring(0, 4);
            param.getParams().put("taskYear", new Parameter(QueryParam.BETWEEN, (taskYear + "-01" + "-01") + "," + (taskYear + "-12" + "-31")));
        }

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效单据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");

        //不生效（只有第一版本的 不生效的能被查出来，其他版本的都是生效的，不生效的是从变更中进入的）
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);

        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("taskVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);

        List<TaskEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<TaskVO> voList = BeanMapper.mapList(list, TaskVO.class);

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            e.setChangeStateName(e.getChangeState() == 0 ? "未变更" : e.getChangeState() == 1 ? "变更中" : "已变更" );
            e.setTaskYearName(sdf.format(e.getTaskYear()));
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("Task-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTaskData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TaskVO>> refTaskData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TaskEntity> page = service.queryPage(param,false);
        IPage<TaskVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TaskVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 判断 选择校验 本区域 + 任务下达年度 是否已经有任务下达的单据（含自由态）
     * @param orgId
     * @param taskYear
     * @return
     */
    @GetMapping(value = "/checkOrgYear")
    public CommonResponse<String> checkOrgYear(@RequestParam(value = "orgId") Long orgId, @RequestParam(value = "taskYear") String taskYear, @RequestParam(value = "id", required = false) Long id) {
        return service.checkOrgYear(orgId, taskYear, id);
    }

}
