package com.ejianc.business.jlincome.performance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlincome.performance.bean.ForecastEntity;
import com.ejianc.business.jlincome.performance.service.IForecastService;
import com.ejianc.business.jlincome.performance.vo.ForecastLedgerVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.performance.mapper.ForecastDetailMapper;
import com.ejianc.business.jlincome.performance.bean.ForecastDetailEntity;
import com.ejianc.business.jlincome.performance.service.IForecastDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

/**
 * 绩效管理-销售预报-子表
 *
 * @author generator
 */
@Service("forecastDetailService")
public class ForecastDetailServiceImpl extends BaseServiceImpl<ForecastDetailMapper, ForecastDetailEntity> implements IForecastDetailService {

    @Autowired
    private IForecastService iForecastService;

    @Override
    public List<ForecastLedgerVO> selectAll(String searchText) {
        List<ForecastLedgerVO> resDatas = new ArrayList<>();
        LambdaQueryWrapper<ForecastDetailEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.like(ForecastDetailEntity::getDetailOrgName, searchText);
        // 获取到子表的数据
        List<ForecastDetailEntity> listFatherBysearchText = baseMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(listFatherBysearchText)) {
            List<ForecastLedgerVO> resDatas1 = new ArrayList<>();
            List<ForecastLedgerVO> forecastLedgerVOS = TreeNodeBUtil.buildTree(resDatas1);
            return forecastLedgerVOS;
        } else {

            List<Long> pid = listFatherBysearchText.stream().map(ForecastDetailEntity::getPid).collect(Collectors.toList());

            LambdaQueryWrapper<ForecastEntity> wrapper2 = new LambdaQueryWrapper<>();
            wrapper2.in(ForecastEntity::getId, pid);
            wrapper2.eq(ForecastEntity::getLatestFlag, 1);//是否是最新版本
            wrapper2.eq(ForecastEntity::getEnableState, 1);//是否生效
            List<Integer> billStateList = new ArrayList<>();
            billStateList.add(1);
            billStateList.add(3);
            wrapper2.in(ForecastEntity::getBillState, billStateList);//单据状态只查 1 3
            List<ForecastEntity> listForecastEntity = iForecastService.list(wrapper2);
            List<ForecastLedgerVO> list2 = BeanMapper.mapList(listForecastEntity, ForecastLedgerVO.class);
            resDatas.addAll(list2);

            //拿到满足要求的 主表id
            List<Long> list3 = listForecastEntity.stream().map(ForecastEntity::getId).collect(Collectors.toList());
        if(list3.size()!=0){

            LambdaQueryWrapper<ForecastDetailEntity> wrapper3 = new LambdaQueryWrapper<>();
            wrapper3.in(ForecastDetailEntity::getPid, list3);
            List<ForecastDetailEntity> listForecastDetailEntity = baseMapper.selectList(wrapper3);
            List<ForecastLedgerVO> listFather = BeanMapper.mapList(listForecastDetailEntity, ForecastLedgerVO.class);

            //用于查询孙级
            List<Long> ids = listForecastDetailEntity.stream().map(ForecastDetailEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<ForecastDetailEntity> lambda = Wrappers.<ForecastDetailEntity>lambdaQuery();
            lambda.in(ForecastDetailEntity::getParentId, ids);
            List<ForecastDetailEntity> forecastDetailEntityList = baseMapper.selectList(lambda);
            List<ForecastLedgerVO> ListVOList = BeanMapper.mapList(forecastDetailEntityList, ForecastLedgerVO.class);


            //过滤出重复数据
            List<ForecastLedgerVO> listSon = ListVOList.stream().filter(forecastLedgerVO -> forecastLedgerVO.getParentId() != null).collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getDetailPersonId() + ";" + o.getPid()))), ArrayList::new)
            );

            for (ForecastLedgerVO forecastLedgerVO : listFather) {
                forecastLedgerVO.setParentId(forecastLedgerVO.getPid());
                forecastLedgerVO.setOrgName(forecastLedgerVO.getDetailOrgName());
                forecastLedgerVO.setOrgPersonName(forecastLedgerVO.getDetailPersonName());
                forecastLedgerVO.setSaleForecastMny(forecastLedgerVO.getSaleDetailMny());
                forecastLedgerVO.setInvoiceForecastMny(forecastLedgerVO.getInvoiceDetailMny());
                forecastLedgerVO.setIncomeForecastMny(forecastLedgerVO.getIncomeDetailMny());
            }
            resDatas.addAll(listFather);


            if (CollectionUtils.isNotEmpty(listSon)) {
                listSon.forEach(e -> {
                    e.setOrgName(e.getOrgName());
                    e.setOrgPersonName(e.getDetailPersonName());
                    //子表父级的区域名
                    e.setOrgName(e.getDetailOrgName());

                    LambdaQueryWrapper<ForecastDetailEntity> wrapper1 = new LambdaQueryWrapper<>();

                    wrapper1.eq(ForecastDetailEntity::getDetailPersonId, e.getDetailPersonId())
                            .eq(ForecastDetailEntity::getParentId, e.getParentId());
                    List<ForecastDetailEntity> list1 = baseMapper.selectList(wrapper1);

                    BigDecimal SaleForecastMny = new BigDecimal(0);
                    BigDecimal InvoiceForecastMny = new BigDecimal(0);
                    BigDecimal IncomeForecastMny = new BigDecimal(0);

                    for (ForecastDetailEntity forecastDetailEntity : list1) {
                        SaleForecastMny = SaleForecastMny.add(forecastDetailEntity.getSaleDetailMny());
                        InvoiceForecastMny = InvoiceForecastMny.add(forecastDetailEntity.getInvoiceDetailMny());
                        IncomeForecastMny = IncomeForecastMny.add(forecastDetailEntity.getIncomeDetailMny());
                    }

                    //销售 开票 收款 预报金额
                    e.setSaleForecastMny(SaleForecastMny);//预报
                    e.setInvoiceForecastMny(InvoiceForecastMny);//开票
                    e.setIncomeForecastMny(IncomeForecastMny);//收款
                });
                resDatas.addAll(listSon);
            }
            List<ForecastLedgerVO> forecastLedgerVOS = TreeNodeBUtil.buildTree(resDatas);
            return forecastLedgerVOS;
        }
            List<ForecastLedgerVO> resDatas1 = new ArrayList<>();
            List<ForecastLedgerVO> forecastLedgerVOS = TreeNodeBUtil.buildTree(resDatas1);
            return forecastLedgerVOS;
        }
    }
}
