package com.ejianc.business.jlincome.performance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.jlincome.performance.bean.TaskDetailEntity;
import com.ejianc.business.jlincome.performance.enums.ChangeStateEnum;
import com.ejianc.business.jlincome.performance.vo.TaskDetailVO;
import com.ejianc.business.jlincome.performance.vo.TaskRecordVO;
import com.ejianc.business.jlincome.performance.vo.TaskVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.performance.mapper.TaskMapper;
import com.ejianc.business.jlincome.performance.bean.TaskEntity;
import com.ejianc.business.jlincome.performance.service.ITaskService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 任务下达-主表
 * 
 * @author generator
 * 
 */
@Service("taskService")
public class TaskServiceImpl extends BaseServiceImpl<TaskMapper, TaskEntity> implements ITaskService{
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "TASK_CODE";//此处需要根据实际修改

    @Override
    public CommonResponse<TaskVO> insertOrUpdate(TaskVO saveOrUpdateVO) {
        TaskEntity entity = BeanMapper.map(saveOrUpdateVO, TaskEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            //第一版设置版本号、原始版本主键、第一版本创建时间
            if(null == entity.getLastTaskId()){
                entity.setTaskVersion(1);

                entity.setOneTime(entity.getCreateTime());
                entity.setChangeState(ChangeStateEnum.未变更.getCode());
            }

            entity.setLatestFlag(true);//新增时默认最新版本
            entity.setEnableState(false);//新增时默认不生效

            if (null == entity.getBillCode()){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
        //重置父id
        this.resetPid(entity.getDetailList());
        super.saveOrUpdate(entity, false);

        //如果是变更单，则原单据保存变更信息
        if(entity.getLastTaskId() != null){
            TaskEntity revise = super.getById(entity.getLastTaskId());
            if (revise.getLatestFlag()){

                revise.setChangeId(entity.getId());
                revise.setChangeState(ChangeStateEnum.变更中.getCode());
                //变更单保存后，原单据就不是最新版本！（这里是否变更单生效后再把原单据改为 非最新版本）
                revise.setLatestFlag(false);
                //第一次变更保存，设置原单据初始版本id
                revise.setBaseTaskId(null != revise.getBaseTaskId() ? revise.getBaseTaskId() : revise.getId());

                super.saveOrUpdate(revise);
            }
        }
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }



    //重置父id
    private void resetPid(List<TaskDetailEntity> detailList) {
        if(CollectionUtils.isNotEmpty(detailList)){
            Map<String,Long> idMap = new HashMap<>();
            for(TaskDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if (detail.getId() == null){
                        detail.setId(IdWorker.getId());
                    }
                    idMap.put(detail.getTid(), detail.getId());
                    detail.setParentId(null);
                }
            }
            for(TaskDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if(StringUtils.isNotEmpty(detail.getTpid())){
                        detail.setParentId(idMap.get(detail.getTpid()));
                    }
                }
            }
        }
    }

    //查询
    @Override
    public TaskVO queryDetail(Long id) {
        TaskEntity entity = super.selectById(id);
        TaskVO vo = BeanMapper.map(entity, TaskVO.class);

        //子表
        List<TaskDetailVO> detailList = vo.getDetailList();
        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (TaskDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }

        //记录表
        List<TaskRecordVO> list = new ArrayList<>();
        LambdaQueryWrapper<TaskEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TaskEntity::getBaseTaskId, entity.getBaseTaskId());
        queryWrapper.in(TaskEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.ne(TaskEntity::getId, id);
        queryWrapper.orderByAsc(TaskEntity::getCreateTime);
        List<TaskEntity> taskEntityList = super.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(taskEntityList)){
            list = BeanMapper.mapList(taskEntityList, TaskRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    //变更单赋值
    @Override
    public TaskVO queryChangeDetail(Long id) {
        TaskEntity entity = super.selectById(id);
        TaskVO vo = BeanMapper.map(entity, TaskVO.class);
        vo.setId(null);
//        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);

        vo.setBeforeTaskVersion(vo.getTaskVersion());
        vo.setTaskVersion(vo.getTaskVersion() + 1);
        vo.setLastTaskId(id);
        vo.setBaseTaskId(null != entity.getBaseTaskId() ? entity.getBaseTaskId() : id);

        vo.setChangeEmployeeId(null);
        vo.setChangeEmployeeName(null);
        vo.setChangeReason(null);

//        vo.setChangeState(ChangeStateEnum.未变更.getCode());
//        vo.setLatestFlag(true);
//        vo.setEnableState(false);

        List<TaskDetailVO> detailList = vo.getDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTid(changeDetailVO.getId());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("add");
            });
            vo.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<TaskVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for(TaskVO taskVO : vos){
                TaskEntity taskEntity = super.selectById(taskVO.getId());
                //删除变更中的数据、回写原数据
                // （这里是否有问题，如果变更一次后，第二次变更怎么显示？版本号是不是这里体现意义？这里得价格版本号）
                if(taskEntity.getLastTaskId() != null){
                    TaskEntity revise = super.getById(taskEntity.getLastTaskId());
                    revise.setChangeId(null);
                    revise.setLatestFlag(true);

                    //可能不是第一次变更
                    revise.setChangeState(1 == taskEntity.getTaskVersion() ? ChangeStateEnum.未变更.getCode() : ChangeStateEnum.已变更.getCode());
                    super.saveOrUpdate(revise);
                }
            }
        }
        super.removeByIds(vos.stream().map(TaskVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<String> checkOrgYear(Long orgId, String taskYear, Long taskId) {
        QueryWrapper<TaskEntity> query = new QueryWrapper<>();
        query.eq("org_id", orgId);
        query.eq("task_year", taskYear + "-01-01");
        if (null != taskId){
            query.ne("id", taskId);
        }
        List<TaskEntity> billList = super.list(query);
        return CommonResponse.success(CollectionUtils.isNotEmpty(billList) ? "本区域 + 任务下达年度已有任务下单的单据！" : null);
    }
}
