package com.ejianc.business.jlincome.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.vo.TenderEvaluationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.bid.mapper.TenderEvaluationMapper;
import com.ejianc.business.jlincome.bid.bean.TenderEvaluationEntity;
import com.ejianc.business.jlincome.bid.service.ITenderEvaluationService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 投标-投标文件评审
 * 
 * @author generator
 * 
 */
@Service("tenderEvaluationService")
public class TenderEvaluationServiceImpl extends BaseServiceImpl<TenderEvaluationMapper, TenderEvaluationEntity> implements ITenderEvaluationService{

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public boolean checkIsExist(TenderEvaluationVO tenderEvaluationVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<TenderEvaluationEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(TenderEvaluationEntity::getEngineeringId, tenderEvaluationVO.getEngineeringId());
        lambda.eq(TenderEvaluationEntity::getTenantId, tenantId);
        if (null != tenderEvaluationVO.getId() && tenderEvaluationVO.getId() > 0) {
            lambda.ne(TenderEvaluationEntity::getId, tenderEvaluationVO.getId());
        }
        return super.list(lambda).size() > 0;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> pushProjectArchive(TenderEvaluationEntity tenderEvaluationEntity) {
        ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();


        String projectStatus = ArchiveProjectStatusEnum.投标阶段.getCode();
        Long engineeringId = tenderEvaluationEntity.getEngineeringId();

        logger.info("投标文件评审-推送项目信息数据----" + JSONObject.toJSONString(projectArchiveVO));
        return projectArchiveApi.updateProjectStatus(projectStatus,engineeringId);
    }
}
