package com.ejianc.business.jlincome.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 收入管理-甲方扣款
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_deduction")
public class DeductionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_id")
    private Long contractId; // 合同ID
    @TableField(value="contract_code")
    private String contractCode; // 合同code
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织ID(区域名称)
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织code
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="customer_id")
    private Long customerId; // 客户ID
    @TableField(value="customer_code")
    private String customerCode; // 客户code
    @TableField(value="customer_name")
    private String customerName; // 客户名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="deduction_date")
    private Date deductionDate; // 扣款日期
    @TableField(value="deduction_tax_mny")
    private BigDecimal deductionTaxMny; // 扣款金额
    @TableField(value="total_deduction_mny")
    private BigDecimal totalDeductionMny; // 累计扣款金额(无税)
    @TableField(value="include_total_deduction_mny")
    private BigDecimal includeTotalDeductionMny; // 含本次累计扣款金额(无税)
    @TableField(value="total_deduction_tax")
    private BigDecimal totalDeductionTax; // 累计扣款金额(含税)
    @TableField(value="include_total_deduction_tax")
    private BigDecimal includeTotalDeductionTax; // 含本次累计扣款金额(含税)
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="deduction_tax")
    private BigDecimal deductionTax; // 税额
    @TableField(value="deduction_mny")
    private BigDecimal deductionMny; // 扣款金额(无税)
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 扣款原因
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="has_record")
    private Integer hasRecord; // 是否被引用(1：是，0：否）
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Date getDeductionDate() {
        return deductionDate;
    }

    public void setDeductionDate(Date deductionDate) {
        this.deductionDate = deductionDate;
    }
    public BigDecimal getDeductionTaxMny() {
        return deductionTaxMny;
    }

    public void setDeductionTaxMny(BigDecimal deductionTaxMny) {
        this.deductionTaxMny = deductionTaxMny;
    }
    public BigDecimal getTotalDeductionMny() {
        return totalDeductionMny;
    }

    public void setTotalDeductionMny(BigDecimal totalDeductionMny) {
        this.totalDeductionMny = totalDeductionMny;
    }
    public BigDecimal getIncludeTotalDeductionMny() {
        return includeTotalDeductionMny;
    }

    public void setIncludeTotalDeductionMny(BigDecimal includeTotalDeductionMny) {
        this.includeTotalDeductionMny = includeTotalDeductionMny;
    }
    public BigDecimal getTotalDeductionTax() {
        return totalDeductionTax;
    }

    public void setTotalDeductionTax(BigDecimal totalDeductionTax) {
        this.totalDeductionTax = totalDeductionTax;
    }
    public BigDecimal getIncludeTotalDeductionTax() {
        return includeTotalDeductionTax;
    }

    public void setIncludeTotalDeductionTax(BigDecimal includeTotalDeductionTax) {
        this.includeTotalDeductionTax = includeTotalDeductionTax;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getDeductionTax() {
        return deductionTax;
    }

    public void setDeductionTax(BigDecimal deductionTax) {
        this.deductionTax = deductionTax;
    }
    public BigDecimal getDeductionMny() {
        return deductionMny;
    }

    public void setDeductionMny(BigDecimal deductionMny) {
        this.deductionMny = deductionMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getHasRecord() {
        return hasRecord;
    }

    public void setHasRecord(Integer hasRecord) {
        this.hasRecord = hasRecord;
    }
}
