package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.jlcost.finance.api.IInvoiceReceiveApi;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.bid.service.IResultRegisterService;
import com.ejianc.business.jlincome.income.bean.ContractRegisterDetailEntity;
import com.ejianc.business.jlincome.income.enums.ChangeTypeEnum;
import com.ejianc.business.jlincome.income.service.IContractRegisterDetailService;
import com.ejianc.business.jlincome.income.vo.ContractRegisterDetailVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterVO;
import com.ejianc.business.jlincome.income.vo.ImportContractRegisterDetailVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.business.jlincome.income.service.ISettleService;
import com.ejianc.business.jlincome.income.vo.*;
import com.ejianc.business.jlprogress.order.api.IOrderApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.income.mapper.ContractRegisterMapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 收入管理-合同登记
 *
 * @author generator
 *
 */
@Service("contractRegisterService")
public class ContractRegisterServiceImpl extends BaseServiceImpl<ContractRegisterMapper, ContractRegisterEntity> implements IContractRegisterService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractRegisterDetailService contractDetailService;

    @Autowired
    private ContractRegisterMapper contractRegisterMapper;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IOrderApi orderApi;

    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IResultRegisterService resultRegisterService;


    @Autowired
    private IInvoiceReceiveApi invoiceReceiveApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    private static final String PC_URL = "/ejc-jlincome-frontend/#/contractRegister/card?id=";
    private static final String MOBILE_URL = "/ejc-jlincome-mobile/#/contractRegister/card?id=";


    @Override
    public boolean checkSameBillCode(ContractRegisterVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ContractRegisterEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractRegisterEntity::getBillCode, vo.getBillCode());
        lambda.eq(ContractRegisterEntity::getTenantId, tenantId);
        if (null != vo.getId() && vo.getId() > 0) {
            lambda.ne(ContractRegisterEntity::getId, vo.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public void performanceStatusUp(Long id, Integer performanceStatus) {
        UpdateWrapper<ContractRegisterEntity> updateWrapper = new UpdateWrapper();
        updateWrapper.in("id",id);
        updateWrapper.set("performance_status",performanceStatus);
        super.update(updateWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportContractRegisterDetailVO> successList = new ArrayList<>();
            List<ImportContractRegisterDetailVO> errorList = new ArrayList<>();

            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 9) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=1000){
                    throw new BusinessException("文件数据不能超过1000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    ImportContractRegisterDetailVO importVO = new ImportContractRegisterDetailVO();

                    //产品名称
                    if (StringUtils.isBlank(datas.get(0))) {
                        errorMessage.append("[产品名称为必填项]");
                    } else {
                        if (datas.get(0).length() > 200){
                            importVO.setErrorMessage("填写产品名称长度为1~200字");
                        }
                        importVO.setDetailProductName(datas.get(0).trim());
                    }

                    //规格型号
                    if (StringUtils.isBlank(datas.get(1))) {
                        errorMessage.append("[规格型号为必填项]");
                    } else {
                        if (datas.get(1).length() > 200){
                            importVO.setErrorMessage("填写规格型号长度为1~200字");
                        }
                        importVO.setDetailSpec(datas.get(1).trim());
                    }

                    //单位
                    if (StringUtils.isBlank(datas.get(2))) {
                        errorMessage.append("[单位为必填项]");
                    } else {
                        if (datas.get(2).length() > 50){
                            importVO.setErrorMessage("填写单位长度为1~50字");
                        }
                        importVO.setDetailUnit(datas.get(2).trim());
                    }

                    //数量
                    if (StringUtils.isBlank(datas.get(3))) {
                        errorMessage.append("[数量为必填项]");
                    } else {
                        try {
                            importVO.setDetailNum(new BigDecimal(datas.get(3)));
                        } catch (Exception e) {
                            errorMessage.append("[数量必须为数字]");
                        }
                    }

                    //单价
                    if (StringUtils.isBlank(datas.get(4))) {
                        errorMessage.append("[单价为必填项]");
                    } else {
                        try {
                            importVO.setDetailTaxPrice(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            errorMessage.append("[单价必须为数字]");
                        }
                    }

                    //税率
                    if (StringUtils.isBlank(datas.get(5))) {
                        errorMessage.append("[税率为必填项]");
                    } else {
                        try {
                            importVO.setDetailRate(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            errorMessage.append("[税率必须为数字]");
                        }
                    }

                    //金额
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            importVO.setDetailTaxMny(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            errorMessage.append("[金额必须为数字]");
                        }
                    }

                    //预计交货日期
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            importVO.setDetailPlanDeliverDate(DateUtils.parseDate(datas.get(7), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[预计交货日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //备注
                    if (datas.get(8).length() > 200) {
                        importVO.setErrorMessage("填写备注长度为0~200字");
                    }
                    importVO.setDetailMemo(datas.get(8));

                    importVO.setId(IdWorker.getId());
                    importVO.setSourceType(2);


                    if (StringUtils.isBlank(errorMessage)) {
                        //重算金额
                        importVO.setDetailTaxMny(ComputeUtil.safeMultiply(importVO.getDetailTaxPrice(), importVO.getDetailNum()));
                        //公式：无税=含税/（1+税率）
                        importVO.setDetailMny(ComputeUtil.safeDiv(importVO.getDetailTaxMny(), ComputeUtil.safeAdd(new BigDecimal(1), ComputeUtil.safeDiv(importVO.getDetailRate(), new BigDecimal(100)))));
                        importVO.setDetailPrice(ComputeUtil.safeDiv(importVO.getDetailTaxPrice(), ComputeUtil.safeAdd(new BigDecimal(1), ComputeUtil.safeDiv(importVO.getDetailRate(), new BigDecimal(100)))));
                        importVO.setDetailTax(ComputeUtil.safeSub(importVO.getDetailTaxMny(), importVO.getDetailMny()));
                        importVO.setChangeType(ChangeTypeEnum.未变更.getCode().toString());
                        successList.add(importVO);
                    }else {
                        importVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(importVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    @Override
    public JSONObject queryContractMnyByProjectId(Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContractRegisterEntity::getProjectId, projectId);
        queryWrapper.in(ContractRegisterEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ContractRegisterEntity> contractList = super.list(queryWrapper);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectId", projectId);
        if (CollectionUtils.isNotEmpty(contractList) && contractList.size() > 0){
            jsonObject.put("contractMny", contractList.stream().filter(e -> null != e.getContractMny()).map(ContractRegisterEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            jsonObject.put("contractTaxMny", contractList.stream().filter(e -> null != e.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            jsonObject.put("contractTax", contractList.stream().filter(e -> null != e.getContractTax()).map(ContractRegisterEntity::getContractTax).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return jsonObject;
    }

    @Override
    public ContractRegisterVO queryDetail(Long id) {
        ContractRegisterEntity entity = super.selectById(id);
        entity.setDetailList(null);
        ContractRegisterVO contractVo = BeanMapper.map(entity, ContractRegisterVO.class);
        List<ContractRegisterDetailEntity> details = null;
        LambdaQueryWrapper<ContractRegisterDetailEntity> lambda = Wrappers.<ContractRegisterDetailEntity>lambdaQuery();
        lambda.eq(ContractRegisterDetailEntity::getContractRegisterId, id);
        lambda.ne(ContractRegisterDetailEntity::getChangeType, ChangeTypeEnum.终止项.getCode());
        details = contractDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            contractVo.setDetailList(BeanMapper.mapList(details, ContractRegisterDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public Map<String, BigDecimal> queryContractMnyByReviewId(Long reviewId) {
        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContractRegisterEntity::getReviewId, reviewId);
        queryWrapper.in(ContractRegisterEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ContractRegisterEntity> contractList = super.list(queryWrapper);

        Map<String, BigDecimal> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractList) && contractList.size() > 0){
            map.put("contractMny", contractList.stream().filter(e -> null != e.getContractMny()).map(ContractRegisterEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            map.put("contractTaxMny", contractList.stream().filter(e -> null != e.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }else {
            map.put("contractMny", BigDecimal.ZERO);
            map.put("contractTaxMny", BigDecimal.ZERO);
        }
        return map;
    }

    @Override
    public ProjectBoardVO queryContractBoardList(QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        System.out.println("orgId");
        CommonResponse<Page<ProjectArchiveVO>> projectResponse = projectArchiveApi.queryProjectArchivePage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("网络异常， 获取项目失败， 请稍后再试");
        }
        List<ProjectArchiveVO> projectRecords = projectResponse.getData().getRecords();
//        List<Long> projectIds = projectRecords.stream().filter(e -> null != e.getProjectStatus() && (Integer.valueOf(e.getProjectStatus()) > Integer.valueOf(ArchiveProjectStatusEnum.未中标.getCode()))).map(ProjectArchiveVO::getId).collect(Collectors.toList());
//        logger.info("查得项目id：{}", JSONObject.toJSONString(projectIds));

        String startDate = null;
        String endDate = null;
        int bidNum = projectRecords.stream().filter(e -> null != e.getProjectStatus() && (Integer.valueOf(e.getProjectStatus()) > Integer.valueOf(ArchiveProjectStatusEnum.未中标.getCode()))).collect(Collectors.toList()).size();
        if(null != param.getParams().get("createTime")) {
            String dateStr = (String) param.getParams().get("createTime").getValue();
            String[] split = dateStr.split(",");
            startDate = split[0];
            endDate = split[1];
            param.getParams().put("bidDate", param.getParams().get("createTime"));
            param.getParams().remove("createTime");

            CommonResponse<Page<ProjectArchiveVO>> bidProjectResponse = projectArchiveApi.queryProjectArchivePage(param);
            if (!bidProjectResponse.isSuccess()) {
                throw new BusinessException("网络异常， 获取项目失败， 请稍后再试");
            }
            bidNum = bidProjectResponse.getData().getRecords().size();

//            List<Long> resultRegisterIdList = new ArrayList<>();
//            for (ProjectArchiveVO projectRecord : projectRecords) {
//                if (Integer.valueOf(projectRecord.getProjectStatus()) >= Integer.valueOf(ArchiveProjectStatusEnum.已中标.getCode())){
//                    if ("bid".equals(projectRecord.getSourceType())){
//                        resultRegisterIdList.add(projectRecord.getSourceBillId());
//                    }else {
//                        resultRegisterIdList.add(Long.valueOf(projectRecord.getSourceUpdateId()));
//                    }
//                }
//            }
//            if (CollectionUtils.isNotEmpty(resultRegisterIdList)){
//                logger.info("查得中标结果登记id：{}", JSONObject.toJSONString(resultRegisterIdList));
//                List<ResultRegisterEntity> registerEntityList = resultRegisterService.list(new QueryWrapper<ResultRegisterEntity>().in("id", resultRegisterIdList).between("project_approval_date", startDate, endDate));
//                bidNum = registerEntityList.size();
//            }else {
//                bidNum = 0;
//            }
        }


        ProjectBoardVO projectBoardVO = baseMapper.queryContractBordData(orgIds, startDate, endDate);

        if (null != projectRecords && projectRecords.size() > 0){
            projectBoardVO.setProjectNum(projectRecords.size());
            projectBoardVO.setBidProjectNum(bidNum);
        }else {
            return new ProjectBoardVO();
        }
        return projectBoardVO;
    }

    @Override
    public List<ProjectBoardTwoVO> queryProjectBoardList(QueryParam param, List<ProjectArchiveVO> projectRecords) {
        if (CollectionUtils.isEmpty(projectRecords)){
            return new ArrayList<>();
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        // 获取没有wbs的项目
        CommonResponse<List<ProjectArchiveVO>> response = shareProjectWbsApi.getProjectIdsNoWbs();
        if (!response.isSuccess()) {
            throw new BusinessException("网络异常， 获取未做项目wbs信息失败， 请稍后再试");
        }
        List<Long> noWbsIdList = new ArrayList<>();
        List<ProjectArchiveVO> projectArchiveVOList = response.getData();
        if (CollectionUtils.isNotEmpty(projectArchiveVOList)){
            noWbsIdList = projectArchiveVOList.stream().map(ProjectArchiveVO::getId).collect(Collectors.toList());
        }

        CommonResponse<JSONObject> warnDataResponse = warnCenterApi.queryWarnNumByOrgIds(projectRecords.stream().filter(e -> null != e.getProjectDepartmentId()).distinct().map(ProjectArchiveVO::getProjectDepartmentId).collect(Collectors.toList()));
        if (!warnDataResponse.isSuccess()) {
            throw new BusinessException("网络异常， 获取预警信息失败， 请稍后再试");
        }
        Map<Long, Integer> warnDataMap = new HashMap<>();
        if (null != warnDataResponse.getData()){
            warnDataMap = warnDataResponse.getData().toJavaObject(Map.class);
        }

        List<ProjectBoardTwoVO> recordList = BeanMapper.mapList(projectRecords, ProjectBoardTwoVO.class);
        List<Long> projectIds = projectRecords.stream().filter(e -> null != e.getProjectStatus()).map(ProjectArchiveVO::getId).collect(Collectors.toList());
        System.out.println(projectIds);

        param.getParams().remove("projectStatus");
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));
        List<ContractRegisterEntity> registerList = super.queryList(param);
        if (CollectionUtils.isEmpty(registerList)){
            return recordList;
        }


        List<ContractRegisterVO> contractRegisterVOList = BeanMapper.mapList(registerList, ContractRegisterVO.class);
        List<Long> contractIdList = contractRegisterVOList.stream().map(ContractRegisterVO::getId).collect(Collectors.toList());
        //获取合同id集合
        logger.info("获取合同id集合：{}", JSONObject.toJSONString(contractIdList));



        CommonResponse<JSONObject> invoiceReceiveDataRes = invoiceReceiveApi.getInvoiceReceiveDataByContractIdList(contractIdList);
        if (!invoiceReceiveDataRes.isSuccess()){
            throw new BusinessException("获取合同登记下游开票、收款信息失败！原因-" + invoiceReceiveDataRes.getMsg());
        }
        String invoiceReceiveDataStr = invoiceReceiveDataRes.getData().toJSONString();
        CommonResponse<JSONObject> orderDataRes = orderApi.getOrderDataByContractIdList(contractIdList);
        if (!orderDataRes.isSuccess()){
            throw new BusinessException("获取合同登记下游销售、发货、验收信息失败！原因-" + orderDataRes.getMsg());
        }
        String orderDataStr = orderDataRes.getData().toJSONString();
        Map<Long, JSONObject> settleDataMap = settleService.querySettleRecordByContIdList(contractIdList);

        List<ContractRegisterReportVO> registerReportVOList = new ArrayList<>();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        for (ContractRegisterVO record : contractRegisterVOList) {
            ContractRegisterReportVO reportVO = BeanMapper.map(record, ContractRegisterReportVO.class);
            JSONObject invoiceReceiveData = JSONObject.parseObject(invoiceReceiveDataStr);
            if (invoiceReceiveData.containsKey(record.getId())){
                JSONObject invoiceReceive = JSONObject.parseObject(invoiceReceiveData.getString(record.getId().toString()), JSONObject.class);
                if (invoiceReceive.size() > 0){
                    //开票
                    if (null != invoiceReceive.get("sumInvoiceTaxMny")){
                        reportVO.setSumInvoiceTaxMny(new BigDecimal(invoiceReceive.get("sumInvoiceTaxMny").toString()));
                    }
                    //收款
                    if (null != invoiceReceive.get("sumReceiveTaxMny")){
                        reportVO.setSumReceiveTaxMny(new BigDecimal(invoiceReceive.get("sumReceiveTaxMny").toString()));
                    }
                    //开票记录
                    if (null != invoiceReceive.get("invoiceDetailList")){
                        reportVO.setInvoiceDetailList(JSONObject.parseArray(invoiceReceive.get("invoiceDetailList").toString(), JSONObject.class));
                        for (JSONObject jsonObject : reportVO.getInvoiceDetailList()) {
                            if (null != jsonObject.get("detailDate")){
                                jsonObject.put("detailDate", sim.format(new Date(Long.valueOf(jsonObject.get("detailDate").toString()))));
                            }
                        }
                    }
                    //收款记录
                    if (null != invoiceReceive.get("receiveDetailList")){
                        reportVO.setReceiveDetailList(JSONObject.parseArray(invoiceReceive.get("receiveDetailList").toString(), JSONObject.class));
                        for (JSONObject jsonObject : reportVO.getReceiveDetailList()) {
                            if (null != jsonObject.get("receiveTime")){
                                jsonObject.put("receiveTime", sim.format(new Date(Long.valueOf(jsonObject.get("receiveTime").toString()))));
                            }
                        }
                    }
                }
            }
            JSONObject orderData = JSONObject.parseObject(orderDataStr);
            if (orderData.containsKey(record.getId())){
                JSONObject order = JSONObject.parseObject(orderData.getString(record.getId().toString()), JSONObject.class);
                if (order.size() > 0){
                    //转单日期
                    if (null != order.get("firstOrderDate")){
                        reportVO.setFirstOrderDate(new Date(Long.valueOf(order.get("firstOrderDate").toString())));
                    }
                    //销售订单
                    if (null != order.get("salesList")){
                        reportVO.setSalesList(JSONObject.parseArray(order.get("salesList").toString(), JSONObject.class));
                    }
                    //发货记录（发货状态）
                    if (null != order.get("productOutState")){
                        reportVO.setProductOutState((order.get("productOutState").toString()));
                    }
                    //发货记录
                    if (null != order.get("productOutVOList")){
                        reportVO.setProductOutVOList(JSONObject.parseArray(order.get("productOutVOList").toString(), JSONObject.class));
                    }
                }
            }
            if (settleDataMap.containsKey(record.getId())){
                JSONObject settle = JSONObject.parseObject(String.valueOf(settleDataMap.get(record.getId())), JSONObject.class);
                if (settle.size() > 0){
                    //结算
                    if (null != settle.get("sumSettleTaxMny")){
                        reportVO.setSumSettleTaxMny(new BigDecimal(settle.get("sumSettleTaxMny").toString()));
                    }
                    if (null != settle.get("settleList")){
                        reportVO.setSettleList(JSONObject.parseArray(settle.get("settleList").toString(), JSONObject.class));
                        for (JSONObject jsonObject : reportVO.getSettleList()) {
                            if (null != jsonObject.get("settleDate")){
                                jsonObject.put("settleDate", sim.format(new Date(Long.valueOf(jsonObject.get("settleDate").toString()))));
                            }
                        }
                    }
                }
            }

            registerReportVOList.add(reportVO);
        }

        Map<Long, List<ContractRegisterReportVO>> reportMap = registerReportVOList.stream().collect(Collectors.groupingBy(ContractRegisterReportVO::getProjectId));
        for (ProjectBoardTwoVO projectBoardTwoVO : recordList) {
            if (noWbsIdList.contains(projectBoardTwoVO.getId())){
                projectBoardTwoVO.setWbsState("否");
            }
            if (null != warnDataMap && warnDataMap.containsKey(projectBoardTwoVO.getProjectDepartmentId())){
                projectBoardTwoVO.setWarnNum(warnDataMap.get(projectBoardTwoVO.getProjectDepartmentId()));
            }
            if (reportMap.containsKey(projectBoardTwoVO.getId())){
                List<ContractRegisterReportVO> reportVOList = reportMap.get(projectBoardTwoVO.getId());
                projectBoardTwoVO.setContractTaxMny(reportVOList.stream().filter(p -> p.getContractTaxMny() != null).map(ContractRegisterReportVO::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                projectBoardTwoVO.setSumInvoiceTaxMny(reportVOList.stream().filter(p -> p.getSumInvoiceTaxMny() != null).map(ContractRegisterReportVO::getSumInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                projectBoardTwoVO.setSumReceiveTaxMny(reportVOList.stream().filter(p -> p.getSumReceiveTaxMny() != null).map(ContractRegisterReportVO::getSumReceiveTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                projectBoardTwoVO.setSumSettleTaxMny(reportVOList.stream().filter(p -> p.getSumSettleTaxMny() != null).map(ContractRegisterReportVO::getSumSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));

                List<ContractRegisterReportVO> registerReportList = reportMap.get(projectBoardTwoVO.getId());
                for (ContractRegisterReportVO registerReportVO : registerReportList) {
                    if (null != projectBoardTwoVO.getFirstOrderDate()){
                        if (null != registerReportVO.getFirstOrderDate()){
                            projectBoardTwoVO.setFirstOrderDate(projectBoardTwoVO.getFirstOrderDate().compareTo(registerReportVO.getFirstOrderDate()) < 1 ? projectBoardTwoVO.getFirstOrderDate() : registerReportVO.getFirstOrderDate());
                        }
                    }else {
                        projectBoardTwoVO.setFirstOrderDate(registerReportVO.getFirstOrderDate());
                    }
                    if (null != projectBoardTwoVO.getProductOutState()){
                        if ("已发货".equals(registerReportVO.getProductOutState())){
                            projectBoardTwoVO.setProductOutState("已发货");
                        }
                    }
                    projectBoardTwoVO.getSalesList().addAll(registerReportVO.getSalesList());
                    projectBoardTwoVO.getProductOutVOList().addAll(registerReportVO.getProductOutVOList());
                    projectBoardTwoVO.getSettleList().addAll(registerReportVO.getSettleList());
                    projectBoardTwoVO.getInvoiceDetailList().addAll(registerReportVO.getInvoiceDetailList());
                    projectBoardTwoVO.getReceiveDetailList().addAll(registerReportVO.getReceiveDetailList());
                    JSONObject contractJson = new JSONObject();
                    contractJson.put("contractId", registerReportVO.getId());
                    contractJson.put("contractCode", registerReportVO.getBillCode());
                    contractJson.put("contractName", registerReportVO.getContractName());
                    contractJson.put("contractTaxMny", registerReportVO.getContractTaxMny());
                    projectBoardTwoVO.getContractList().add(contractJson);
                }
            }
        }
        return recordList;
    }

    @Override
    public List<ContractRegisterEntity> selectExpireContractList() {

        return contractRegisterMapper.selectExpireContractList();
    }

    @Override
    public void sendMsgToInstallPerson(ContractRegisterEntity contractRegisterEntity) {
        logger.info("部门负责人”推送系统消息，OA消息（钉钉消息）");
        //消息内容：XXX项目有一项重要的合同交底需要查看！！！支持链接打开查看详情
        String msg = this.sendMsg(contractRegisterEntity,"部门负责人”推送系统消息，OA消息（钉钉消息）","你有一个合同包含施工，请尽快处理！点击查看详情！！！");
        if (StringUtils.isNotBlank(msg)){
            logger.error("部门负责人”推送系统消息，OA消息（钉钉消息） 异常：" + msg);
        }
        logger.info("部门负责人”推送系统消息，OA消息（钉钉消息）结束！");

    }

    private String sendMsg(ContractRegisterEntity entity, String subject, String content) {
        String[] msgRecUserIds = new String[]{entity.getInstallLeaderId().toString()};


        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));

        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(content);
        //消息类型
        msgParameter.setMsgType("bpmpass");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_ZHIYUANOA});
        msgParameter.setPcUrl(PC_URL+entity.getId());
        msgParameter.setMobileUrl(MOBILE_URL+entity.getId());
        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

}

