package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.vo.DeductionVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.income.mapper.DeductionMapper;
import com.ejianc.business.jlincome.income.bean.DeductionEntity;
import com.ejianc.business.jlincome.income.service.IDeductionService;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;

/**
 * 收入管理-甲方扣款
 * 
 * @author generator
 * 
 */
@Service("deductionService")
public class DeductionServiceImpl extends BaseServiceImpl<DeductionMapper, DeductionEntity> implements IDeductionService{
    @Autowired
    private IContractRegisterService contractRegisterService;

    @Override
    public void hasRecordUp(List<Long> idList,Integer hasRecord) {
        UpdateWrapper<DeductionEntity> updateWrapper = new UpdateWrapper();
        updateWrapper.in("id",idList);
        updateWrapper.set("has_record",hasRecord);
        super.update(updateWrapper);
    }

    @Override
    public JSONObject queryDeductionRecordByContId(Long contractId) {
        ContractRegisterEntity contractEntity = contractRegisterService.selectById(contractId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", contractEntity.getChangeStatus());
        jsonObject.put("billState", contractEntity.getBillState());

        LambdaQueryWrapper<DeductionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DeductionEntity::getContractId, contractId);
        queryWrapper.in(DeductionEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(DeductionEntity::getDeductionDate);

        List<DeductionEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<DeductionVO> deductionVOS = BeanMapper.mapList(list, DeductionVO.class);
            deductionVOS.sort(Comparator.comparing(DeductionVO::getDeductionDate));
            jsonObject.put("sumDeductionTaxMny", deductionVOS.stream().filter(p -> p.getDeductionTaxMny() != null).map(DeductionVO::getDeductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            jsonObject.put("detailList", deductionVOS);
        }
        return jsonObject;
    }
}
