package com.ejianc.business.jlincome.bid.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlincome.bid.bean.ResultRegisterDetailEntity;
/**
 * 投标管理-投标结果登记-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_result_register")
public class ResultRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 组织/区域主键
    @TableField(value="org_name")
    private String orgName; // 组织名称/区域名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码/区域编码
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="custom_name")
    private String customName; // 客户名称
    @TableField(value="project_type_id")
    private Long projectTypeId; // 项目类型
    @TableField(value="project_type_name")
    private String projectTypeName; // 项目类型名称
    @TableField(value="product_type")
    private String productType; // 产品类型
    @TableField(value="product_type_name")
    private String productTypeName; // 产品类型名称
    @TableField(value="sale_leader_id")
    private Long saleLeaderId; // 销售负责人
    @TableField(value="sale_leader_name")
    private String saleLeaderName; // 销售负责人名称
    @TableField(value="sale_leader_phone")
    private String saleLeaderPhone; // 销售负责人联系电话
    @TableField(value="product_name")
    private String productName; // 产品名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="num")
    private String num; // 数量
    @TableField(value="bid_win_mny")
    private BigDecimal bidWinMny; // 中标金额
    @TableField(value="bid_file_receive_date")
    private Date bidFileReceiveDate; // 招标文件接收日期
    @TableField(value="bid_date")
    private Date bidDate; // 投标日期
    @TableField(value="bid_open_date")
    private Date bidOpenDate; // 开标日期
    @TableField(value="bid_unit_id")
    private Long bidUnitId; // 投标单位
    @TableField(value="bid_unit_name")
    private String bidUnitName; // 投标单位名称
    @TableField(value="bid_unit_code")
    private String bidUnitCode; // 投标单位编码
    @TableField(value="bid_win_flag")
    private Boolean bidWinFlag; // 是否中标（0：否 1：是）
    @TableField(value="bid_dif_mny")
    private BigDecimal bidDifMny; // 投标差价
    @TableField(value="relate_install_flag")
    private Boolean relateInstallFlag; // 是否涉及安装（0：否 1：是）
    @TableField(value="install_leader_id")
    private Long installLeaderId; // 安装负责人
    @TableField(value="install_leader_name")
    private String installLeaderName; // 安装负责人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bid_avg_mny")
    private BigDecimal bidAvgMny; // 投标平均价（子表投标金额+主表投标金额）/（子表竞标单位行数+1）
    @TableField(value="bid_win_unit_name")
    private String bidWinUnitName; // 中标单位名称
    @TableField(value="compete_bid_unit_num")
    private Integer competeBidUnitNum; // 竞标单位数量
    @TableField(value="project_approval_date")
    private Date projectApprovalDate; // 立项日期
    @TableField(value="custom_link_name")
    private String customLinkName; // 客户联系人
    @TableField(value="custom_link_phone")
    private String customLinkPhone; // 客户联系人电话
    @TableField(value="contracting_unit")
    private String contractingUnit; // 总包单位
    @TableField(value="design_unit")
    private String designUnit; // 设计单位
    @TableField(value="national_id")
    private Long nationalId; // 项目国家
    @TableField(value="national_name")
    private String nationalName; // 项目国家
    @TableField(value="area")
    private String area; // 项目地区
    @TableField(value="area_name")
    private String areaName; // 项目地区
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="project_height")
    private String projectHeight; // 项目高度
    @TableField(value="project_span")
    private String projectSpan; // 项目跨度
    @TableField(value="plan_product_date")
    private Date planProductDate; // 预计生产日期
    @TableField(value="plan_deliver_date")
    private Date planDeliverDate; // 预计交货日期
    @TableField(value="plan_bid_win_date")
    private Date planBidWinDate; // 中标日期
    @TableField(value="project_status")
    private String projectStatus; // 项目阶段：已中标 未中标
    @TableField(value="project_situation")
    private String projectSituation; // 工程概况
    @TableField(value="source_id")
    private Long sourceId; // 来源id
    @TableField(value="source_code")
    private String sourceCode; // 来源编码
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型（0：手动新增 1：商机登记）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="resultRegisterDetailService",pidName = "bidResultRegisterId")
    private List<ResultRegisterDetailEntity> detailList = new ArrayList<>(); // 投标管理-投标结果登记-子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomName() {
        return customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }

    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public Long getSaleLeaderId() {
        return saleLeaderId;
    }

    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }
    public BigDecimal getBidWinMny() {
        return bidWinMny;
    }

    public void setBidWinMny(BigDecimal bidWinMny) {
        this.bidWinMny = bidWinMny;
    }
    public Date getBidFileReceiveDate() {
        return bidFileReceiveDate;
    }

    public void setBidFileReceiveDate(Date bidFileReceiveDate) {
        this.bidFileReceiveDate = bidFileReceiveDate;
    }

    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }

    public Date getBidOpenDate() {
        return bidOpenDate;
    }

    public void setBidOpenDate(Date bidOpenDate) {
        this.bidOpenDate = bidOpenDate;
    }

    public Long getBidUnitId() {
        return bidUnitId;
    }

    public void setBidUnitId(Long bidUnitId) {
        this.bidUnitId = bidUnitId;
    }
    public String getBidUnitName() {
        return bidUnitName;
    }

    public void setBidUnitName(String bidUnitName) {
        this.bidUnitName = bidUnitName;
    }
    public String getBidUnitCode() {
        return bidUnitCode;
    }

    public void setBidUnitCode(String bidUnitCode) {
        this.bidUnitCode = bidUnitCode;
    }
    public BigDecimal getBidDifMny() {
        return bidDifMny;
    }

    public void setBidDifMny(BigDecimal bidDifMny) {
        this.bidDifMny = bidDifMny;
    }

    public Boolean getBidWinFlag() {
        return bidWinFlag;
    }

    public void setBidWinFlag(Boolean bidWinFlag) {
        this.bidWinFlag = bidWinFlag;
    }

    public Boolean getRelateInstallFlag() {
        return relateInstallFlag;
    }

    public void setRelateInstallFlag(Boolean relateInstallFlag) {
        this.relateInstallFlag = relateInstallFlag;
    }

    public Long getInstallLeaderId() {
        return installLeaderId;
    }

    public void setInstallLeaderId(Long installLeaderId) {
        this.installLeaderId = installLeaderId;
    }
    public String getInstallLeaderName() {
        return installLeaderName;
    }

    public void setInstallLeaderName(String installLeaderName) {
        this.installLeaderName = installLeaderName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getBidAvgMny() {
        return bidAvgMny;
    }

    public void setBidAvgMny(BigDecimal bidAvgMny) {
        this.bidAvgMny = bidAvgMny;
    }
    public String getBidWinUnitName() {
        return bidWinUnitName;
    }

    public void setBidWinUnitName(String bidWinUnitName) {
        this.bidWinUnitName = bidWinUnitName;
    }
    public Integer getCompeteBidUnitNum() {
        return competeBidUnitNum;
    }

    public void setCompeteBidUnitNum(Integer competeBidUnitNum) {
        this.competeBidUnitNum = competeBidUnitNum;
    }

    public Date getProjectApprovalDate() {
        return projectApprovalDate;
    }

    public void setProjectApprovalDate(Date projectApprovalDate) {
        this.projectApprovalDate = projectApprovalDate;
    }

    public String getCustomLinkName() {
        return customLinkName;
    }

    public void setCustomLinkName(String customLinkName) {
        this.customLinkName = customLinkName;
    }
    public String getCustomLinkPhone() {
        return customLinkPhone;
    }

    public void setCustomLinkPhone(String customLinkPhone) {
        this.customLinkPhone = customLinkPhone;
    }
    public String getContractingUnit() {
        return contractingUnit;
    }

    public void setContractingUnit(String contractingUnit) {
        this.contractingUnit = contractingUnit;
    }
    public String getDesignUnit() {
        return designUnit;
    }

    public void setDesignUnit(String designUnit) {
        this.designUnit = designUnit;
    }
    public Long getNationalId() {
        return nationalId;
    }

    public void setNationalId(Long nationalId) {
        this.nationalId = nationalId;
    }
    public String getNationalName() {
        return nationalName;
    }

    public void setNationalName(String nationalName) {
        this.nationalName = nationalName;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getProjectHeight() {
        return projectHeight;
    }

    public void setProjectHeight(String projectHeight) {
        this.projectHeight = projectHeight;
    }
    public String getProjectSpan() {
        return projectSpan;
    }

    public void setProjectSpan(String projectSpan) {
        this.projectSpan = projectSpan;
    }
    public Date getPlanProductDate() {
        return planProductDate;
    }

    public void setPlanProductDate(Date planProductDate) {
        this.planProductDate = planProductDate;
    }
    public Date getPlanDeliverDate() {
        return planDeliverDate;
    }

    public void setPlanDeliverDate(Date planDeliverDate) {
        this.planDeliverDate = planDeliverDate;
    }
    public Date getPlanBidWinDate() {
        return planBidWinDate;
    }

    public void setPlanBidWinDate(Date planBidWinDate) {
        this.planBidWinDate = planBidWinDate;
    }
    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getProjectSituation() {
        return projectSituation;
    }

    public void setProjectSituation(String projectSituation) {
        this.projectSituation = projectSituation;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }


    public List<ResultRegisterDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ResultRegisterDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
