package com.ejianc.business.jlincome.bid.mapper;

import com.ejianc.business.jlincome.bid.vo.BusinessVO;
import com.ejianc.business.jlincome.bid.vo.ProjectProductVO;
import com.ejianc.business.jlincome.bid.vo.SalePromoteVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 投标-商机登记
 * 
 * @author generator
 * 
 */
@Mapper
public interface BusinessMapper extends BaseCrudMapper<BusinessEntity> {

    List<BusinessEntity> getNoReport();

    SalePromoteVO querySalePromoteData(@Param("startDate") String startDate, @Param("endDate") String endDate, @Param("businessIds") List<Long> businessIds);

    List<ProjectProductVO> queryBidProduct(@Param("orgIds") List<Long> orgIds, @Param("productIds") List<Long> productIds, @Param("startDate") String startDate, @Param("endDate") String endDate);

    List<ProjectProductVO> queryContractProduct(@Param("orgIds") List<Long> orgIds, @Param("productIds") List<Long> productIds, @Param("startDate") String startDate, @Param("endDate") String endDate);

    List<ProjectProductVO> queryBidProject(@Param("orgIds") List<Long> orgIds, @Param("projectIds") List<Long> projectIds, @Param("startDate") String startDate, @Param("endDate") String endDate);

    List<ProjectProductVO> queryContractProject(@Param("orgIds") List<Long> orgIds, @Param("projectIds") List<Long> projectIds, @Param("startDate") String startDate, @Param("endDate") String endDate);

    Integer querySjReportTopTen(@Param("start") String start, @Param("end") String end, @Param("orgIds") List<Long>  orgIds);

    Integer queryZbReportTopTen(@Param("start") String start, @Param("end") String end, @Param("orgIds") List<Long>  orgIds);

    Integer querySjReportNum(@Param("start") String start, @Param("end") String end);

    Integer queryZbReportNum(@Param("start") String start, @Param("end") String end);

}
