package com.ejianc.business.jlincome.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportVO;
import com.ejianc.business.jlincome.income.bean.DisclosureDepDetailsEntity;
import com.ejianc.business.jlincome.income.bean.DisclosureEntity;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.juli.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.bid.mapper.EngineeringReportMapper;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import org.springframework.util.CollectionUtils;

import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.List;

/**
 * 投标-工程调研报告
 *
 * @author generator
 */
@Service("engineeringReportService")
public class EngineeringReportServiceImpl extends BaseServiceImpl<EngineeringReportMapper, EngineeringReportEntity> implements IEngineeringReportService {
    @Autowired
    private BusinessMapper businessMapper;
    @Autowired
    private IPushMessageApi pushMessageApi;

    private static final String PC_URL = "/ejc-jlincome-frontend/#/engineeringReport/card?id=";
    private static final String MOBILE_URL = "/ejc-jlincome-mobile/#/engineeringReport/card?id=";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public boolean checkIsExist(EngineeringReportVO reportVO) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<EngineeringReportEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(EngineeringReportEntity::getEngineeringId, reportVO.getEngineeringId());
        lambda.eq(EngineeringReportEntity::getTenantId, tenantId);
        if (null != reportVO.getId() && reportVO.getId() > 0) {
            lambda.ne(EngineeringReportEntity::getId, reportVO.getId());
        }
        return super.list(lambda).size() > 0;

    }

    @Override
    public void sendMsgToInstallPerson(EngineeringReportEntity entity) {
        logger.info("安装负责人”推送系统消息，OA消息（钉钉消息）");
        //消息内容：XXX项目有一项重要的合同交底需要查看！！！支持链接打开查看详情
        String msg = this.sendMsg(entity,"安装负责人”推送系统消息，OA消息（钉钉消息）","你有一个施工报价，请尽快处理！点击查看详情！！！");
        if (StringUtils.isNotBlank(msg)){
            logger.error("安装负责人”推送系统消息，OA消息（钉钉消息） 异常：" + msg);
        }
        logger.info("安装负责人”推送系统消息，OA消息（钉钉消息）结束！");

    }

    private String sendMsg(EngineeringReportEntity entity, String subject, String content) {
        String[] msgRecUserIds = new String[]{entity.getInstallLeaderId().toString()};

        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(content);
        //消息类型
        msgParameter.setMsgType("bpmpass");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_ZHIYUANOA});
        msgParameter.setPcUrl(PC_URL + entity.getId());
        msgParameter.setMobileUrl(MOBILE_URL + entity.getId());
        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        return msgSendResp.isSuccess() ? null : msgSendResp.getMsg();

    }
}
