package com.ejianc.business.jlincome.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlincome.income.bean.ContractRegisterRecordDetailEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterRecordClauseEntity;
/**
 * 收入管理-合同登记-记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_contract_register_record")
public class ContractRegisterRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 合同编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 项目部Id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="review_id")
    private Long reviewId; // 合同评审Id
    @TableField(value="review_name")
    private String reviewName; // 合同评审名称
    @TableField(value="review_code")
    private String reviewCode; // 合同评审编码
    @TableField(value="undertake_unit_id")
    private Long undertakeUnitId; // 承接单位
    @TableField(value="undertake_unit_name")
    private String undertakeUnitName; // 承接单位名称
    @TableField(value="customer_id")
    private Long customerId; // 客户id
    @TableField(value="customer_name")
    private String customerName; // 客户名称
    @TableField(value="customer_code")
    private String customerCode; // 客户编码
    @TableField(value="custom_link_name")
    private String customLinkName; // 客户联系人
    @TableField(value="custom_link_phone")
    private String customLinkPhone; // 客户联系人电话
    @TableField(value="project_type_id")
    private Long projectTypeId; // 项目类型
    @TableField(value="project_type_name")
    private String projectTypeName; // 项目类型名称
    @TableField(value="product_type")
    private String productType; // 产品类型
    @TableField(value="product_type_name")
    private String productTypeName; // 产品类型名称
    @TableField(value="receive_date")
    private Date receiveDate; // 合同接收日期
    @TableField(value="sign_date")
    private Date signDate; // 合同签订日期
    @TableField(value="delivery_date")
    private Date deliveryDate; // 交货日期
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额（无税）
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="warranty_tax_mny")
    private BigDecimal warrantyTaxMny; // 质保金
    @TableField(value="warranty_mny")
    private BigDecimal warrantyMny; // 质保金（无税）
    @TableField(value="spec_num")
    private String specNum; // 产品规格数量
    @TableField(value="sale_leader_id")
    private Long saleLeaderId; // 销售负责人
    @TableField(value="sale_leader_name")
    private String saleLeaderName; // 销售负责人名称
    @TableField(value="sale_leader_phone")
    private String saleLeaderPhone; // 销售负责人联系电话
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="performance_status")
    private String performanceStatus; // 合同履状态：1、未签订；2、履约中；3、已封账；
    @TableField(value="pay_condition")
    private String payCondition; // 付款条件
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="base_mny")
    private BigDecimal baseMny; // 初始版本金额
    @TableField(value="base_tax_mny")
    private BigDecimal baseTaxMny; // 初始版本(含税)金额
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value="changing_tax_mny")
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="change_contract_name")
    private String changeContractName; // 变更合同名称
    @TableField(value="change_memo")
    private String changeMemo; // 变更原因
    @TableField(value="contract_id")
    private Long contractId; // 原合同id
    @TableField(value="effect_date")
    private Date effectDate; // 生效时间
    @TableField(value="project_height")
    private String projectHeight; // 项目高度
    @TableField(value="project_span")
    private String projectSpan; // 项目跨度
    @TableField(value="install_leader_id")
    private Long installLeaderId; // 安装负责人
    @TableField(value="install_leader_name")
    private String installLeaderName; // 安装负责人
    @TableField(value="file_type_id")
    private Long fileTypeId; // 附件类型
    @TableField(value="file_type_name")
    private String fileTypeName; // 附件类型名称
    
    @TableField(exist=false)
    @SubEntity(serviceName="contractRegisterRecordDetailService", pidName = "contractRegisterId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractRegisterRecordDetailEntity> detailList = new ArrayList<>(); // 收入管理-合同登记-记录-合同明细
    @TableField(exist=false)
    @SubEntity(serviceName="contractRegisterRecordClauseService", pidName = "contractRegisterId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractRegisterRecordClauseEntity> clauseList = new ArrayList<>(); // 收入管理-合同登记-记录-合同条款

    public Long getInstallLeaderId() {
        return installLeaderId;
    }

    public void setInstallLeaderId(Long installLeaderId) {
        this.installLeaderId = installLeaderId;
    }

    public String getInstallLeaderName() {
        return installLeaderName;
    }

    public void setInstallLeaderName(String installLeaderName) {
        this.installLeaderName = installLeaderName;
    }

    public String getProjectHeight() {
        return projectHeight;
    }

    public void setProjectHeight(String projectHeight) {
        this.projectHeight = projectHeight;
    }

    public String getProjectSpan() {
        return projectSpan;
    }

    public void setProjectSpan(String projectSpan) {
        this.projectSpan = projectSpan;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getReviewId() {
        return reviewId;
    }

    public void setReviewId(Long reviewId) {
        this.reviewId = reviewId;
    }
    public String getReviewName() {
        return reviewName;
    }

    public void setReviewName(String reviewName) {
        this.reviewName = reviewName;
    }
    public String getReviewCode() {
        return reviewCode;
    }

    public void setReviewCode(String reviewCode) {
        this.reviewCode = reviewCode;
    }
    public Long getUndertakeUnitId() {
        return undertakeUnitId;
    }

    public void setUndertakeUnitId(Long undertakeUnitId) {
        this.undertakeUnitId = undertakeUnitId;
    }
    public String getUndertakeUnitName() {
        return undertakeUnitName;
    }

    public void setUndertakeUnitName(String undertakeUnitName) {
        this.undertakeUnitName = undertakeUnitName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }
    public String getCustomLinkName() {
        return customLinkName;
    }

    public void setCustomLinkName(String customLinkName) {
        this.customLinkName = customLinkName;
    }
    public String getCustomLinkPhone() {
        return customLinkPhone;
    }

    public void setCustomLinkPhone(String customLinkPhone) {
        this.customLinkPhone = customLinkPhone;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }

    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getSpecNum() {
        return specNum;
    }

    public void setSpecNum(String specNum) {
        this.specNum = specNum;
    }
    public Long getSaleLeaderId() {
        return saleLeaderId;
    }

    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public String getPayCondition() {
        return payCondition;
    }

    public void setPayCondition(String payCondition) {
        this.payCondition = payCondition;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }
    public String getChangeMemo() {
        return changeMemo;
    }

    public void setChangeMemo(String changeMemo) {
        this.changeMemo = changeMemo;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public List<ContractRegisterRecordDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractRegisterRecordDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<ContractRegisterRecordClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractRegisterRecordClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public BigDecimal getWarrantyTaxMny() {
        return warrantyTaxMny;
    }

    public void setWarrantyTaxMny(BigDecimal warrantyTaxMny) {
        this.warrantyTaxMny = warrantyTaxMny;
    }

    public BigDecimal getWarrantyMny() {
        return warrantyMny;
    }

    public void setWarrantyMny(BigDecimal warrantyMny) {
        this.warrantyMny = warrantyMny;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Long getFileTypeId() {
        return fileTypeId;
    }

    public void setFileTypeId(Long fileTypeId) {
        this.fileTypeId = fileTypeId;
    }

    public String getFileTypeName() {
        return fileTypeName;
    }

    public void setFileTypeName(String fileTypeName) {
        this.fileTypeName = fileTypeName;
    }
}
