package com.ejianc.business.jlincome.income.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jlcost.finance.api.IInvoiceReceiveApi;
import com.ejianc.business.jlincome.income.enums.PerformanceStatusEnum;
import com.ejianc.business.jlincome.income.enums.ChangeStatusEnum;
import com.ejianc.business.jlincome.income.service.ISettleService;
import com.ejianc.business.jlincome.income.service.IUserReportService;
import com.ejianc.business.jlincome.income.vo.ContractRegisterReportVO;
import com.ejianc.business.jlincome.income.vo.ProjectBoardTwoVO;
import com.ejianc.business.jlincome.income.vo.ProjectBoardVO;
import com.ejianc.business.jlprogress.order.api.IOrderApi;
import com.ejianc.business.jlprogress.order.vo.SalesListVO;
import com.ejianc.business.jlprogress.order.vo.SalesVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.Null;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.vo.ContractRegisterVO;

/**
 * 收入管理-合同登记
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("contractRegister")
public class ContractRegisterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "CONTRACT_REGISTER";//此处需要根据实际修改


    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOrderApi  iOrderApi;

    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    @Autowired
    private IContractRegisterService service;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IUserReportService userReportService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IInvoiceReceiveApi invoiceReceiveApi;

    @Autowired
    private IOrderApi orderApi;

    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-t06Tq40019";


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> saveOrUpdate(@RequestBody ContractRegisterVO saveOrUpdateVO) {
    	ContractRegisterEntity entity = BeanMapper.map(saveOrUpdateVO, ContractRegisterEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());

            //如果编码为空，就新增编码
            if (StringUtils.isBlank(entity.getBillCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }else {
                //验证编码是否唯一
                if (service.checkSameBillCode(BeanMapper.map(entity, ContractRegisterVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }else {
            //校验编码
            if (StringUtils.isBlank(entity.getBillCode())){
                ContractRegisterEntity oldEntity = service.selectById(entity.getId());
                entity.setBillCode(oldEntity.getBillCode());
            }else {
                //验证编码是否唯一
                if (service.checkSameBillCode(BeanMapper.map(entity, ContractRegisterVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }

        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());

    	service.saveOrUpdate(entity, false);
    	ContractRegisterVO vo = BeanMapper.map(entity, ContractRegisterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractRegisterVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ContractRegisterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ContractRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("projectTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = null;
        if(param.getParams().containsKey("orgId")){
            orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().remove("orgId");
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else {
            orgId = InvocationInfoProxy.getOrgId();
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }


        IPage<ContractRegisterEntity> page = service.queryPage(param,false);
        IPage<ContractRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ContractRegisterVO> contractRegisterVOList = BeanMapper.mapList(page.getRecords(), ContractRegisterVO.class);
        if (canUpdateAll()){
            contractRegisterVOList.forEach(e -> {
                e.setUpdateFileTypeFlag(1);
            });
        }
        pageData.setRecords(contractRegisterVOList);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("projectTypeName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<ContractRegisterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<ContractRegisterVO> voList = BeanMapper.mapList(list, ContractRegisterVO.class);
        voList.forEach(e -> {
            if(PerformanceStatusEnum.未签订.getCode().equals(e.getPerformanceStatus())){
                e.setPerformanceStatusName(PerformanceStatusEnum.未签订.getDescription());
            }else if(PerformanceStatusEnum.履约中.getCode().equals(e.getPerformanceStatus())){
                e.setPerformanceStatusName(PerformanceStatusEnum.履约中.getDescription());
            }else{
                e.setPerformanceStatusName(PerformanceStatusEnum.已封账.getDescription());
            }

            if(ChangeStatusEnum.未变更.getCode() == e.getChangeStatus()){
                e.setChangeStatusName(ChangeStatusEnum.未变更.getDescription());
            }else  if(ChangeStatusEnum.变更中.getCode() == e.getChangeStatus()){
                e.setChangeStatusName(ChangeStatusEnum.变更中.getDescription());
            }else{
                e.setChangeStatusName(ChangeStatusEnum.已变更.getDescription());
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("ContractRegister-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refContractRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterVO>> refContractRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        param.getParams().put("customerId", new Parameter(QueryParam.NE, null));
        //如果没有参数type，则显示有客户id的数据
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("type")){
                param.getParams().remove("customerId");
            }
        }

        //设置模糊查询
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("undertakeUnitName");

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));
//        param.getParams().put("performanceStatus", new Parameter(QueryParam.IN, Arrays.asList(
//                PerformanceStatusEnum.未签订.getCode(),
//                PerformanceStatusEnum.履约中.getCode()
//        )));
        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ContractRegisterEntity> page = service.queryPage(param,false);
        IPage<ContractRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRegisterVO.class));

        List<ContractRegisterVO> records = pageData.getRecords();
        List<Long> ids = records.stream().map(ContractRegisterVO::getId).collect(Collectors.toList());
        CommonResponse<Map<Long, SalesListVO>> commonResponse = iOrderApi.getSalesByContractIds(ids);
        Map<Long, SalesListVO> map = commonResponse.getData();
        for (ContractRegisterVO record : records) {
            if(map.containsKey(record.getId())){
                if(!ObjectUtils.isEmpty(map.get(record.getId()))){
                    record.setIsMaked("已下单");
                }else {
                    record.setIsMaked("未下单");
                }
            }
        }
        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "ContractRegisterDetail-import.xlsx", "合同登记-导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = service.excelImport(request,response);
        return commonResponse;
    }


    /**
     * 合同状态修改
     *
     * @param contractVO
     * @return
     */
    @RequestMapping(value = "/changeState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ContractRegisterVO contractVO) {
        LambdaUpdateWrapper<ContractRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ContractRegisterEntity::getId,contractVO.getId());
        updateWrapper.set(ContractRegisterEntity::getPerformanceStatus, contractVO.getPerformanceStatus());
        service.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * 合同附件类型修改
     *
     * @param contractVO
     * @return
     */
    @RequestMapping(value = "/changeFileType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeFileType(@RequestBody ContractRegisterVO contractVO) {
        LambdaUpdateWrapper<ContractRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ContractRegisterEntity::getId,contractVO.getId());
        updateWrapper.set(ContractRegisterEntity::getFileTypeId, contractVO.getFileTypeId());
        updateWrapper.set(ContractRegisterEntity::getFileTypeName, contractVO.getFileTypeName());
        service.update(updateWrapper);
        return CommonResponse.success("修改附件类型成功！");
    }


    public Boolean canUpdateAll() {
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            if (StringUtils.isNotEmpty(valueData)) {
                Long userid = InvocationInfoProxy.getUserid();
                CommonResponse<List<RoleVO>> roleRes = roleApi.queryRoleByUserId(userid);
                if (roleRes.isSuccess() && CollectionUtils.isNotEmpty(roleRes.getData())) {
                    List<String> valList = Arrays.asList(valueData.split(",|，"));
                    for (RoleVO roleVO : roleRes.getData()) {
                        if (valList.contains(roleVO.getCode())) return Boolean.TRUE;
                    }
                }
            }
        }
        return Boolean.FALSE;
    }


    /**
     * @Description 根据项目id查询已生效的合同总金额
     * @Return void
     */
    @RequestMapping(value = "/queryContractMnyByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryContractMnyByProjectId(@RequestParam Long projectId) {
        logger.info("接收项目id：{}", projectId.toString());
        return CommonResponse.success("根据项目查询合同金额成功！", service.queryContractMnyByProjectId(projectId));
    }


    /**
     * @Description queryList 合同登记台账
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryContractRegisterReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterReportVO>> queryContractRegisterReportList(@RequestBody QueryParam param) throws ParseException {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("payCondition");
        fuzzyFields.add("saleLeaderName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<ContractRegisterReportVO> registerReportVOList = new ArrayList<>();
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));

        IPage<ContractRegisterEntity> page = service.queryPage(param,false);
        if (null != page.getRecords() && page.getRecords().size() > 0){
            List<ContractRegisterVO> contractRegisterVOList = BeanMapper.mapList(page.getRecords(), ContractRegisterVO.class);
            List<Long> contractIdList = contractRegisterVOList.stream().map(ContractRegisterVO::getId).collect(Collectors.toList());
            //获取合同id集合
            logger.info("获取合同id集合：{}", JSONObject.toJSONString(contractIdList));
            CommonResponse<JSONObject> invoiceReceiveDataRes = invoiceReceiveApi.getInvoiceReceiveDataByContractIdList(contractIdList);
            if (!invoiceReceiveDataRes.isSuccess()){
                throw new BusinessException("获取合同登记下游开票、收款信息失败！原因-" + invoiceReceiveDataRes.getMsg());
            }
            String invoiceReceiveDataStr = invoiceReceiveDataRes.getData().toJSONString();
            CommonResponse<JSONObject> orderDataRes = orderApi.getOrderDataByContractIdList(contractIdList);
            if (!orderDataRes.isSuccess()){
                throw new BusinessException("获取合同登记下游销售、发货、验收信息失败！原因-" + orderDataRes.getMsg());
            }
            String orderDataStr = orderDataRes.getData().toJSONString();
            Map<Long, JSONObject> settleDataMap = settleService.querySettleRecordByContIdList(contractIdList);

            Map<Long, Long> userReportMap = userReportService.queryIdsByContractIds(contractIdList);


            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
            for (ContractRegisterVO record : contractRegisterVOList) {
                ContractRegisterReportVO reportVO = BeanMapper.map(record, ContractRegisterReportVO.class);
                JSONObject invoiceReceiveData = JSONObject.parseObject(invoiceReceiveDataStr);
                if (invoiceReceiveData.containsKey(record.getId())){
                    JSONObject invoiceReceive = JSONObject.parseObject(invoiceReceiveData.getString(record.getId().toString()), JSONObject.class);
                    if (invoiceReceive.size() > 0){
                        if (null != invoiceReceive.get("sumInvoiceTaxMny")){
                            reportVO.setSumInvoiceTaxMny(new BigDecimal(invoiceReceive.get("sumInvoiceTaxMny").toString()));
                        }
                        if (null != invoiceReceive.get("sumReceiveTaxMny")){
                            reportVO.setSumReceiveTaxMny(new BigDecimal(invoiceReceive.get("sumReceiveTaxMny").toString()));
                        }
                        if (null != invoiceReceive.get("invoiceDetailList")){
                            reportVO.setInvoiceDetailList(JSONObject.parseArray(invoiceReceive.get("invoiceDetailList").toString(), JSONObject.class));
                            for (JSONObject jsonObject : reportVO.getInvoiceDetailList()) {
                                if (null != jsonObject.get("detailDate")){
                                    jsonObject.put("detailDate", sim.format(new Date(Long.valueOf(jsonObject.get("detailDate").toString()))));
                                }
                            }
                        }
                        if (null != invoiceReceive.get("receiveDetailList")){
                            reportVO.setReceiveDetailList(JSONObject.parseArray(invoiceReceive.get("receiveDetailList").toString(), JSONObject.class));
                            for (JSONObject jsonObject : reportVO.getReceiveDetailList()) {
                                if (null != jsonObject.get("receiveTime")){
                                    jsonObject.put("receiveTime", sim.format(new Date(Long.valueOf(jsonObject.get("receiveTime").toString()))));
                                }
                            }
                        }
                    }
                }
                JSONObject orderData = JSONObject.parseObject(orderDataStr);
                if (orderData.containsKey(record.getId())){
                    JSONObject order = JSONObject.parseObject(orderData.getString(record.getId().toString()), JSONObject.class);
                    if (order.size() > 0){
                        if (null != order.get("firstOrderDate")){
                            reportVO.setFirstOrderDate(new Date(Long.valueOf(order.get("firstOrderDate").toString())));
                        }
                        if (null != order.get("productOutState")){
                            reportVO.setProductOutState((order.get("productOutState").toString()));
                        }
                        if (null != order.get("checkState")){
                            reportVO.setCheckState((order.get("checkState").toString()));
                        }
                        if (null != order.get("salesList")){
                            reportVO.setSalesList(JSONObject.parseArray(order.get("salesList").toString(), JSONObject.class));
                        }
                        if (null != order.get("productOutVOList")){
                            reportVO.setProductOutVOList(JSONObject.parseArray(order.get("productOutVOList").toString(), JSONObject.class));
                        }
                        if (null != order.get("checkList")){
                            reportVO.setCheckList(JSONObject.parseArray(order.get("checkList").toString(), JSONObject.class));
                            for (JSONObject jsonObject : reportVO.getCheckList()) {
                                if (null != jsonObject.get("payDate")){
                                    jsonObject.put("payDate", sim.format(new Date(Long.valueOf(jsonObject.get("payDate").toString()))));
                                }
                                if (null != jsonObject.get("checkDate")){
                                    jsonObject.put("checkDate", sim.format(new Date(Long.valueOf(jsonObject.get("checkDate").toString()))));
                                }
                            }
                        }
                        if (null != order.get("deliveryNoticeList")){
                            reportVO.setDeliveryNoticeList(JSONObject.parseArray(order.get("deliveryNoticeList").toString(), JSONObject.class));
                            reportVO.setDeliveryNoticeNum(reportVO.getDeliveryNoticeList().size());
                        }
                    }
                }
                if (settleDataMap.containsKey(record.getId())){
                    JSONObject settle = JSONObject.parseObject(String.valueOf(settleDataMap.get(record.getId())), JSONObject.class);
                    if (settle.size() > 0){
                        if (null != settle.get("sumSettleTaxMny")){
                            reportVO.setSumSettleTaxMny(new BigDecimal(settle.get("sumSettleTaxMny").toString()));
                        }
                        if (null != settle.get("settleList")){
                            reportVO.setSettleList(JSONObject.parseArray(settle.get("settleList").toString(), JSONObject.class));
                            for (JSONObject jsonObject : reportVO.getSettleList()) {
                                if (null != jsonObject.get("settleDate")){
                                    jsonObject.put("settleDate", sim.format(new Date(Long.valueOf(jsonObject.get("settleDate").toString()))));
                                }
                            }
                        }
                    }
                }
                if (userReportMap.containsKey(record.getId())){
                    reportVO.setUserReportId(userReportMap.get(record.getId()));
                }

                registerReportVOList.add(reportVO);
            }
        }

        IPage<ContractRegisterReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(registerReportVOList);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/reportExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void reportExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("payCondition");
        fuzzyFields.add("saleLeaderName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<ContractRegisterReportVO> registerReportVOList = new ArrayList<>();
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));

        IPage<ContractRegisterEntity> page = service.queryPage(param,false);
        if (null != page.getRecords() && page.getRecords().size() > 0){
            List<ContractRegisterVO> contractRegisterVOList = BeanMapper.mapList(page.getRecords(), ContractRegisterVO.class);
            List<Long> contractIdList = contractRegisterVOList.stream().map(ContractRegisterVO::getId).collect(Collectors.toList());
            //获取合同id集合
            logger.info("获取合同id集合：{}", JSONObject.toJSONString(contractIdList));
            CommonResponse<JSONObject> invoiceReceiveDataRes = invoiceReceiveApi.getInvoiceReceiveDataByContractIdList(contractIdList);
            if (!invoiceReceiveDataRes.isSuccess()){
                throw new BusinessException("获取合同登记下游开票、收款信息失败！原因-" + invoiceReceiveDataRes.getMsg());
            }
            String invoiceReceiveDataStr = invoiceReceiveDataRes.getData().toJSONString();
            CommonResponse<JSONObject> orderDataRes = orderApi.getOrderDataByContractIdList(contractIdList);
            if (!orderDataRes.isSuccess()){
                throw new BusinessException("获取合同登记下游销售、发货、验收信息失败！原因-" + orderDataRes.getMsg());
            }
            String orderDataStr = orderDataRes.getData().toJSONString();
            Map<Long, JSONObject> settleDataMap = settleService.querySettleRecordByContIdList(contractIdList);


            for (ContractRegisterVO record : contractRegisterVOList) {
                ContractRegisterReportVO reportVO = BeanMapper.map(record, ContractRegisterReportVO.class);
                JSONObject invoiceReceiveData = JSONObject.parseObject(invoiceReceiveDataStr);
                if (invoiceReceiveData.containsKey(record.getId())){
                    JSONObject invoiceReceive = JSONObject.parseObject(invoiceReceiveData.getString(record.getId().toString()), JSONObject.class);
                    if (invoiceReceive.size() > 0){
                        if (null != invoiceReceive.get("sumInvoiceTaxMny")){
                            reportVO.setSumInvoiceTaxMny(new BigDecimal(invoiceReceive.get("sumInvoiceTaxMny").toString()));
                        }
                        if (null != invoiceReceive.get("sumReceiveTaxMny")){
                            reportVO.setSumReceiveTaxMny(new BigDecimal(invoiceReceive.get("sumReceiveTaxMny").toString()));
                        }
                        if (null != invoiceReceive.get("invoiceDetailList")){
                            reportVO.setInvoiceDetailList(JSONObject.parseArray(invoiceReceive.get("invoiceDetailList").toString(), JSONObject.class));
                        }
                        if (null != invoiceReceive.get("receiveDetailList")){
                            reportVO.setReceiveDetailList(JSONObject.parseArray(invoiceReceive.get("receiveDetailList").toString(), JSONObject.class));
                        }
                    }
                }
                JSONObject orderData = JSONObject.parseObject(orderDataStr);
                if (orderData.containsKey(record.getId())){
                    JSONObject order = JSONObject.parseObject(orderData.getString(record.getId().toString()), JSONObject.class);
                    if (order.size() > 0){
                        if (null != order.get("firstOrderDate")){
                            reportVO.setFirstOrderDate(new Date(Long.valueOf(order.get("firstOrderDate").toString())));
                        }
                        if (null != order.get("productOutState")){
                            reportVO.setProductOutState((order.get("productOutState").toString()));
                        }
                        if (null != order.get("checkState")){
                            reportVO.setCheckState((order.get("checkState").toString()));
                        }
                        if (null != order.get("salesList")){
                            reportVO.setSalesList(JSONObject.parseArray(order.get("salesList").toString(), JSONObject.class));
                        }
                        if (null != order.get("productOutVOList")){
                            reportVO.setProductOutVOList(JSONObject.parseArray(order.get("productOutVOList").toString(), JSONObject.class));
                        }
                        if (null != order.get("checkList")){
                            reportVO.setCheckList(JSONObject.parseArray(order.get("checkList").toString(), JSONObject.class));
                        }
                        if (null != order.get("deliveryNoticeList")){
                            reportVO.setDeliveryNoticeNum(reportVO.getDeliveryNoticeList().size());
                        }
                    }
                }
                if (settleDataMap.containsKey(record.getId())){
                    JSONObject settle = JSONObject.parseObject(String.valueOf(settleDataMap.get(record.getId())), JSONObject.class);
                    if (settle.size() > 0){
                        if (null != settle.get("sumSettleTaxMny")){
                            reportVO.setSumSettleTaxMny(new BigDecimal(settle.get("sumSettleTaxMny").toString()));
                        }
                        if (null != settle.get("settleList")){
                            reportVO.setSettleList(JSONObject.parseArray(settle.get("settleList").toString(), JSONObject.class));
                        }
                    }
                }

                registerReportVOList.add(reportVO);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", registerReportVOList);
        ExcelExport.getInstance().export("ContractRegisterReport-export.xlsx", beans, response);
    }





    /**
     * 项目一览看板
     * @param
     * @return
     * @throws ParseException
     */
    @RequestMapping(value = "/queryContractBoardList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectBoardVO> queryContractBoardList(@RequestBody QueryParam param) {
        ProjectBoardVO projectBoardVO = service.queryContractBoardList(param);
        return CommonResponse.success("查询项目看板数据成功！", projectBoardVO);
    }

    /**
     * 项目信息看板
     * @param
     * @return
     * @throws ParseException
     */
    @RequestMapping(value = "/queryProjectBoardList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectBoardList(@RequestBody QueryParam param) {
        int pageSize = param.getPageSize();
        int pageIndex = param.getPageIndex();
        String warnNum = null;
        if (null != param.getParams().get("warnNum")) {
            warnNum = param.getParams().get("warnNum").getValue().toString();
            param.getParams().remove("warnNum");
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        if (!param.getParams().containsKey("projectStatus")){
            param.getParams().put("projectStatus", new Parameter(QueryParam.NOT_IN, Arrays.asList(1, 2, 3)));
        }
        CommonResponse<Page<ProjectArchiveVO>> projectResponse = projectArchiveApi.queryProjectArchivePage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("网络异常， 获取项目失败， 请稍后再试");
        }
        List<ProjectArchiveVO> projectRecords = projectResponse.getData().getRecords();
        int total = projectRecords.size();

        projectRecords = projectRecords.stream().skip((pageIndex - 1) * pageSize)
                .limit(pageSize).collect(Collectors.toList());
        List<ProjectBoardTwoVO> projectBoardTwoVOList = service.queryProjectBoardList(param, projectRecords);

//        IPage<ProjectBoardTwoVO> pageData = new Page<>(pageIndex, pageSize, projectBoardTwoVOList.size());
//        pageData.setTotal(total);
//        pageData.setRecords(projectBoardTwoVOList);
//        return CommonResponse.success("查询项目看板数据成功！",pageData);



        JSONObject page = new JSONObject();
        page.put("records", projectBoardTwoVOList);
        page.put("total", total);
        page.put("current", pageIndex);
        page.put("size", pageSize);
        page.put("pages", Math.ceil(total/pageSize) + 1);
        page.put("warnNum", warnNum);
        return CommonResponse.success("查询列表数据成功！",page);
    }

}
