package com.ejianc.business.jlincome.income.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.mapper.EngineeringReportMapper;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.warn.vo.WarningReceiveVO;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.income.bean.ReviewEntity;
import com.ejianc.business.jlincome.income.service.IReviewService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import java.text.DecimalFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Controller
@RequestMapping("/warn/")
public class WarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String REVIEW_WARN_NAME = "合同评审未制单";
    private static final String REGISTER_WARN_NAME = "登记未制单";
    private static final String SETTLE_WARN_NAME = "对甲结算未制单";
    private static final String PROJECT_WBS_WARN_NAME = "项目待编写wbs";
    private static final String PROJECT_REPORT_WARN_NAME = "工程待出图询价";
    private static final String WBS_URL = "/ejc-share-frontend/#/projectWbs";// 项目虚拟资金账户统计详情
    private static final String REPORT_URL = "/ejc-jlincome-frontend/#/engineeringReport";// 项目虚拟资金账户统计详情
    private static final String REVIEW_URL = "/ejc-jlincome-frontend/#/review";
    private static final String REGISTER_URL = "/ejc-jlincome-frontend/#/contractRegister";
    private static final String SETTLE_URL = "/ejc-jlincome-frontend/#/settle";
    @Autowired
    private IReviewService reviewService;

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;
    @Autowired
    private BusinessMapper businessMapper;

    @Autowired
    private EngineeringReportMapper engineeringReportMapper;


    /**
     * 合同评审 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "reviewWarn")
    public CommonResponse<String> reviewWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        QueryParam param = new QueryParam();
        HashMap<String, Parameter> map = new HashMap<>();
        ArrayList<Object> Status = new ArrayList<>();
        Status.add(ArchiveProjectStatusEnum.已中标.getCode());
        Status.add(ArchiveProjectStatusEnum.合同阶段.getCode());
        Status.add(ArchiveProjectStatusEnum.生产阶段.getCode());
        Status.add(ArchiveProjectStatusEnum.供货阶段.getCode());
        Status.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        map.put("projectStatus", new Parameter(QueryParam.IN, Status));
        map.put("dr", new Parameter(QueryParam.EQ, 0));
        param.setParams(map);

        // 项目表 中已中标的项目 但未 进行合同评审
        CommonResponse<Page<ProjectArchiveVO>> page = projectApi.queryProjectArchivePage(param);
        List<ProjectArchiveVO> recordsList = page.getData().getRecords();
        //评审表
        List<ReviewEntity> reviewList = reviewService.selectList();

        List<Long> projectIds = reviewList.stream().map(ReviewEntity::getProjectId).collect(Collectors.toList());
        //过滤出 没有做 合同评审 的项目
        List<ProjectArchiveVO> filteredRecordsList = recordsList.stream()
                .filter(record -> !projectIds.contains(record.getId())) // 只保留不在 projectIds 中的记录
                .collect(Collectors.toList());

        if (CollectionUtils.isEmpty(filteredRecordsList)) {
            logger.error("执行" + REVIEW_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        logger.info("未做合同评审的数据：{}", JSONObject.toJSONString(filteredRecordsList));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.筛出符合条件的数据发送信息
        for (ProjectArchiveVO projectArchiveVO : filteredRecordsList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(projectArchiveVO.getName());
            vo.setPcTitle("合同评审");
//            vo.setPcUrl(REVIEW_URL + projectArchiveVO.getId().toString() + "&projectName=" + projectArchiveVO.getName());
            vo.setPcUrl(REVIEW_URL);
            vo.setOrgId(projectArchiveVO.getProjectDepartmentId());
            vo.setOrgName(projectArchiveVO.getProjectDepartmentName());
            vo.setSourceId(projectArchiveVO.getId().toString());
            vo.setTenantId(999999L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            List<WarningReceiveVO> receiveList =new ArrayList<>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            receiveVO.setName(projectArchiveVO.getSaleLeaderName());//销售负责人名称
            receiveVO.setNameId(projectArchiveVO.getSaleLeaderId());//负责人id
            receiveVO.setType("user"); //类型
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#projectName#", projectArchiveVO.getName())
            );
            resp.add(vo);
        }

        return sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }


    /**
     * 合同登记 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "contractRegisterWarn")
    public CommonResponse<String> contractRegisterWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        // 项目信息
        List<ReviewEntity> list = reviewService.selectReviewList();

        if (CollectionUtils.isEmpty(list)) {
            logger.error("执行" + REGISTER_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        logger.info("未做合同登记的数据：{}", JSONObject.toJSONString(list));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.筛出符合条件的数据发送信息
        for (ReviewEntity reviewEntity : list) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(reviewEntity.getProjectName());
            vo.setPcTitle("合同登记");
//            vo.setPcUrl(REGISTER_URL + reviewEntity.getId().toString() + "&projectName=" + reviewEntity.getProjectName());
            vo.setPcUrl(REGISTER_URL);
            vo.setOrgId(reviewEntity.getOrgId());
            vo.setOrgName(reviewEntity.getOrgName());
            vo.setSourceId(reviewEntity.getId().toString());
            vo.setTenantId(999999L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            List<WarningReceiveVO> receiveList =new ArrayList<>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            receiveVO.setName(reviewEntity.getSaleLeaderName());//销售负责人名称
            receiveVO.setNameId(reviewEntity.getSaleLeaderId());//负责人id
            receiveVO.setType("user"); //类型
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#projectName#", reviewEntity.getProjectName())
            );
            resp.add(vo);
        }

        return sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 有合同登记，没有创建WBS
     * 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "wbsWarn")
    public CommonResponse<String> wbsWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        // 获取没有wbs的项目
        CommonResponse<List<ProjectArchiveVO>> response = shareProjectWbsApi.getProjectIdsNoWbs();
        if (!response.isSuccess()) {
            return CommonResponse.error(response.getMsg());
        }


        List<ProjectArchiveVO> projectArchiveVOList = response.getData();

        if (CollectionUtils.isEmpty(projectArchiveVOList)) {
            logger.error("执行" + PROJECT_WBS_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        // 查询这些项目中的合同登记
        List<Long> projectIds = projectArchiveVOList.stream().map(ProjectArchiveVO::getId).collect(Collectors.toList());
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
        List<ContractRegisterEntity> contractRegisterEntityList = contractRegisterService.list(new QueryWrapper<ContractRegisterEntity>()
                .in("project_id", projectIds)
                .in("bill_state", billStates));
        // 拿到做了合同登记的项目id的Set
        Set<Long> set = contractRegisterEntityList.stream().map(ContractRegisterEntity::getProjectId).collect(Collectors.toSet());

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (ProjectArchiveVO project : projectArchiveVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            if (set.contains(project.getId())) {
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(project.getName());
                vo.setPcTitle("待编写WBS");
                vo.setPcUrl(WBS_URL + "?id=" + project.getId().toString() + "&name=" + project.getName());
                vo.setOrgId(project.getOrgId());
                vo.setOrgName(project.getOrgName());
                vo.setSourceId(project.getId().toString());
                vo.setTenantId(999999L);
                vo.setWarnLevel(warnLevel);
                vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
                vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

                tmpContent = defaultWarnInfo.getString("earlywarnContent");
                vo.setEarlywarnContent(
                        tmpContent.replaceAll("#projectName#", project.getName())
                );
                resp.add(vo);
            }
        }

        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 有商机登记，没有出图询价单
     * 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "reportWarn")
    public CommonResponse<String> reportWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        // 获取没有出图询价单的商机登记
        List<EngineeringReportEntity> list = engineeringReportMapper.getAssistNoPass();

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (EngineeringReportEntity entity : list) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();

            vo.setBillName(entity.getEngineeringName());
            vo.setPcTitle("待技术出图");
            vo.setPcUrl(REPORT_URL);
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(999999L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#engineeringName#", entity.getEngineeringName())
            );
            resp.add(vo);
        }

        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 已过了合同交货日期 但未做对甲结算 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "settleWarn")
    public CommonResponse<String> settleWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //已 过了合同交货日期，但未做对甲结算的 单子
        List<ContractRegisterEntity> list = contractRegisterService.selectExpireContractList();
        if (CollectionUtils.isEmpty(list)) {
            logger.error("执行" + SETTLE_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        logger.info("未做对甲计算的数据：{}", JSONObject.toJSONString(list));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.筛出符合条件的数据发送信息
        for (ContractRegisterEntity contractRegisterEntity : list) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(contractRegisterEntity.getContractName());
            vo.setPcTitle("对甲结算");

            vo.setPcUrl(SETTLE_URL);
            vo.setOrgId(contractRegisterEntity.getParentOrgId());
            vo.setOrgName(contractRegisterEntity.getParentOrgName());
            vo.setSourceId(contractRegisterEntity.getId().toString());
            vo.setTenantId(999999L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#contractName#", contractRegisterEntity.getContractName()
            ));
            resp.add(vo);
        }
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }


    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        logger.info("发送任务：{}", JSONObject.toJSONString(warnList));
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    private CommonResponse<String> sendWarnToTaskWithReceive(List<EarlyWarnTransVO> warnList, Long warnId) {
        logger.info("发送任务：{}", JSONObject.toJSONString(warnList));
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterWithReceive(warnList, warnId);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

}
