package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.bean.ReviewEntity;
import com.ejianc.business.jlincome.income.enums.PerformanceStatusEnum;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.IReviewService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

@Service("contractRegister") 
public class ContractRegisterBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IProjectArchiveApi projectArchiveApi;
	@Autowired
	private IContractRegisterService contractRegisterService;
	@Autowired
	private IReviewService reviewService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}


	;

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ContractRegisterEntity contractRegisterEntity = contractRegisterService.selectById(billId);
		//1.反写项目信息
		ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
		projectArchiveVO.setId(contractRegisterEntity.getProjectId());
		if (null != contractRegisterEntity.getCustomerId()){
			projectArchiveVO.setCustomId(contractRegisterEntity.getCustomerId());
			projectArchiveVO.setCustomName(contractRegisterEntity.getCustomerName());
			projectArchiveVO.setCustomCode(contractRegisterEntity.getCustomerCode());
		}
		projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.合同阶段.getCode());
		CommonResponse<String> updateResponse = projectArchiveApi.updateProjectData(projectArchiveVO);
		if (!updateResponse.isSuccess()){
			throw new BusinessException("更新项目信息-客户信息异常！");
		}
		//2.更新合同状态
		contractRegisterEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
		contractRegisterEntity.setEffectDate(new Date());
		contractRegisterService.saveOrUpdate(contractRegisterEntity);
		//3.更新合同登记占用合同评审金额
		Map<String, BigDecimal> contractMnyByReviewIdMap = contractRegisterService.queryContractMnyByReviewId(contractRegisterEntity.getReviewId());
		logger.info("获取合同登记占用合同评审金额：contractMnyByReviewIdMap-{}", JSONObject.toJSONString(contractMnyByReviewIdMap));
		UpdateWrapper<ReviewEntity> reviewUpdateWrapper = new UpdateWrapper();
		reviewUpdateWrapper.eq("id", contractRegisterEntity.getReviewId());
		reviewUpdateWrapper.set("contract_register_tax_mny", contractMnyByReviewIdMap.get("contractMny"));
		reviewUpdateWrapper.set("contract_register_mny", contractMnyByReviewIdMap.get("contractTaxMny"));
		reviewService.update(reviewUpdateWrapper);


		//3.发消息
		//单据提交之后给“部门负责人”推送系统消息，OA消息（钉钉消息）消息内容：1、2、你有一个合同包含施工，请尽快处理！点击查看详情
		if (null != contractRegisterEntity.getInstallLeaderId() && BillStateEnum.COMMITED_STATE.getBillStateCode()==contractRegisterEntity.getBillState()){
			contractRegisterService.sendMsgToInstallPerson(contractRegisterEntity);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		ContractRegisterEntity contractRegisterEntity = contractRegisterService.selectById(billId);
		//1.反写项目信息
		ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
		projectArchiveVO.setId(contractRegisterEntity.getProjectId());
		projectArchiveVO.setCustomId(null);
		projectArchiveVO.setCustomName(null);
		projectArchiveVO.setCustomCode(null);
		projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.合同阶段.getCode());
		CommonResponse<String> updateResponse = projectArchiveApi.updateProjectData(projectArchiveVO);
		if (!updateResponse.isSuccess()){
			throw new BusinessException("更新项目信息-客户信息异常！");
		}
		//2.更新合同状态
		contractRegisterEntity.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());
		contractRegisterEntity.setEffectDate(null);
		contractRegisterService.saveOrUpdate(contractRegisterEntity);
		//3.更新合同登记占用合同评审金额
		Map<String, BigDecimal> contractMnyByReviewIdMap = contractRegisterService.queryContractMnyByReviewId(contractRegisterEntity.getReviewId());
		logger.info("获取合同登记占用合同评审金额：contractMnyByReviewIdMap-{}", JSONObject.toJSONString(contractMnyByReviewIdMap));
		UpdateWrapper<ReviewEntity> reviewUpdateWrapper = new UpdateWrapper();
		reviewUpdateWrapper.eq("id", contractRegisterEntity.getReviewId());
		reviewUpdateWrapper.set("contract_register_tax_mny", contractMnyByReviewIdMap.get("contractMny"));
		reviewUpdateWrapper.set("contract_register_mny", contractMnyByReviewIdMap.get("contractTaxMny"));
		reviewService.update(reviewUpdateWrapper);
		return CommonResponse.success();
	}

}
