package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.income.bean.*;
import com.ejianc.business.jlincome.income.enums.ChangeStatusEnum;
import com.ejianc.business.jlincome.income.service.IContractRegisterChangeService;
import com.ejianc.business.jlincome.income.service.IContractRegisterClauseService;
import com.ejianc.business.jlincome.income.service.IContractRegisterRecordService;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

@Service("contractRegisterChange") 
public class ContractRegisterChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IProjectArchiveApi projectArchiveApi;
	@Autowired
	private IContractRegisterChangeService contractRegisterChangeService;
	@Autowired
	private IContractRegisterService contractRegisterService;
	@Autowired
	private IContractRegisterRecordService contractRegisterRecordService;
	@Autowired
	private IContractRegisterClauseService contractClauseService;
	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}


	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("进入审批同意后回写--- billId:" + billId + "  state:" + state);
		ContractRegisterChangeEntity changeEntity = contractRegisterChangeService.selectById(billId);
		changeEntity.setEffectDate(new Date());

		ContractRegisterEntity contractEntity = contractRegisterService.selectById(changeEntity.getContractId());
		if (null != changeEntity.getCustomerId()){
			if (null == contractEntity.getCustomerId() || !contractEntity.getCustomerId().toString().equals(changeEntity.getCustomerId().toString())){
				//1.反写项目信息
				ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
				projectArchiveVO.setId(changeEntity.getProjectId());
				projectArchiveVO.setCustomId(changeEntity.getCustomerId());
				projectArchiveVO.setCustomName(changeEntity.getCustomerName());
				projectArchiveVO.setCustomCode(changeEntity.getCustomerCode());


				projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.合同阶段.getCode());
				CommonResponse<String> updateResponse = projectArchiveApi.updateProjectData(projectArchiveVO);
				if (!updateResponse.isSuccess()){
					throw new BusinessException("更新项目信息-客户信息异常！");
				}
			}
		}
		//3.发消息
		//单据提交之后给“部门负责人”推送系统消息，OA消息（钉钉消息）消息内容：1、2、你有一个合同包含施工，请尽快处理！点击查看详情
		if (null != changeEntity.getInstallLeaderId() && BillStateEnum.COMMITED_STATE.getBillStateCode()==changeEntity.getBillState()){
			contractRegisterChangeService.sendMsgToInstallPerson(changeEntity);
		}



		//2，先复制合同表到合同历史表
		ContractRegisterRecordEntity recordEntity = BeanMapper.map(contractEntity, ContractRegisterRecordEntity.class);
		logger.info("进入审批同意后回写--- changeEntity:" + changeEntity + "  contractEntity:" + contractEntity);
		recordEntity.setContractId(recordEntity.getId());
		recordEntity.setId(null);
		if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
			recordEntity.getDetailList().forEach(vo -> {
				vo.setContractId(contractEntity.getId());
				vo.setContractDetailId(vo.getId());
				vo.setId(null);
			});
		}
		if (CollectionUtils.isNotEmpty(recordEntity.getClauseList())) {
			recordEntity.getClauseList().forEach(vo -> {
				vo.setContractId(contractEntity.getId());
				vo.setContractClauseId(vo.getId());
				vo.setId(null);
			});
		}
		contractRegisterRecordService.saveOrUpdate(recordEntity, false);
		logger.info("进入审批同意后回写--2");

		//3，回写合同，变更状态改为已变更，并回写字段
		contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
		contractEntity.setBillCode(changeEntity.getBillCode());
		contractEntity.setContractName(changeEntity.getContractName());
		contractEntity.setUndertakeUnitId(changeEntity.getUndertakeUnitId());
		contractEntity.setUndertakeUnitName(changeEntity.getUndertakeUnitName());
		contractEntity.setCustomerId(changeEntity.getCustomerId());
		contractEntity.setCustomerCode(changeEntity.getCustomerCode());
		contractEntity.setCustomerName(changeEntity.getCustomerName());
		contractEntity.setCustomLinkName(changeEntity.getCustomLinkName());
		contractEntity.setCustomLinkPhone(changeEntity.getCustomLinkPhone());

		contractEntity.setProjectTypeId(changeEntity.getProjectTypeId());
		contractEntity.setProjectTypeName(changeEntity.getProjectTypeName());
		contractEntity.setProductType(changeEntity.getProductType());
		contractEntity.setProductTypeName(changeEntity.getProductTypeName());

		contractEntity.setDeliveryDate(changeEntity.getDeliveryDate());
		contractEntity.setSignDate(changeEntity.getSignDate());
		contractEntity.setReceiveDate(changeEntity.getReceiveDate());

		contractEntity.setTaxRate(changeEntity.getTaxRate());
		contractEntity.setSpecNum(changeEntity.getSpecNum());

		contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
		contractEntity.setContractMny(changeEntity.getContractMny());
		contractEntity.setContractTax(changeEntity.getContractTax());
		contractEntity.setWarrantyTaxMny(changeEntity.getWarrantyTaxMny());
		contractEntity.setWarrantyMny(changeEntity.getWarrantyMny());

		contractEntity.setSaleLeaderId(changeEntity.getSaleLeaderId());
		contractEntity.setSaleLeaderName(changeEntity.getSaleLeaderName());
		contractEntity.setSaleLeaderPhone(changeEntity.getSaleLeaderPhone());

		contractEntity.setEmployeeId(changeEntity.getEmployeeId());
		contractEntity.setEmployeeName(changeEntity.getEmployeeName());
		contractEntity.setDepartmentId(changeEntity.getDepartmentId());
		contractEntity.setDepartmentName(changeEntity.getDepartmentName());

		contractEntity.setPayCondition(changeEntity.getPayCondition());
		contractEntity.setMemo(changeEntity.getMemo());

		contractEntity.setProjectHeight(changeEntity.getProjectHeight());
		contractEntity.setProjectSpan(changeEntity.getProjectSpan());
		contractEntity.setInstallLeaderId(changeEntity.getInstallLeaderId());
		contractEntity.setInstallLeaderName(changeEntity.getInstallLeaderName());

		contractEntity.setFileTypeId(changeEntity.getFileTypeId());
		contractEntity.setFileTypeName(changeEntity.getFileTypeName());


		QueryWrapper<ContractRegisterClauseEntity> deleteWrapper = new QueryWrapper<>();
		deleteWrapper.eq("contract_register_id", changeEntity.getContractId());
		contractClauseService.remove(deleteWrapper);
		contractEntity.setClauseList(null);
		if (CollectionUtils.isNotEmpty(changeEntity.getDetailList())) {
			logger.info("复制子表开始--" + changeEntity.getDetailList());
			changeEntity.getDetailList().forEach(vo -> {
				logger.info("复制子表--" + vo.getContractDetailId());
				if (null != vo.getContractDetailId()) {
					Map<Long, Integer> map = contractEntity.getDetailList().stream().collect(Collectors.toMap(ContractRegisterDetailEntity::getId, ContractRegisterDetailEntity::getVersion));
					vo.setId(vo.getContractDetailId());
					vo.setVersion(map.get(vo.getContractDetailId()));
				}
			});
			contractEntity.setDetailList(BeanMapper.mapList(changeEntity.getDetailList(), ContractRegisterDetailEntity.class));
		}
		if (CollectionUtils.isNotEmpty(changeEntity.getClauseList())) {
			changeEntity.getClauseList().forEach(vo -> {
				vo.setId(null);
			});
			contractEntity.setClauseList(BeanMapper.mapList(changeEntity.getClauseList(), ContractRegisterClauseEntity.class));
		}
		boolean flag = contractRegisterService.saveOrUpdate(contractEntity, false);
		contractRegisterChangeService.saveOrUpdate(changeEntity);
		logger.info("业务逻辑完成--返回" + flag);
		if (flag) {
			//变更合同附件复制到主合同
			//todo 复制附件
			attachmentApi.copyFiles(String.valueOf(billId), "EJCBT202405000046", "contractRegisterChangeFile", String.valueOf(contractEntity.getId()), "EJCBT202405000039", "contractRegisterFile", true);

			attachmentApi.copyFiles(String.valueOf(billId), "EJCBT202405000046", "contractRegisterMgrChangeFile", String.valueOf(contractEntity.getId()), "EJCBT202405000039", "contractMgrFile", true);
			return CommonResponse.success();
		} else {
			return CommonResponse.error("审批回写异常!");
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("该单据不可撤回！");
	}
}
