package com.ejianc.business.jlincome.performance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.finance.api.IInvoiceReceiveApi;
import com.ejianc.business.jlcost.finance.vo.InvoicePoolVO;
import com.ejianc.business.jlcost.finance.vo.ReceivePoolVO;
import com.ejianc.business.jlincome.performance.bean.*;
import com.ejianc.business.jlincome.performance.mapper.SaleReportMapper;
import com.ejianc.business.jlincome.performance.service.IForecastDetailService;
import com.ejianc.business.jlincome.performance.service.ISaleContractService;
import com.ejianc.business.jlincome.performance.service.impl.ForecastDetailServiceImpl;
import com.ejianc.business.jlincome.performance.vo.ForecastLedgerVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.xml.bind.v2.TODO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.performance.bean.ForecastEntity;
import com.ejianc.business.jlincome.performance.service.IForecastService;
import com.ejianc.business.jlincome.performance.vo.ForecastVO;

/**
 * 绩效管理-销售预报-主表
 *
 * @author generator
 */
@Controller
@RequestMapping("forecast")
public class ForecastController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ForecastDetailServiceImpl forecastDetailService;

    private static final String BILL_CODE = "FORECAST_CODE";//此处需要根据实际修改

    @Autowired
    private IForecastService service;

    @Autowired
    private IForecastDetailService detailService;
    @Autowired
    private SaleReportMapper saleReportMapper;
    @Autowired
    private ISaleContractService saleContractService;
    @Autowired
    private IInvoiceReceiveApi invoiceReceiveApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ForecastVO> saveOrUpdate(@RequestBody ForecastVO saveOrUpdateVO) {
        return service.insertOrUpdate(saveOrUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ForecastVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @param id
     * @Description queryChangeDetail 复制为变更单 取详情 （场景：点击变更）
     */
    @RequestMapping(value = "/queryChangeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ForecastVO> queryChangeDetail(Long id) {
        ForecastVO changeVO = service.queryChangeDetail(id);
        return CommonResponse.success("查询详情数据成功！", changeVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ForecastVO> vos) {
        return service.deleteVos(vos);
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ForecastVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //单据编码、销售预报标题、区域名称、区域负责人、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("forecastName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        ForecastVO a = new ForecastVO();
        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效单据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");

        //不生效（只有第一版本的 不生效的能被查出来，其他版本的都是生效的，不生效的是从变更中进入的）
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);

        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);

        IPage<ForecastEntity> page = service.queryPage(param, false);
        IPage<ForecastVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //单据编码、销售预报标题、区域名称、区域负责人、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("forecastName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效单据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");

        //不生效（只有第一版本的 不生效的能被查出来，其他版本的都是生效的，不生效的是从变更中进入的）
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);

        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        List<ForecastEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ForecastVO> voList = BeanMapper.mapList(list, ForecastVO.class);
        voList.forEach((vo) -> {
            if (vo.getChangeState() == 0) {
                vo.setChangeStateName("未变更");
            } else if (vo.getChangeState() == 1) {
                vo.setChangeStateName("变更中");
            } else {
                vo.setChangeStateName("已变更");
            }
        });
        logger.info(voList.get(0).getChangeStateName());
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Forecast-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refForecastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ForecastVO>> refForecastData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ForecastEntity> page = service.queryPage(param, false);
        IPage<ForecastVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "/checkOrgMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkOrgMonth(@RequestParam(value = "rowId", required = false) Long rowId, @RequestParam(value = "orgId") Long orgId, @RequestParam(value = "forecastMonth") String forecastMonth) {
        return service.checkOrgMonth(rowId, orgId, forecastMonth);
    }


    //销售预报台账
    @RequestMapping(value = "/queryLedgerList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ForecastLedgerVO>> queryLedgerList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */  // 搜索：区域名称、客户单位名称、负责人，模糊搜索
        List<String> fuzzyFields = param.getFuzzyFields();
        //区域名称orgName
        fuzzyFields.add("orgName");
        //客户单位名称
        // fuzzyFields.add("customerName");
        //负责人orgPersonName
        fuzzyFields.add("orgPersonName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        param.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        IPage<ForecastEntity> page = service.queryPage(param, false);
        IPage<ForecastLedgerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ForecastLedgerVO> resDatas = new ArrayList<>();//一级

        resDatas = BeanMapper.mapList(page.getRecords(), ForecastLedgerVO.class);
        Map<Long, ForecastLedgerVO> oneMap = new HashMap<>();//一级map
        if (CollectionUtils.isNotEmpty(resDatas)) {
            resDatas.forEach(e -> {
                oneMap.put(e.getId(), e);
            });
        }
        List<ForecastLedgerVO> res = null;
        if (!oneMap.isEmpty()) {
            res = getList(oneMap, resDatas);
            List<ForecastLedgerVO> forecastLedgerVOS = TreeNodeBUtil.buildTree(res);
            pageData.setRecords(forecastLedgerVOS);
            return CommonResponse.success("查询列表数据成功！", pageData);
        } else {
            pageData.setRecords(new ArrayList<>());
            return CommonResponse.success("查询列表数据成功！", pageData);
        }
    }


    /**
     * @param param
     * @Description 报表数据
     * @Return void
     */
    @RequestMapping(value = "/reportList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse reportList(String year) {
        LambdaQueryWrapper<ForecastEntity> wrapper = new LambdaQueryWrapper<ForecastEntity>();
        wrapper.in(ForecastEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        wrapper.in(ForecastEntity::getEnableState, true);
        wrapper.between(ForecastEntity::getForecastMonth, year + "-01-01", year + "-12-31");
        List<ForecastEntity> forecasts = service.list(wrapper);
        List<ForecastLedgerVO> oneList = new ArrayList<>();
        for (int i = 0; i < 12; i++) {
            ForecastLedgerVO forecastLedgerVO = new ForecastLedgerVO();
            forecastLedgerVO.setSaleForecastMny(BigDecimal.ZERO);
            forecastLedgerVO.setInvoiceForecastMny(BigDecimal.ZERO);
            forecastLedgerVO.setIncomeForecastMny(BigDecimal.ZERO);
            forecastLedgerVO.setSaleCompletionMny(BigDecimal.ZERO);
            forecastLedgerVO.setInvoiceCompletionMny(BigDecimal.ZERO);
            forecastLedgerVO.setIncomeCompletionMny(BigDecimal.ZERO);
            oneList.add(forecastLedgerVO);
        }
        forecasts.forEach((forecast) -> {
            Integer month = forecast.getForecastMonth().getMonth();
            ForecastLedgerVO forecastLedgerVO = oneList.get(month - 1);
            forecastLedgerVO.setSaleForecastMny(forecastLedgerVO.getSaleForecastMny().add(forecast.getSaleForecastMny()));
            forecastLedgerVO.setInvoiceForecastMny(forecastLedgerVO.getInvoiceForecastMny().add(forecast.getInvoiceForecastMny()));
            forecastLedgerVO.setIncomeForecastMny(forecastLedgerVO.getIncomeForecastMny().add(forecast.getIncomeForecastMny()));
            oneList.set(month - 1, forecastLedgerVO);
        });
        //2.1抽取销售业绩合同数据
        List<PoolEntity> resList = new ArrayList<>();
        LambdaQueryWrapper<SaleContractEntity> lambda = new LambdaQueryWrapper<SaleContractEntity>();
        lambda.in(SaleContractEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.between(SaleContractEntity::getRegisterDate, year + "-01-01", year + "-12-31");
        List<SaleContractEntity> contracts = saleContractService.list(lambda);
        contracts.forEach((contract) -> {
            SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
            int month = Integer.parseInt(monthFormat.format(contract.getRegisterDate()));
            ForecastLedgerVO forecastLedgerVO = oneList.get(month - 1);

            forecastLedgerVO.setSaleCompletionMny(forecastLedgerVO.getSaleCompletionMny().add(contract.getContractMny()).divide(BigDecimal.valueOf(10000)));
            logger.info("销售完成：{},{}", month, contract.getContractMny());
        });
        CommonResponse<JSONObject> res = invoiceReceiveApi.getDataPool();
        if (!res.isSuccess()) {
            logger.info("抽取开票收款数据失败--" + res.getMsg());
            throw new BusinessException("抽取开票收款数据失败！原因-" + res.getMsg());
        }
        //2.2 抽取开票 数据
        List<InvoicePoolVO> invoices = (List<InvoicePoolVO>) res.getData().get("invoiceDetailList");
        ObjectMapper mapper = new ObjectMapper();
        List<InvoicePoolVO> invoiceEntities2 = mapper.convertValue(invoices, new TypeReference<List<InvoicePoolVO>>() {
        });
        invoiceEntities2.forEach((invoice) -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
            if (!dateFormat.format(invoice.getInvoiceDate()).equals(year)) {
                return;
            }
            SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
            int month = Integer.parseInt(monthFormat.format(invoice.getInvoiceDate()));
            ForecastLedgerVO forecastLedgerVO = oneList.get(month - 1);
            forecastLedgerVO.setInvoiceCompletionMny(forecastLedgerVO.getInvoiceCompletionMny().add(invoice.getInvoiceMny()).divide(BigDecimal.valueOf(10000)));
            oneList.set(month - 1, forecastLedgerVO);
            logger.info("开票完成：{},{}", month, invoice.getInvoiceMny());
        });

        //2.3 抽取收款 数据
        List<ReceivePoolVO> incomes = (List<ReceivePoolVO>) res.getData().get("receiveDetailList");
        List<ReceivePoolVO> receivePoolVOS = mapper.convertValue(incomes, new TypeReference<List<ReceivePoolVO>>() {
        });
        receivePoolVOS.forEach((income) -> {
            SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
            if (!yearFormat.format(income.getReceiveTime()).equals(year)) {
                return;
            }
            SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
            int month = Integer.parseInt(monthFormat.format(income.getReceiveTime()));

            ForecastLedgerVO forecastLedgerVO = oneList.get(month - 1);
            forecastLedgerVO.setIncomeCompletionMny(forecastLedgerVO.getIncomeCompletionMny().add(income.getReceiveMny()).divide(BigDecimal.valueOf(10000)));
            oneList.set(month - 1, forecastLedgerVO);
            logger.info("收款完成：{},{}", month, income.getReceiveMny());
        });
        return CommonResponse.success(oneList);

    }

    //销售预报台账--门户使用
    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ForecastLedgerVO>> queryReportList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */  // 搜索：区域名称、客户单位名称、负责人，模糊搜索
        List<String> fuzzyFields = param.getFuzzyFields();
        //区域名称orgName
        fuzzyFields.add("orgName");
        //客户单位名称
        // fuzzyFields.add("customerName");
        //负责人orgPersonName
        fuzzyFields.add("orgPersonName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        param.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        IPage<ForecastEntity> page = service.queryPage(param, false);
        List<ForecastLedgerVO> resDatas = new ArrayList<>();//一级

        resDatas = BeanMapper.mapList(page.getRecords(), ForecastLedgerVO.class);
        Map<Long, ForecastLedgerVO> oneMap = new HashMap<>();//一级map
        if (CollectionUtils.isNotEmpty(resDatas)) {
            resDatas.forEach(e -> {
                oneMap.put(e.getId(), e);
            });
        }
        List<ForecastLedgerVO> res = null;
        List<ForecastLedgerVO> resList = new ArrayList<>();
        if (!oneMap.isEmpty()) {
            res = getList(oneMap, resDatas);
            res.forEach(e -> {
                if (null == e.getParentId()) {
                    resList.add(e);
                }
            });
            return CommonResponse.success("查询列表数据成功！", resList);
        } else {
            return CommonResponse.success("查询列表数据成功！", new ArrayList<>());
        }
    }

    /**
     * @param param
     * @Description 台账导出
     * @Return void
     */
    @RequestMapping(value = "/LedgerExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void LedgerExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //区域名称orgName
        fuzzyFields.add("orgName");
        //客户单位名称
        // fuzzyFields.add("customerName");
        //负责人orgPersonName
        fuzzyFields.add("orgPersonName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        param.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        IPage<ForecastEntity> page = service.queryPage(param, false);
        IPage<ForecastLedgerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ForecastLedgerVO> resDatas = new ArrayList<>();//一级
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), ForecastLedgerVO.class);
            Map<Long, ForecastLedgerVO> oneMap = new HashMap<>();//一级map
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    oneMap.put(e.getId(), e);
                });
            }
            List<ForecastLedgerVO> res = null;
            if (!oneMap.isEmpty()) {
                res = getList(oneMap, resDatas);
                export(response, res);
            } else {
                export(response, res);
            }
        }
    }

    private static void export(HttpServletResponse response, List<ForecastLedgerVO> res) {
        Map<String, Object> beans = new HashMap<>();
        List<ForecastLedgerVO> forecastLedgerVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(res)) {
            forecastLedgerVOS = TreeNodeBUtil.buildTree(res);
        }
        beans.put("records", forecastLedgerVOS);
        //调方法 完成 合计功能
        extracted(forecastLedgerVOS, beans);
        ExcelExport.getInstance().export("Ledger-export.xlsx", beans, response);
    }

    private static void extracted(List<ForecastLedgerVO> resDatas, Map<String, Object> beans) {
        //合计 销售预报金额
        BigDecimal saleForecastMny = new BigDecimal(0);

        //合计 开票预报金额
        BigDecimal invoiceForecastMny = new BigDecimal(0);

        //合计 收入预报金额
        BigDecimal incomeForecastMny = new BigDecimal(0);

        //合计 销售完成金额
        BigDecimal saleCompletionMny = new BigDecimal(0);
        //合计销完成差距
        BigDecimal saleCompletionGap = new BigDecimal(0);

        //开票
        BigDecimal invoiceCompletionMny = new BigDecimal(0);
        BigDecimal invoiceCompletionGap = new BigDecimal(0);
        //收款
        BigDecimal incomeCompletionMny = new BigDecimal(0);
        BigDecimal incomeCompletionGap = new BigDecimal(0);

        for (ForecastLedgerVO resData : resDatas) {
            saleForecastMny = saleForecastMny.add(resData.getSaleForecastMny());
            invoiceForecastMny = invoiceForecastMny.add(resData.getInvoiceForecastMny());
            incomeForecastMny = incomeForecastMny.add(resData.getIncomeForecastMny());
            saleCompletionMny = saleCompletionMny.add(resData.getSaleCompletionMny());
            saleCompletionGap = saleCompletionGap.add(resData.getSaleCompletionGap());
            invoiceCompletionMny = invoiceCompletionMny.add(resData.getInvoiceCompletionMny());
            invoiceCompletionGap = invoiceCompletionGap.add(resData.getInvoiceCompletionGap());
            incomeCompletionMny = incomeCompletionMny.add(resData.getIncomeCompletionMny());
            incomeCompletionGap = incomeCompletionGap.add(resData.getIncomeCompletionGap());


        }
        beans.put("saleForecastMny", saleForecastMny);
        beans.put("invoiceForecastMny", invoiceForecastMny);
        beans.put("incomeForecastMny", incomeForecastMny);
        beans.put("saleCompletionMny", saleCompletionMny);
        beans.put("saleCompletionGap", saleCompletionGap);

        beans.put("invoiceCompletionMny", invoiceCompletionMny);
        beans.put("invoiceCompletionGap", invoiceCompletionGap);
        beans.put("incomeCompletionMny", incomeCompletionMny);
        beans.put("incomeCompletionGap", incomeCompletionGap);
    }

    private List<ForecastLedgerVO> getList(Map<Long, ForecastLedgerVO> oneMap, List<ForecastLedgerVO> resDatas) {
        LambdaQueryWrapper<ForecastDetailEntity> lambda = Wrappers.<ForecastDetailEntity>lambdaQuery();
        lambda.in(ForecastDetailEntity::getPid, oneMap.keySet());
        List<ForecastDetailEntity> resList = forecastDetailService.list(lambda);
        List<ForecastLedgerVO> ListVOList = BeanMapper.mapList(resList, ForecastLedgerVO.class);// 所有子表信息
        List<ForecastLedgerVO> listFather = new ArrayList<>(); //过滤出 二级
        List<ForecastLedgerVO> listThirdStage = new ArrayList<>(); //过滤出  三级


        Map<String, ForecastLedgerVO> map = new HashMap<>();//key-- 人员+parentid   value : 实体
        Map<Long, ForecastLedgerVO> twoMap = ListVOList.stream().filter(forecastLedgerVO -> forecastLedgerVO.getParentId() == null).collect(Collectors.toMap(ForecastLedgerVO::getId, forecastLedgerVO -> forecastLedgerVO));       //二级map

        if (CollectionUtils.isNotEmpty(ListVOList)) {
            SimpleDateFormat sim = new SimpleDateFormat("yyyy");
            for (ForecastLedgerVO forecastLedgerVO : ListVOList) {
                if (forecastLedgerVO.getParentId() == null) {
                    forecastLedgerVO.setParentId(forecastLedgerVO.getPid());
                    forecastLedgerVO.setOrgName(forecastLedgerVO.getDetailOrgName());
                    forecastLedgerVO.setOrgPersonName(forecastLedgerVO.getDetailPersonName());
                    forecastLedgerVO.setSaleForecastMny(forecastLedgerVO.getSaleDetailMny());
                    forecastLedgerVO.setInvoiceForecastMny(forecastLedgerVO.getInvoiceDetailMny());
                    forecastLedgerVO.setIncomeForecastMny(forecastLedgerVO.getIncomeDetailMny());
                    forecastLedgerVO.setForecastMonth(oneMap.get(forecastLedgerVO.getPid()).getForecastMonth()); //赋值主表的年月
                    forecastLedgerVO.setYear(sim.format(forecastLedgerVO.getForecastMonth()));
                    listFather.add(forecastLedgerVO);
                } else {
                    String key = forecastLedgerVO.getDetailPersonId() + "||" + forecastLedgerVO.getParentId();
                    if (map.containsKey(key)) {
                        //说明有重复的  需要合计金额
                        ForecastLedgerVO vo = map.get(key);
                        BigDecimal SaleForecastMny = vo.getSaleForecastMny();
                        BigDecimal InvoiceForecastMny = vo.getInvoiceForecastMny();
                        BigDecimal IncomeForecastMny = vo.getIncomeForecastMny();
                        vo.setSaleForecastMny(ComputeUtil.safeAdd(SaleForecastMny, forecastLedgerVO.getSaleDetailMny()));//预报
                        vo.setInvoiceForecastMny(ComputeUtil.safeAdd(InvoiceForecastMny, forecastLedgerVO.getInvoiceDetailMny()));//开票
                        vo.setIncomeForecastMny(ComputeUtil.safeAdd(IncomeForecastMny, forecastLedgerVO.getIncomeDetailMny()));//收款
                    } else {
                        //子表父级的区域名
                        forecastLedgerVO.setOrgPersonName(forecastLedgerVO.getDetailPersonName());
                        forecastLedgerVO.setDetailOrgId(twoMap.get(forecastLedgerVO.getParentId()).getDetailOrgId());//赋值区域小组
                        forecastLedgerVO.setForecastMonth(oneMap.get(forecastLedgerVO.getPid()).getForecastMonth()); //赋值主表的年月
                        forecastLedgerVO.setYear(sim.format(forecastLedgerVO.getForecastMonth()));
                        forecastLedgerVO.setSaleForecastMny(forecastLedgerVO.getSaleDetailMny());
                        forecastLedgerVO.setInvoiceForecastMny(forecastLedgerVO.getInvoiceDetailMny());
                        forecastLedgerVO.setIncomeForecastMny(forecastLedgerVO.getIncomeDetailMny());
                        map.put(key, forecastLedgerVO);
                    }
                }
            }
            listThirdStage = new ArrayList<>(map.values());
        }

        List<ForecastLedgerVO> res = new ArrayList<>(); //最终合并的list
        // 根据listThirdStage 三级数据  查询完成金额
        LambdaQueryWrapper<SaleReportEntity> saleReportWrapper = new LambdaQueryWrapper<>();
        saleReportWrapper.isNull(SaleReportEntity::getSaleType);//代表末级的人员
        List<SaleReportEntity> saleReportEntityList = saleReportMapper.selectList(saleReportWrapper);
        Map<String, List<SaleReportEntity>> reportEntityMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(saleReportEntityList)) {
            saleReportEntityList.forEach(e -> {
                String key = e.getYear() + "|" + e.getOrgId() + "|" + e.getEmployeeId();
                if (reportEntityMap.containsKey(key)) {
                    List<SaleReportEntity> saleReportEntities = reportEntityMap.get(key);
                    saleReportEntities.add(e);
                    reportEntityMap.put(key, saleReportEntities);
                } else {
                    List<SaleReportEntity> saleReportEntities = new ArrayList<>();
                    saleReportEntities.add(e);
                    reportEntityMap.put(key, saleReportEntities);
                }
            });
        }
        Map<Long, List<ForecastLedgerVO>> thirdMap = new HashMap<>();// key：三级的parentId   value: 所有parentId一样的集合
        listThirdStage.forEach(e -> {
            String key = e.getYear() + "|" + e.getDetailOrgId() + "|" + e.getDetailPersonId();
            res.add(changeForecastLedgerVO(e, reportEntityMap.get(key)));
            if (thirdMap.containsKey(e.getParentId())) {
                List<ForecastLedgerVO> forecastLedgerVOList = thirdMap.get(e.getParentId());
                forecastLedgerVOList.add(e);
                thirdMap.put(e.getParentId(), forecastLedgerVOList);
            } else {
                List<ForecastLedgerVO> forecastLedgerVOList = new ArrayList<>();
                forecastLedgerVOList.add(e);
                thirdMap.put(e.getParentId(), forecastLedgerVOList);

            }
        });

        // 汇总二级的金额
        Map<Long, List<ForecastLedgerVO>> sunMap = new HashMap<>();// key：二级的parentId   value: 所有parentId一样的集合
        listFather.forEach(e -> {
            if (thirdMap.containsKey(e.getId())) {
                //需要合计
                List<ForecastLedgerVO> forecastLedgerVOS = thirdMap.get(e.getId());

                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);

                for (ForecastLedgerVO forecastLedgerVO : forecastLedgerVOS) {
                    if (forecastLedgerVO.getSaleCompletionMny() != null) {
                        CompletionMny = CompletionMny.add(forecastLedgerVO.getSaleCompletionMny());
                    }
                    if (forecastLedgerVO.getInvoiceCompletionMny() != null) {
                        invoiceCompletionMny = invoiceCompletionMny.add(forecastLedgerVO.getInvoiceCompletionMny());
                    }
                    if (forecastLedgerVO.getIncomeCompletionMny() != null) {
                        incomeCompletionMny = incomeCompletionMny.add(forecastLedgerVO.getIncomeCompletionMny());
                    }
                }
                setMny1(e, CompletionMny, invoiceCompletionMny, incomeCompletionMny);

            } else {
                //不需要合计
                String key = e.getYear() + "|" + e.getDetailOrgId() + "|" + e.getDetailPersonId();
                ForecastLedgerVO forecastLedgerVO = changeForecastLedgerVO(e, reportEntityMap.get(key));


            }
            res.add(e);
            if (sunMap.containsKey(e.getParentId())) {
                List<ForecastLedgerVO> forecastLedgerVOList = sunMap.get(e.getParentId());
                forecastLedgerVOList.add(e);
                sunMap.put(e.getParentId(), forecastLedgerVOList);
            } else {
                List<ForecastLedgerVO> forecastLedgerVOList = new ArrayList<>();
                forecastLedgerVOList.add(e);
                sunMap.put(e.getParentId(), forecastLedgerVOList);
            }
        });

        // 汇总一级的金额
        resDatas.forEach(e -> {
            if (sunMap.containsKey(e.getId())) {
                //需要合计
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                List<ForecastLedgerVO> forecastLedgerVOS = sunMap.get(e.getId());

                for (ForecastLedgerVO forecastLedgerVO : forecastLedgerVOS) {
                    if (forecastLedgerVO.getSaleCompletionMny() != null) {
                        CompletionMny = CompletionMny.add(forecastLedgerVO.getSaleCompletionMny());
                    }
                    if (forecastLedgerVO.getInvoiceCompletionMny() != null) {
                        invoiceCompletionMny = invoiceCompletionMny.add(forecastLedgerVO.getInvoiceCompletionMny());
                    }
                    if (forecastLedgerVO.getIncomeCompletionMny() != null) {
                        incomeCompletionMny = incomeCompletionMny.add(forecastLedgerVO.getIncomeCompletionMny());
                    }
                }
                setMny1(e, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
            } else {
                //不需要合计
            }
            res.add(e);
        });
        return res;
    }

    public ForecastLedgerVO changeForecastLedgerVO(ForecastLedgerVO child, List<SaleReportEntity> saleReportEntities) {
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM");
        String month = sim.format(child.getForecastMonth()).substring(5, 7);
        switch (month) {
            case "01": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);


                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstOneMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstOneMny());
                        }
                        if (saleReportEntity.getKpFirstOneMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstOneMny());
                        }
                        if (saleReportEntity.getSkFirstOneMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstOneMny());
                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);

                break;
            }
            case "02": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstTwoMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstTwoMny());

                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstTwoMny());
                        }
                        if (saleReportEntity.getKpFirstTwoMny() != null) {

                        }
                        if (saleReportEntity.getSkFirstTwoMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstTwoMny());
                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "03": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstThreeMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstThreeMny());

                        }
                        if (saleReportEntity.getKpFirstThreeMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstThreeMny());
                        }
                        if (saleReportEntity.getSkFirstThreeMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstThreeMny());
                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "04": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFourMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFourMny());
                        }
                        if (saleReportEntity.getKpSecondFourMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondFourMny());
                        }
                        if (saleReportEntity.getSkSecondFourMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondFourMny());
                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "05": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFiveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFiveMny());

                        }
                        if (saleReportEntity.getKpSecondFiveMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondFiveMny());
                        }
                        if (saleReportEntity.getSkSecondFiveMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondFiveMny());
                        }
                    }

                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);

                break;
            }
            case "06": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondSixMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondSixMny());
                        }
                        if (saleReportEntity.getKpSecondSixMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondSixMny());
                        }
                        if (saleReportEntity.getSkSecondSixMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondSixMny());
                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);

                break;
            }
            case "07": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdSevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdSevenMny());
                        }
                        if (saleReportEntity.getKpThirdSevenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdSevenMny());
                        }
                        if (saleReportEntity.getSkThirdSevenMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdSevenMny());
                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);

                break;
            }
            case "08": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdEightMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdEightMny());
                        }
                        if (saleReportEntity.getKpThirdEightMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdEightMny());
                        }
                        if (saleReportEntity.getSkThirdEightMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdEightMny());
                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);

                break;
            }
            case "09": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdNineMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdNineMny());
                        }
                        if (saleReportEntity.getKpThirdNineMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdNineMny());
                        }
                        if (saleReportEntity.getSkThirdNineMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdNineMny());
                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);


                break;
            }
            case "10": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTenMny());
                        }
                        if (saleReportEntity.getKpFourthTenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthTenMny());
                        }
                        if (saleReportEntity.getSkFourthTenMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthTenMny());

                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "11": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthElevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthElevenMny());
                        }
                        if (saleReportEntity.getKpFourthElevenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthElevenMny());
                        }
                        if (saleReportEntity.getSkFourthElevenMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthElevenMny());
                        }
                    }
                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "12": {
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTwelveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTwelveMny());
                        }
                        if (saleReportEntity.getKpFourthTwelveMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthTwelveMny());
                        }
                        if (saleReportEntity.getSkFourthTwelveMny() != null) {
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthTwelveMny());
                        }
                    }

                }
                setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
        }
        return child;
    }


    public void setMny1(ForecastLedgerVO child, BigDecimal CompletionMny, BigDecimal invoiceCompletionMny, BigDecimal incomeCompletionMny) {
        child.setSaleCompletionMny(CompletionMny); //销售完成金额
        child.setInvoiceCompletionMny(invoiceCompletionMny);//开票完成金额
        child.setIncomeCompletionMny(incomeCompletionMny);  // 收款完成金额

        BigDecimal completionGap = ComputeUtil.safeSub(child.getSaleCompletionMny(), child.getSaleForecastMny()); //销售完成差距
        BigDecimal invoiceCompletionGap = ComputeUtil.safeSub(child.getInvoiceCompletionMny(), child.getInvoiceForecastMny());//开票完成差距
        BigDecimal incomeCompletionGap = ComputeUtil.safeSub(child.getIncomeCompletionMny(), child.getIncomeForecastMny());//收款完成差距

        child.setSaleCompletionGap(completionGap);
        child.setInvoiceCompletionGap(invoiceCompletionGap);
        child.setIncomeCompletionGap(incomeCompletionGap);
    }

}
