package com.ejianc.business.jlincome.performance.controller;

import java.io.Serializable;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.BeanUtils;
import com.ejianc.business.jlincome.performance.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.performance.bean.SaleReportEntity;
import com.ejianc.business.jlincome.performance.service.ISaleReportService;

/**
 * 绩效管理_业绩完成报表
 *
 * @author generator
 */
@Controller
@RequestMapping("saleReport")
public class SaleReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";// 此处需要根据实际修改

    @Autowired
    private ISaleReportService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SaleReportVO> saveOrUpdate(@RequestBody SaleReportVO saveOrUpdateVO) {
        SaleReportEntity entity = BeanMapper.map(saveOrUpdateVO, SaleReportEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                // entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        SaleReportVO vo = BeanMapper.map(entity, SaleReportVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SaleReportVO> queryDetail(Long id) {
        SaleReportEntity entity = service.selectById(id);
        SaleReportVO vo = BeanMapper.map(entity, SaleReportVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SaleReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SaleReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SaleReportVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SaleReportTreeVO>> queryList(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        // param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        // 默认当前年度
         param.getParams().put("year", new Parameter(QueryParam.EQ, LocalDate.now().getYear()));
        IPage<SaleReportEntity> page = service.queryPage(param, false);
        List<SaleReportTreeVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), SaleReportTreeVO.class);
            if (StringUtils.isNotEmpty(param.getSearchText())) {
                // 说明是模糊搜索  需要补全树形  逐级往下找
                Map<Long, SaleReportTreeVO> map = resDatas.stream().collect(Collectors.toMap(SaleReportTreeVO::getId, Function.identity()));
                LambdaQueryWrapper<SaleReportEntity> lambda = new LambdaQueryWrapper<SaleReportEntity>();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List<SaleReportEntity> saleReportEntityList = service.list(lambda);
                if (CollectionUtils.isNotEmpty(saleReportEntityList)) {
                    for (SaleReportEntity e : saleReportEntityList) {
                        if (!map.containsKey(e.getId())) {
                            resDatas.add(BeanMapper.map(e, SaleReportTreeVO.class));
                        }
                    }
                }
            }
            return CommonResponse.success("查询列表数据成功！(tree)", TreeNodeBUtil.buildTree(resDatas));
        }

        return CommonResponse.success("查询列表数据成功！", resDatas);
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList2", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SaleReportVO>> queryList2(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("year");
        Long employeeId = sessionManager.getUserContext().getEmployeeId();
        param.getParams().put("employeeId", new Parameter(QueryParam.EQ, employeeId));
        IPage<SaleReportEntity> page = service.queryPage(param, false);
        IPage<SaleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SaleReportVO> resList = new ArrayList<>();
        List<SaleReportVO> resList2 = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resList = BeanMapper.mapList(page.getRecords(), SaleReportVO.class);
            // 处理大区，区域名称问题
            Set<Long> parentIds = new HashSet<>();
            resList.forEach(e -> {
                parentIds.add(e.getParentId());
            });
            LambdaQueryWrapper<SaleReportEntity> lambda = new LambdaQueryWrapper<SaleReportEntity>();
            lambda.in(SaleReportEntity::getId, parentIds);
            List<SaleReportEntity> saleReportEntityList = service.list(lambda);// 小组数据
            Map<Long, SaleReportEntity> map = saleReportEntityList.stream().collect(Collectors.toMap(SaleReportEntity::getId, Function.identity()));
            Map<Long, SaleReportEntity> dqMap = new HashMap<>();
            Set<Long> dqIds = new HashSet<>();
            saleReportEntityList.forEach(e -> {
                dqIds.add(e.getParentId());
            });
            if (CollectionUtils.isNotEmpty(dqIds)) {
                LambdaQueryWrapper<SaleReportEntity> lambda2 = new LambdaQueryWrapper<SaleReportEntity>();
                lambda2.in(SaleReportEntity::getId, dqIds);
                List<SaleReportEntity> saleReportList = service.list(lambda2);// 大区数据
                dqMap = saleReportList.stream().collect(Collectors.toMap(SaleReportEntity::getId, Function.identity()));
            }

            for (SaleReportVO e : resList) {
                SaleReportEntity saleReportEntity = map.get(e.getParentId());  // 上级信息
                if (null != saleReportEntity && null != saleReportEntity.getSaleType() && 2 == saleReportEntity.getSaleType()) {
                    // 说明上级是小组  需要再去上级大区的名称
                    e.setParentOrgName(dqMap.get(saleReportEntity.getParentId()).getOrgName());
                }
                if (null != saleReportEntity) {
                    e.setOrgName(saleReportEntity.getOrgName());
                }
                if (null == e.getSaleType()) {
                    resList2.add(e);
                }
            }
            pageData.setRecords(resList2);
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @RequestMapping(value = "/queryList3", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PersonalGradeViewVO>> queryList3(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("year");

        String mouth = null;
        // 月份
        if (param.getParams().get("mouth") != null) {
            mouth = param.getParams().get("mouth").getValue().toString();
        } else {
            // 获取当前日期
            LocalDate currentDate = LocalDate.now();
            // 获取当前月份
            int currentMonth = currentDate.getMonthValue();
            if (currentMonth >= 1 && currentMonth <= 9) {
                mouth = "0" + String.valueOf(currentMonth);
            }else{
                mouth = String.valueOf(currentMonth);
            }
        }
        param.getParams().remove("mouth");
        List<PersonalGradeViewVO> resList3 = new ArrayList<>();
        Long employeeId = sessionManager.getUserContext().getEmployeeId();
        param.getParams().put("employeeId", new Parameter(QueryParam.EQ, employeeId));
        IPage<SaleReportEntity> page = service.queryPage(param, false);
        IPage<PersonalGradeViewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SaleReportVO> resList = new ArrayList<>();
        List<SaleReportVO> resList2 = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resList = BeanMapper.mapList(page.getRecords(), SaleReportVO.class);
            // 处理大区，区域名称问题
            Set<Long> parentIds = new HashSet<>();
            resList.forEach(e -> {
                parentIds.add(e.getParentId());
            });
            LambdaQueryWrapper<SaleReportEntity> lambda = new LambdaQueryWrapper<SaleReportEntity>();
            lambda.in(SaleReportEntity::getId, parentIds);
            List<SaleReportEntity> saleReportEntityList = service.list(lambda);// 小组数据
            Map<Long, SaleReportEntity> map = saleReportEntityList.stream().collect(Collectors.toMap(SaleReportEntity::getId, Function.identity()));
            Map<Long, SaleReportEntity> dqMap = new HashMap<>();
            Set<Long> dqIds = new HashSet<>();
            saleReportEntityList.forEach(e -> {
                dqIds.add(e.getParentId());
            });
            if (CollectionUtils.isNotEmpty(dqIds)) {
                LambdaQueryWrapper<SaleReportEntity> lambda2 = new LambdaQueryWrapper<SaleReportEntity>();
                lambda2.in(SaleReportEntity::getId, dqIds);
                List<SaleReportEntity> saleReportList = service.list(lambda2);// 大区数据
                dqMap = saleReportList.stream().collect(Collectors.toMap(SaleReportEntity::getId, Function.identity()));
            }

            for (SaleReportVO e : resList) {
                SaleReportEntity saleReportEntity = map.get(e.getParentId());  // 上级信息
                if (null != saleReportEntity && null != saleReportEntity.getSaleType() && 2 == saleReportEntity.getSaleType()) {
                    // 说明上级是小组  需要再去上级大区的名称
                    e.setParentOrgName(dqMap.get(saleReportEntity.getParentId()).getOrgName());
                }
                if (null != saleReportEntity) {
                    e.setOrgName(saleReportEntity.getOrgName());
                }
                if (null == e.getSaleType()) {
                    resList2.add(e);
                }
            }
            List<PersonalGradeViewVO> personalGradeList = getPersonalGradeByMouth(mouth, resList2);
            pageData.setRecords(personalGradeList);
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @RequestMapping(value = "/queryList4", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SaleReportByMonthVO>> queryList4(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        // param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        String mouth = null;
        // 月份
        if (param.getParams().get("mouth") != null) {
            mouth = param.getParams().get("mouth").getValue().toString();
        } else {
            // 获取当前日期
            LocalDate currentDate = LocalDate.now();
            // 获取当前月份
            int currentMonth = currentDate.getMonthValue();
            if (currentMonth >= 1 && currentMonth <= 9) {
                mouth = "0" + String.valueOf(currentMonth);
            }else{
                mouth = String.valueOf(currentMonth);
            }
        }
        param.getParams().remove("mouth");
        logger.info("当前月份=====》"+mouth);
        // 默认当前年度
        // param.getParams().put("year", new Parameter(QueryParam.EQ, LocalDate.now().getYear()));
        IPage<SaleReportEntity> page = service.queryPage(param, false);
        List<SaleReportTreeVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), SaleReportTreeVO.class);
            if (StringUtils.isNotEmpty(param.getSearchText())) {
                // 说明是模糊搜索  需要补全树形  逐级往下找
                Map<Long, SaleReportTreeVO> map = resDatas.stream().collect(Collectors.toMap(SaleReportTreeVO::getId, Function.identity()));
                LambdaQueryWrapper<SaleReportEntity> lambda = new LambdaQueryWrapper<SaleReportEntity>();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List<SaleReportEntity> saleReportEntityList = service.list(lambda);
                if (CollectionUtils.isNotEmpty(saleReportEntityList)) {
                    for (SaleReportEntity e : saleReportEntityList) {
                        if (!map.containsKey(e.getId())) {
                            resDatas.add(BeanMapper.map(e, SaleReportTreeVO.class));
                        }
                    }
                }
            }

            // 汇总数据
            List<PersonalGradeViewVO> listAll = new ArrayList<>();
            // 业绩集合
            List<SaleReportVO> saleReportList = new ArrayList<>();
            // 最终数据
            List<SaleReportByMonthVO> saleReportByMonthList = new ArrayList<>();
            //key为id value为数据
            Map<Long, SaleReportVO> saleReportMap = new HashMap<>();

            //遍历所有数据 转为SaleReportVO类型集合
            resDatas.forEach(e -> {
                if (e.getId() != null) {
                    SaleReportVO saleReportVO = BeanMapper.map(e, SaleReportVO.class);
                    // key为id value为每一条数据
                    saleReportMap.put(e.getId(), saleReportVO);
                    System.out.println("e：");
                    System.out.println(JSONUtil.toJsonStr(e));
                    saleReportList.add(saleReportVO);
                }
            });
            // 调用getPersonalGradeByMouth 根据月份设置个人业绩
            listAll = getPersonalGradeByMouth(mouth, saleReportList);
            //将 PersonalGradeViewVO 类型的listALl 转为SaleReportByMonthVO类型的saleReportByMonthList
            listAll.forEach(e -> {
                if (e.getId() != null) {
                    SaleReportByMonthVO saleReportByMonthVO = BeanMapper.map(e, SaleReportByMonthVO.class);
                    saleReportByMonthVO.setParentId(saleReportMap.get(e.getId()).getParentId());
                    saleReportByMonthVO.setOrgId(saleReportMap.get(e.getId()).getOrgId());
                    saleReportByMonthVO.setOrgCode(saleReportMap.get(e.getId()).getOrgCode());
                    saleReportByMonthVO.setTeamOrgId(saleReportMap.get(e.getId()).getTeamOrgId());
                    saleReportByMonthVO.setTeamOrgCode(saleReportMap.get(e.getId()).getTeamOrgCode());
                    saleReportByMonthVO.setTeamOrgName(saleReportMap.get(e.getId()).getTeamOrgName());
                    saleReportByMonthVO.setEmployeeId(saleReportMap.get(e.getId()).getEmployeeId());
                    // key为id value为每一条数据
                    saleReportByMonthList.add(saleReportByMonthVO);
                }
            });

//            List<SaleReportTreeVO> saleReportTreeVOS = TreeNodeBUtil.buildTree(resDatas);
//            List<SaleReportByMonthVO> saleReportByMonthVOS = TreeNodeBUtil.buildTree(saleReportByMonthList);



            return CommonResponse.success("查询列表数据成功！(tree)", TreeNodeBUtil.buildTree(saleReportByMonthList));
        }

        return CommonResponse.success("查询列表数据成功！", new ArrayList<>());
    }

    /**
     * 根据月份设置个人业绩
     *
     * @param mouth          月份
     * @param saleReportList 销售数据
     * @return 个人业绩
     */
    private List<PersonalGradeViewVO> getPersonalGradeByMouth(String mouth, List<SaleReportVO> saleReportList) {
        List<PersonalGradeViewVO> personalGradeList = new ArrayList<>();
        if (mouth.equals("01")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                saleEndThisMouth = e.getSaleFirstOneMny();
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleFirstOneMny());
                // 开票
                kpEndThisMouth = e.getKpFirstOneMny();
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpFirstOneMny());
                // 收款
                skEndThisMouth = e.getSkFirstOneMny();
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkFirstOneMny());
                personalGradeList.add(vo);
            });
        }

        if (mouth.equals("02")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleFirstTwoMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpFirstTwoMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkFirstTwoMny());
                personalGradeList.add(vo);
            });
        }

        if (mouth.equals("03")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleFirstThreeMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpFirstThreeMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkFirstThreeMny());
                personalGradeList.add(vo);
            });
        }

        if (mouth.equals("04")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny(),
                        e.getSaleSecondFourMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleSecondFourMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny(),
                        e.getKpSecondFourMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpSecondFourMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny(),
                        e.getSkSecondFourMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkSecondFourMny());
                personalGradeList.add(vo);
            });
        }

        if (mouth.equals("05")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny(),
                        e.getSaleSecondFourMny(),
                        e.getSaleSecondFiveMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleSecondFiveMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny(),
                        e.getKpSecondFourMny(),
                        e.getKpSecondFiveMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpSecondFiveMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny(),
                        e.getSkSecondFourMny(),
                        e.getSkSecondFiveMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkSecondFiveMny());
                personalGradeList.add(vo);
            });
        }

        if (mouth.equals("06")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny(),
                        e.getSaleSecondFourMny(),
                        e.getSaleSecondFiveMny(),
                        e.getSaleSecondSixMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleSecondSixMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny(),
                        e.getKpSecondFourMny(),
                        e.getKpSecondFiveMny(),
                        e.getKpSecondSixMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpSecondSixMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny(),
                        e.getSkSecondFourMny(),
                        e.getSkSecondFiveMny(),
                        e.getSkSecondSixMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkSecondSixMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("07")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny(),
                        e.getSaleSecondFourMny(),
                        e.getSaleSecondFiveMny(),
                        e.getSaleSecondSixMny(),
                        e.getSaleThirdSevenMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleThirdSevenMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny(),
                        e.getKpSecondFourMny(),
                        e.getKpSecondFiveMny(),
                        e.getKpSecondSixMny(),
                        e.getKpThirdSevenMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpThirdSevenMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny(),
                        e.getSkSecondFourMny(),
                        e.getSkSecondFiveMny(),
                        e.getSkSecondSixMny(),
                        e.getSkThirdSevenMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkThirdSevenMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("08")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny(),
                        e.getSaleSecondFourMny(),
                        e.getSaleSecondFiveMny(),
                        e.getSaleSecondSixMny(),
                        e.getSaleThirdSevenMny(),
                        e.getSaleThirdEightMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleThirdEightMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny(),
                        e.getKpSecondFourMny(),
                        e.getKpSecondFiveMny(),
                        e.getKpSecondSixMny(),
                        e.getKpThirdSevenMny(),
                        e.getKpThirdEightMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpThirdEightMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny(),
                        e.getSkSecondFourMny(),
                        e.getSkSecondFiveMny(),
                        e.getSkSecondSixMny(),
                        e.getSkThirdSevenMny(),
                        e.getSkThirdEightMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkThirdEightMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("09")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny(),
                        e.getSaleSecondFourMny(),
                        e.getSaleSecondFiveMny(),
                        e.getSaleSecondSixMny(),
                        e.getSaleThirdSevenMny(),
                        e.getSaleThirdEightMny(),
                        e.getSaleThirdNineMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleThirdNineMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny(),
                        e.getKpSecondFourMny(),
                        e.getKpSecondFiveMny(),
                        e.getKpSecondSixMny(),
                        e.getKpThirdSevenMny(),
                        e.getKpThirdEightMny(),
                        e.getKpThirdNineMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpThirdNineMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny(),
                        e.getSkSecondFourMny(),
                        e.getSkSecondFiveMny(),
                        e.getSkSecondSixMny(),
                        e.getSkThirdSevenMny(),
                        e.getSkThirdEightMny(),
                        e.getSkThirdNineMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkThirdNineMny());
                personalGradeList.add(vo);
            });
        }

        if (mouth.equals("10")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny(),
                        e.getSaleSecondFourMny(),
                        e.getSaleSecondFiveMny(),
                        e.getSaleSecondSixMny(),
                        e.getSaleThirdSevenMny(),
                        e.getSaleThirdEightMny(),
                        e.getSaleThirdNineMny(),
                        e.getSaleFourthTenMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleFourthTenMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny(),
                        e.getKpSecondFourMny(),
                        e.getKpSecondFiveMny(),
                        e.getKpSecondSixMny(),
                        e.getKpThirdSevenMny(),
                        e.getKpThirdEightMny(),
                        e.getKpThirdNineMny(),
                        e.getKpFourthTenMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpFourthTenMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny(),
                        e.getSkSecondFourMny(),
                        e.getSkSecondFiveMny(),
                        e.getSkSecondSixMny(),
                        e.getSkThirdSevenMny(),
                        e.getSkThirdEightMny(),
                        e.getSkThirdNineMny(),
                        e.getSkFourthTenMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkFourthTenMny());
                personalGradeList.add(vo);
            });
        }

        if (mouth.equals("11")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny(),
                        e.getSaleSecondFourMny(),
                        e.getSaleSecondFiveMny(),
                        e.getSaleSecondSixMny(),
                        e.getSaleThirdSevenMny(),
                        e.getSaleThirdEightMny(),
                        e.getSaleThirdNineMny(),
                        e.getSaleFourthTenMny(),
                        e.getSaleFourthElevenMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleFourthElevenMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny(),
                        e.getKpSecondFourMny(),
                        e.getKpSecondFiveMny(),
                        e.getKpSecondSixMny(),
                        e.getKpThirdSevenMny(),
                        e.getKpThirdEightMny(),
                        e.getKpThirdNineMny(),
                        e.getKpFourthTenMny(),
                        e.getKpFourthElevenMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpFourthElevenMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny(),
                        e.getSkSecondFourMny(),
                        e.getSkSecondFiveMny(),
                        e.getSkSecondSixMny(),
                        e.getSkThirdSevenMny(),
                        e.getSkThirdEightMny(),
                        e.getSkThirdNineMny(),
                        e.getSkFourthTenMny(),
                        e.getSkFourthElevenMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkFourthElevenMny());
                personalGradeList.add(vo);
            });
        }

        if (mouth.equals("12")) {
            saleReportList.forEach(e -> {
                BigDecimal saleEndThisMouth;
                BigDecimal kpEndThisMouth;
                BigDecimal skEndThisMouth;
                List<BigDecimal> saleMny;
                List<BigDecimal> kpMny;
                List<BigDecimal> skMny;
                PersonalGradeViewVO vo = setBaseInfo(new PersonalGradeViewVO(), e);
                // 销售
                // 截至本月完成
                saleMny = Arrays.asList(
                        e.getSaleFirstOneMny(),
                        e.getSaleFirstTwoMny(),
                        e.getSaleFirstThreeMny(),
                        e.getSaleSecondFourMny(),
                        e.getSaleSecondFiveMny(),
                        e.getSaleSecondSixMny(),
                        e.getSaleThirdSevenMny(),
                        e.getSaleThirdEightMny(),
                        e.getSaleThirdNineMny(),
                        e.getSaleFourthTenMny(),
                        e.getSaleFourthElevenMny(),
                        e.getSaleFourthTwelveMny()
                );
                saleEndThisMouth = sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                // 本月完成
                vo.setSaleThisMouth(e.getSaleFourthTwelveMny());
                // 开票
                // 截至本月完成
                kpMny = Arrays.asList(
                        e.getKpFirstOneMny(),
                        e.getKpFirstTwoMny(),
                        e.getKpFirstThreeMny(),
                        e.getKpSecondFourMny(),
                        e.getKpSecondFiveMny(),
                        e.getKpSecondSixMny(),
                        e.getKpThirdSevenMny(),
                        e.getKpThirdEightMny(),
                        e.getKpThirdNineMny(),
                        e.getKpFourthTenMny(),
                        e.getKpFourthElevenMny(),
                        e.getKpFourthTwelveMny()
                );
                kpEndThisMouth = sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                // 本月完成
                vo.setKpThisMouth(e.getKpFourthTwelveMny());
                // 收款
                // 截至本月完成
                skMny = Arrays.asList(
                        e.getSkFirstOneMny(),
                        e.getSkFirstTwoMny(),
                        e.getSkFirstThreeMny(),
                        e.getSkSecondFourMny(),
                        e.getSkSecondFiveMny(),
                        e.getSkSecondSixMny(),
                        e.getSkThirdSevenMny(),
                        e.getSkThirdEightMny(),
                        e.getSkThirdNineMny(),
                        e.getSkFourthTenMny(),
                        e.getSkFourthElevenMny(),
                        e.getSkFourthTwelveMny()
                );
                skEndThisMouth = sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                // 本月完成
                vo.setSkThisMouth(e.getSkFourthTwelveMny());
                personalGradeList.add(vo);
            });
        }
        return personalGradeList;
    }


    // 定义一个方法来计算BigDecimal列表的总和
    public static BigDecimal sum(List<BigDecimal> bigDecimals) {
        BigDecimal sum = BigDecimal.ZERO; // 初始化为0
        for (BigDecimal bd : bigDecimals) {
            sum = ComputeUtil.safeAdd(sum, bd);
        }
        return sum;
    }

    /**
     * 设置基础信息
     *
     * @param personalGradeViewVO
     * @param saleReportVO
     */
    private PersonalGradeViewVO setBaseInfo(PersonalGradeViewVO personalGradeViewVO, SaleReportVO saleReportVO) {
        personalGradeViewVO.setId(saleReportVO.getId());
        personalGradeViewVO.setOrgName(saleReportVO.getOrgName());
        personalGradeViewVO.setEmployeeName(saleReportVO.getEmployeeName());
        personalGradeViewVO.setYear(saleReportVO.getYear());
        personalGradeViewVO.setSaleYearTaskMny(saleReportVO.getSaleYearTaskMny());
        personalGradeViewVO.setKpYearTaskMny(saleReportVO.getKpYearTaskMny());
        personalGradeViewVO.setSkYearTaskMny(saleReportVO.getSkYearTaskMny());
        return personalGradeViewVO;
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出 全部字段
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        fuzzyFields.add("orgName");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SaleReportEntity> list = service.queryList(param);
        List<SaleReportTreeVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            resDatas = BeanMapper.mapList(list, SaleReportTreeVO.class);
            if (StringUtils.isNotEmpty(param.getSearchText())) {
                // 说明是模糊搜索  需要补全树形  逐级往下找
                Map<Long, SaleReportTreeVO> map = resDatas.stream().collect(Collectors.toMap(SaleReportTreeVO::getId, Function.identity()));
                LambdaQueryWrapper<SaleReportEntity> lambda = new LambdaQueryWrapper<SaleReportEntity>();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List<SaleReportEntity> saleReportEntityList = service.list(lambda);
                if (CollectionUtils.isNotEmpty(saleReportEntityList)) {
                    for (SaleReportEntity e : saleReportEntityList) {
                        if (!map.containsKey(e.getId())) {
                            resDatas.add(BeanMapper.map(e, SaleReportTreeVO.class));
                        }
                    }
                }
            }
        }
        // todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("SaleReportCurrentYear-export.xlsx", beans, response);
    }


    /**
     * @param param
     * @Description 导出 全部字段
     * @Return void
     */
    @RequestMapping(value = "/saleReortBySaleType12ExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void saleReortBySaleType12ExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        String mouth = null;
        // 月份
        if (param.getParams().get("mouth") != null) {
            mouth = param.getParams().get("mouth").getValue().toString();
        } else {
            // 获取当前日期
            LocalDate currentDate = LocalDate.now();
            // 获取当前月份
            int currentMonth = currentDate.getMonthValue();
            if (currentMonth >= 1 && currentMonth <= 9) {
                mouth = "0" + String.valueOf(currentMonth);
            }else{
                mouth = String.valueOf(currentMonth);
            }
        }
        param.getParams().remove("mouth");
        logger.info("当前月份=====》"+mouth);
        // 默认当前年度
        // param.getParams().put("year", new Parameter(QueryParam.EQ, LocalDate.now().getYear()));
        IPage<SaleReportEntity> page = service.queryPage(param, false);
        List<SaleReportTreeVO> resDatas = new ArrayList<>();

        // 汇总数据
        List<PersonalGradeViewVO> listAll = new ArrayList<>();
        // 业绩集合
        List<SaleReportVO> saleReportList = new ArrayList<>();
        // 最终数据
        List<SaleReportByMonthVO> saleReportByMonthList = new ArrayList<>();
        //key为id value为数据
        Map<Long, SaleReportVO> saleReportMap = new HashMap<>();

        List<SaleReportByMonthVO> saleReportByMonthExport = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), SaleReportTreeVO.class);
            if (StringUtils.isNotEmpty(param.getSearchText())) {
                // 说明是模糊搜索  需要补全树形  逐级往下找
                Map<Long, SaleReportTreeVO> map = resDatas.stream().collect(Collectors.toMap(SaleReportTreeVO::getId, Function.identity()));
                LambdaQueryWrapper<SaleReportEntity> lambda = new LambdaQueryWrapper<SaleReportEntity>();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List<SaleReportEntity> saleReportEntityList = service.list(lambda);
                if (CollectionUtils.isNotEmpty(saleReportEntityList)) {
                    for (SaleReportEntity e : saleReportEntityList) {
                        if (!map.containsKey(e.getId())) {
                            resDatas.add(BeanMapper.map(e, SaleReportTreeVO.class));
                        }
                    }
                }
            }



            //遍历所有数据 转为SaleReportVO类型集合
            resDatas.forEach(e -> {
                if (e.getId() != null) {
                    SaleReportVO saleReportVO = BeanMapper.map(e, SaleReportVO.class);
                    // key为id value为每一条数据
                    saleReportMap.put(e.getId(), saleReportVO);
                    System.out.println("e：");
                    System.out.println(JSONUtil.toJsonStr(e));
                    saleReportList.add(saleReportVO);
                }
            });
            System.out.println("saleReport:");
            System.out.println(JSONUtil.toJsonStr(saleReportList));
            // 调用getPersonalGradeByMouth 根据月份设置个人业绩
            listAll = getPersonalGradeByMouth(mouth, saleReportList);
            //将 PersonalGradeViewVO 类型的listALl 转为SaleReportByMonthVO类型的saleReportByMonthList
            listAll.forEach(e -> {
                if (e.getId() != null) {
                    SaleReportByMonthVO saleReportByMonthVO = BeanMapper.map(e, SaleReportByMonthVO.class);
                    saleReportByMonthVO.setParentId(saleReportMap.get(e.getId()).getParentId());
                    saleReportByMonthVO.setOrgId(saleReportMap.get(e.getId()).getOrgId());
                    saleReportByMonthVO.setOrgCode(saleReportMap.get(e.getId()).getOrgCode());
                    saleReportByMonthVO.setTeamOrgId(saleReportMap.get(e.getId()).getTeamOrgId());
                    saleReportByMonthVO.setTeamOrgCode(saleReportMap.get(e.getId()).getTeamOrgCode());
                    saleReportByMonthVO.setTeamOrgName(saleReportMap.get(e.getId()).getTeamOrgName());
                    saleReportByMonthVO.setEmployeeId(saleReportMap.get(e.getId()).getEmployeeId());
                    // key为id value为每一条数据
                    saleReportByMonthList.add(saleReportByMonthVO);
                }
            });

            List<SaleReportTreeVO> saleReportTreeVOS = TreeNodeBUtil.buildTree(resDatas);
            List<SaleReportByMonthVO> saleReportByMonthVOS = TreeNodeBUtil.buildTree(saleReportByMonthList);


            /**
             * 获取一、二级数据
             */
            //存二级数据的父id
            List<Long> ids = new ArrayList<>();
            //遍历saleReportByMonthList 拿到parentId为999的数据 将这些数据中的id存入一个集合（即二级数据的id）
            saleReportByMonthList.forEach(e -> {
                if (e.getParentId().equals(999L)){
                    ids.add(e.getId());
                }
            });
            // 将999存入集合（一级）
            ids.add(999L);
            //遍历saleReportByMonthList 将parentid为999（一级数据）或者parentid为999的数据的id存入一个集合（二级数据）
            saleReportByMonthList.forEach(e -> {
                if (ids.contains(e.getParentId())){
                    saleReportByMonthExport.add(e);
                }
            });

        }

        // todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", saleReportByMonthExport);
        ExcelExport.getInstance().export("SaleReportByMonth-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/personalGradeExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void personalGradeExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SaleReportEntity> list = service.queryList(param);
        // todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PersonalGrade-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSaleReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SaleReportVO>> refSaleReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SaleReportEntity> page = service.queryPage(param, false);
        IPage<SaleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SaleReportVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description 定时任务-抽取数据，计算实际完成业绩
     */
    @RequestMapping(value = "/savePoolDate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> savePoolDate(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("抽取数据，计算实际完成业绩  获取到的参数JSON是：" + param + "----");
        service.saveInitPoolDate(request.getHeader("authority"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return CommonResponse.success("数据加载成功", simpleDateFormat.format(new Date()));
    }

    @RequestMapping(value = "/queryYearReportTopTen", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SaleYearReportVO>> queryYearReportTopTen(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(10);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        param.getParams().put("saleType",new Parameter(QueryParam.EQ,1));
        if (param.getParams().get("type") != null) {
            String type = param.getParams().get("type").getValue().toString();
            LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
            if("1".equals(type)){
                orderMap.put("saleYearMny", QueryParam.DESC);
            }else if("2".equals(type)){
                orderMap.put("kpYearMny", QueryParam.DESC);
            }else{
                orderMap.put("skYearMny", QueryParam.DESC);
            }
            param.setOrderMap(orderMap);
            param.getParams().remove("type");
        }
        IPage<SaleReportEntity> page = service.queryPage(param, false);
        List<SaleYearReportVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), SaleYearReportVO.class);
            return CommonResponse.success("查询列表数据成功！(tree)", resDatas);
        }
        return CommonResponse.success("查询列表数据成功！", new ArrayList<>());
    }

    @RequestMapping(value = "/queryGrReportTopTen", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SaleYearReportVO>> queryGrReportTopTen(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(10);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<Integer> saleTypeList = new ArrayList<>();
        saleTypeList.add(1);
        saleTypeList.add(2);
        param.getParams().put("saleType",new Parameter(QueryParam.SQL," sale_type is null "));
        if (param.getParams().get("type") != null) {
            String type = param.getParams().get("type").getValue().toString();
            LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
            if("1".equals(type)){
                orderMap.put("saleYearMny", QueryParam.DESC);
            }else if("2".equals(type)){
                orderMap.put("kpYearMny", QueryParam.DESC);
            }else{
                orderMap.put("skYearMny", QueryParam.DESC);
            }
            param.setOrderMap(orderMap);
            param.getParams().remove("type");
        }
        IPage<SaleReportEntity> page = service.queryPage(param, false);
        List<SaleYearReportVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), SaleYearReportVO.class);
            return CommonResponse.success("查询列表数据成功！(tree)", resDatas);
        }
        return CommonResponse.success("查询列表数据成功！", new ArrayList<>());
    }

    @RequestMapping(value = "/queryYearReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SaleYearReportVO>> queryYearReport(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getParams().put("saleType",new Parameter(QueryParam.EQ,1));
        IPage<SaleReportEntity> page = service.queryPage(param, false);
        List<SaleYearReportVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), SaleYearReportVO.class);
            return CommonResponse.success("查询列表数据成功！(tree)", resDatas);
        }
        return CommonResponse.success("查询列表数据成功！", new ArrayList<>());
    }
}
