/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.mapper.EngineeringReportMapper;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportReportVO;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="engineeringReportService")
public class EngineeringReportServiceImpl
extends BaseServiceImpl<EngineeringReportMapper, EngineeringReportEntity>
implements IEngineeringReportService {
    @Autowired
    private BusinessMapper businessMapper;
    @Autowired
    private IPushMessageApi pushMessageApi;
    private static final String PC_URL = "/ejc-jlincome-frontend/#/engineeringReport/card?id=";
    private static final String MOBILE_URL = "/ejc-jlincome-mobile/#/engineeringReport/card?id=";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean checkIsExist(EngineeringReportVO reportVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(EngineeringReportEntity::getEngineeringId, (Object)reportVO.getEngineeringId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != reportVO.getId() && reportVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)reportVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public void sendMsgToInstallPerson(EngineeringReportEntity entity) {
        this.logger.info("\u5b89\u88c5\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09");
        String msg = this.sendMsg(entity, "\u5b89\u88c5\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09", "\u4f60\u6709\u4e00\u4e2a\u65bd\u5de5\u62a5\u4ef7\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\uff01\uff01\uff01");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u5b89\u88c5\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09 \u5f02\u5e38\uff1a" + msg);
        }
        this.logger.info("\u5b89\u88c5\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09\u7ed3\u675f\uff01");
    }

    @Override
    public List<EngineeringReportReportVO> queryListByOrg(QueryWrapper queryWrapper, List<Long> orgIds) {
        return ((EngineeringReportMapper)this.baseMapper).queryListByOrg(queryWrapper, orgIds);
    }

    private String sendMsg(EngineeringReportEntity entity, String subject, String content) {
        String[] msgRecUserIds = new String[]{entity.getInstallLeaderId().toString()};
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers(msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(content);
        msgParameter.setMsgType("bpmpass");
        msgParameter.setTenantId(entity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys", "zhiyuanoa"});
        msgParameter.setPcUrl(PC_URL + entity.getId());
        msgParameter.setMobileUrl(MOBILE_URL + entity.getId());
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        return msgSendResp.isSuccess() ? null : msgSendResp.getMsg();
    }

    @Override
    public List<EngineeringReportVO> reportQueryList(Page pages, QueryWrapper wrapper) {
        List<EngineeringReportVO> list = ((EngineeringReportMapper)this.baseMapper).reportQueryList(pages, wrapper);
        List<EngineeringReportVO> voList = list.stream().collect(Collectors.toMap(EngineeringReportVO::getEngineeringId, vo -> vo, (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
        return voList;
    }
}

