/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.api.IInvoiceReceiveApi;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.enums.ChangeStatusEnum;
import com.ejianc.business.jlincome.income.enums.PerformanceStatusEnum;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.ISettleService;
import com.ejianc.business.jlincome.income.service.IUserReportService;
import com.ejianc.business.jlincome.income.vo.ContractRegisterReportVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterVO;
import com.ejianc.business.jlincome.income.vo.ProjectBoardTwoVO;
import com.ejianc.business.jlincome.income.vo.ProjectBoardVO;
import com.ejianc.business.jlprogress.order.api.IOrderApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"contractRegister"})
public class ContractRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "CONTRACT_REGISTER";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOrderApi iOrderApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private IContractRegisterService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IUserReportService userReportService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInvoiceReceiveApi invoiceReceiveApi;
    @Autowired
    private IOrderApi orderApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-t06Tq40019";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> saveOrUpdate(@RequestBody ContractRegisterVO saveOrUpdateVO) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractRegisterEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setBillCode((String)billCode.getData());
            } else if (this.service.checkSameBillCode((ContractRegisterVO)BeanMapper.map((Object)((Object)entity), ContractRegisterVO.class))) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
            ContractRegisterEntity oldEntity = (ContractRegisterEntity)((Object)this.service.selectById(entity.getId()));
            entity.setBillCode(oldEntity.getBillCode());
        } else if (this.service.checkSameBillCode((ContractRegisterVO)BeanMapper.map((Object)((Object)entity), ContractRegisterVO.class))) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        this.service.saveOrUpdate((Object)entity, false);
        ContractRegisterVO vo = (ContractRegisterVO)BeanMapper.map((Object)((Object)entity), ContractRegisterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractRegisterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractRegisterVO contractRegisterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("projectTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        if (param.getParams().containsKey("orgId")) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().remove("orgId");
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            orgId = InvocationInfoProxy.getOrgId();
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List contractRegisterVOList = BeanMapper.mapList((Iterable)page.getRecords(), ContractRegisterVO.class);
        if (this.canUpdateAll().booleanValue()) {
            contractRegisterVOList.forEach(e -> e.setUpdateFileTypeFlag(Integer.valueOf(1)));
        }
        pageData.setRecords(contractRegisterVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("projectTypeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, ContractRegisterVO.class);
        voList.forEach(e -> {
            if (PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().equals(e.getPerformanceStatus())) {
                e.setPerformanceStatusName(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
            } else if (PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(e.getPerformanceStatus())) {
                e.setPerformanceStatusName(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getDescription());
            } else {
                e.setPerformanceStatusName(PerformanceStatusEnum.\u5df2\u5c01\u8d26.getDescription());
            }
            if (ChangeStatusEnum.\u672a\u53d8\u66f4.getCode() == e.getChangeStatus()) {
                e.setChangeStatusName(ChangeStatusEnum.\u672a\u53d8\u66f4.getDescription());
            } else if (ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode() == e.getChangeStatus()) {
                e.setChangeStatusName(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getDescription());
            } else {
                e.setChangeStatusName(ChangeStatusEnum.\u5df2\u53d8\u66f4.getDescription());
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("ContractRegister-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterVO>> refContractRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("customerId", new Parameter("ne", null));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"type")) {
            param.getParams().remove("customerId");
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("undertakeUnitName");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractRegisterVO.class));
        List records = pageData.getRecords();
        List ids = records.stream().map(BaseVO::getId).collect(Collectors.toList());
        CommonResponse commonResponse = this.iOrderApi.getSalesByContractIds(ids);
        Map map = (Map)commonResponse.getData();
        for (ContractRegisterVO record : records) {
            if (!map.containsKey(record.getId())) continue;
            if (!ObjectUtils.isEmpty(map.get(record.getId()))) {
                record.setIsMaked("\u5df2\u4e0b\u5355");
                continue;
            }
            record.setIsMaked("\u672a\u4e0b\u5355");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ContractRegisterDetail-import.xlsx", (String)"\u5408\u540c\u767b\u8bb0-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @RequestMapping(value={"/changeState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ContractRegisterVO contractVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)contractVO.getId());
        updateWrapper.set(ContractRegisterEntity::getPerformanceStatus, (Object)contractVO.getPerformanceStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/changeFileType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> changeFileType(@RequestBody ContractRegisterVO contractVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)contractVO.getId());
        updateWrapper.set(ContractRegisterEntity::getFileTypeId, (Object)contractVO.getFileTypeId());
        updateWrapper.set(ContractRegisterEntity::getFileTypeName, (Object)contractVO.getFileTypeName());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u9644\u4ef6\u7c7b\u578b\u6210\u529f\uff01");
    }

    public Boolean canUpdateAll() {
        Long userid;
        CommonResponse roleRes;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode = this.paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData())) && (roleRes = this.roleApi.queryRoleByUserId(userid = InvocationInfoProxy.getUserid())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)roleRes.getData()))) {
            List<String> valList = Arrays.asList(valueData.split(",|\uff0c"));
            for (RoleVO roleVO : (List)roleRes.getData()) {
                if (!valList.contains(roleVO.getCode())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @RequestMapping(value={"/queryContractMnyByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryContractMnyByProjectId(@RequestParam Long projectId) {
        this.logger.info("\u63a5\u6536\u9879\u76eeid\uff1a{}", (Object)projectId.toString());
        return CommonResponse.success((String)"\u6839\u636e\u9879\u76ee\u67e5\u8be2\u5408\u540c\u91d1\u989d\u6210\u529f\uff01", (Object)this.service.queryContractMnyByProjectId(projectId));
    }

    @RequestMapping(value={"/queryContractRegisterReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterReportVO>> queryContractRegisterReportList(@RequestBody QueryParam param) throws ParseException {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("payCondition");
        fuzzyFields.add("saleLeaderName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<ContractRegisterReportVO> registerReportVOList = new ArrayList<ContractRegisterReportVO>();
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        if (null != page.getRecords() && page.getRecords().size() > 0) {
            List contractRegisterVOList = BeanMapper.mapList((Iterable)page.getRecords(), ContractRegisterVO.class);
            List<Long> contractIdList = contractRegisterVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.logger.info("\u83b7\u53d6\u5408\u540cid\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(contractIdList));
            CommonResponse invoiceReceiveDataRes = this.invoiceReceiveApi.getInvoiceReceiveDataByContractIdList(contractIdList);
            if (!invoiceReceiveDataRes.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u767b\u8bb0\u4e0b\u6e38\u5f00\u7968\u3001\u6536\u6b3e\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0-" + invoiceReceiveDataRes.getMsg());
            }
            String invoiceReceiveDataStr = ((JSONObject)invoiceReceiveDataRes.getData()).toJSONString();
            CommonResponse orderDataRes = this.orderApi.getOrderDataByContractIdList(contractIdList);
            if (!orderDataRes.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u767b\u8bb0\u4e0b\u6e38\u9500\u552e\u3001\u53d1\u8d27\u3001\u9a8c\u6536\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0-" + orderDataRes.getMsg());
            }
            String orderDataStr = ((JSONObject)orderDataRes.getData()).toJSONString();
            Map<Long, JSONObject> settleDataMap = this.settleService.querySettleRecordByContIdList(contractIdList);
            Map<Long, Long> userReportMap = this.userReportService.queryIdsByContractIds(contractIdList);
            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
            for (ContractRegisterVO record : contractRegisterVOList) {
                JSONObject settle;
                JSONObject order;
                JSONObject orderData;
                JSONObject invoiceReceive;
                ContractRegisterReportVO reportVO = (ContractRegisterReportVO)BeanMapper.map((Object)record, ContractRegisterReportVO.class);
                JSONObject invoiceReceiveData = JSONObject.parseObject((String)invoiceReceiveDataStr);
                if (invoiceReceiveData.containsKey((Object)record.getId()) && (invoiceReceive = (JSONObject)JSONObject.parseObject((String)invoiceReceiveData.getString(record.getId().toString()), JSONObject.class)).size() > 0) {
                    if (null != invoiceReceive.get((Object)"sumInvoiceTaxMny")) {
                        reportVO.setSumInvoiceTaxMny(new BigDecimal(invoiceReceive.get((Object)"sumInvoiceTaxMny").toString()));
                    }
                    if (null != invoiceReceive.get((Object)"sumReceiveTaxMny")) {
                        reportVO.setSumReceiveTaxMny(new BigDecimal(invoiceReceive.get((Object)"sumReceiveTaxMny").toString()));
                    }
                    if (null != invoiceReceive.get((Object)"invoiceDetailList")) {
                        reportVO.setInvoiceDetailList(JSONObject.parseArray((String)invoiceReceive.get((Object)"invoiceDetailList").toString(), JSONObject.class));
                        for (JSONObject jsonObject : reportVO.getInvoiceDetailList()) {
                            if (null == jsonObject.get((Object)"detailDate")) continue;
                            jsonObject.put("detailDate", (Object)sim.format(new Date(Long.valueOf(jsonObject.get((Object)"detailDate").toString()))));
                        }
                    }
                    if (null != invoiceReceive.get((Object)"receiveDetailList")) {
                        reportVO.setReceiveDetailList(JSONObject.parseArray((String)invoiceReceive.get((Object)"receiveDetailList").toString(), JSONObject.class));
                        for (JSONObject jsonObject : reportVO.getReceiveDetailList()) {
                            if (null == jsonObject.get((Object)"receiveTime")) continue;
                            jsonObject.put("receiveTime", (Object)sim.format(new Date(Long.valueOf(jsonObject.get((Object)"receiveTime").toString()))));
                        }
                    }
                }
                if ((orderData = JSONObject.parseObject((String)orderDataStr)).containsKey((Object)record.getId()) && (order = (JSONObject)JSONObject.parseObject((String)orderData.getString(record.getId().toString()), JSONObject.class)).size() > 0) {
                    if (null != order.get((Object)"firstOrderDate")) {
                        reportVO.setFirstOrderDate(new Date(Long.valueOf(order.get((Object)"firstOrderDate").toString())));
                    }
                    if (null != order.get((Object)"salesList")) {
                        reportVO.setSalesList(JSONObject.parseArray((String)order.get((Object)"salesList").toString(), JSONObject.class));
                    }
                    if (null != order.get((Object)"productOutVOList")) {
                        reportVO.setProductOutVOList(JSONObject.parseArray((String)order.get((Object)"productOutVOList").toString(), JSONObject.class));
                        reportVO.setProductOutState(String.valueOf(reportVO.getProductOutVOList().size()));
                    }
                    if (null != order.get((Object)"checkList")) {
                        reportVO.setCheckList(JSONObject.parseArray((String)order.get((Object)"checkList").toString(), JSONObject.class));
                        reportVO.setCheckState(String.valueOf(reportVO.getCheckList().size()));
                        for (JSONObject jsonObject : reportVO.getCheckList()) {
                            if (null != jsonObject.get((Object)"payDate")) {
                                jsonObject.put("payDate", (Object)sim.format(new Date(Long.valueOf(jsonObject.get((Object)"payDate").toString()))));
                            }
                            if (null == jsonObject.get((Object)"checkDate")) continue;
                            jsonObject.put("checkDate", (Object)sim.format(new Date(Long.valueOf(jsonObject.get((Object)"checkDate").toString()))));
                        }
                    }
                    if (null != order.get((Object)"deliveryNoticeList")) {
                        reportVO.setDeliveryNoticeList(JSONObject.parseArray((String)order.get((Object)"deliveryNoticeList").toString(), JSONObject.class));
                        reportVO.setDeliveryNoticeNum(Integer.valueOf(reportVO.getDeliveryNoticeList().size()));
                    }
                }
                if (settleDataMap.containsKey(record.getId()) && (settle = (JSONObject)JSONObject.parseObject((String)String.valueOf(settleDataMap.get(record.getId())), JSONObject.class)).size() > 0) {
                    if (null != settle.get((Object)"sumSettleTaxMny")) {
                        reportVO.setSumSettleTaxMny(new BigDecimal(settle.get((Object)"sumSettleTaxMny").toString()));
                    }
                    if (null != settle.get((Object)"settleList")) {
                        reportVO.setSettleList(JSONObject.parseArray((String)settle.get((Object)"settleList").toString(), JSONObject.class));
                        for (JSONObject jsonObject : reportVO.getSettleList()) {
                            if (null == jsonObject.get((Object)"settleDate")) continue;
                            jsonObject.put("settleDate", (Object)sim.format(new Date(Long.valueOf(jsonObject.get((Object)"settleDate").toString()))));
                        }
                    }
                }
                if (userReportMap.containsKey(record.getId())) {
                    reportVO.setUserReportId(userReportMap.get(record.getId()));
                }
                registerReportVOList.add(reportVO);
            }
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(registerReportVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/reportExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void reportExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("payCondition");
        fuzzyFields.add("saleLeaderName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<ContractRegisterReportVO> registerReportVOList = new ArrayList<ContractRegisterReportVO>();
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        if (null != page.getRecords() && page.getRecords().size() > 0) {
            List contractRegisterVOList = BeanMapper.mapList((Iterable)page.getRecords(), ContractRegisterVO.class);
            List<Long> contractIdList = contractRegisterVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.logger.info("\u83b7\u53d6\u5408\u540cid\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(contractIdList));
            CommonResponse invoiceReceiveDataRes = this.invoiceReceiveApi.getInvoiceReceiveDataByContractIdList(contractIdList);
            if (!invoiceReceiveDataRes.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u767b\u8bb0\u4e0b\u6e38\u5f00\u7968\u3001\u6536\u6b3e\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0-" + invoiceReceiveDataRes.getMsg());
            }
            String invoiceReceiveDataStr = ((JSONObject)invoiceReceiveDataRes.getData()).toJSONString();
            CommonResponse orderDataRes = this.orderApi.getOrderDataByContractIdList(contractIdList);
            if (!orderDataRes.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u767b\u8bb0\u4e0b\u6e38\u9500\u552e\u3001\u53d1\u8d27\u3001\u9a8c\u6536\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0-" + orderDataRes.getMsg());
            }
            String orderDataStr = ((JSONObject)orderDataRes.getData()).toJSONString();
            Map<Long, JSONObject> settleDataMap = this.settleService.querySettleRecordByContIdList(contractIdList);
            for (ContractRegisterVO record : contractRegisterVOList) {
                JSONObject settle;
                JSONObject order;
                JSONObject orderData;
                JSONObject invoiceReceive;
                ContractRegisterReportVO reportVO = (ContractRegisterReportVO)BeanMapper.map((Object)record, ContractRegisterReportVO.class);
                JSONObject invoiceReceiveData = JSONObject.parseObject((String)invoiceReceiveDataStr);
                if (invoiceReceiveData.containsKey((Object)record.getId()) && (invoiceReceive = (JSONObject)JSONObject.parseObject((String)invoiceReceiveData.getString(record.getId().toString()), JSONObject.class)).size() > 0) {
                    if (null != invoiceReceive.get((Object)"sumInvoiceTaxMny")) {
                        reportVO.setSumInvoiceTaxMny(new BigDecimal(invoiceReceive.get((Object)"sumInvoiceTaxMny").toString()));
                    }
                    if (null != invoiceReceive.get((Object)"sumReceiveTaxMny")) {
                        reportVO.setSumReceiveTaxMny(new BigDecimal(invoiceReceive.get((Object)"sumReceiveTaxMny").toString()));
                    }
                    if (null != invoiceReceive.get((Object)"invoiceDetailList")) {
                        reportVO.setInvoiceDetailList(JSONObject.parseArray((String)invoiceReceive.get((Object)"invoiceDetailList").toString(), JSONObject.class));
                    }
                    if (null != invoiceReceive.get((Object)"receiveDetailList")) {
                        reportVO.setReceiveDetailList(JSONObject.parseArray((String)invoiceReceive.get((Object)"receiveDetailList").toString(), JSONObject.class));
                    }
                }
                if ((orderData = JSONObject.parseObject((String)orderDataStr)).containsKey((Object)record.getId()) && (order = (JSONObject)JSONObject.parseObject((String)orderData.getString(record.getId().toString()), JSONObject.class)).size() > 0) {
                    if (null != order.get((Object)"firstOrderDate")) {
                        reportVO.setFirstOrderDate(new Date(Long.valueOf(order.get((Object)"firstOrderDate").toString())));
                    }
                    if (null != order.get((Object)"productOutState")) {
                        reportVO.setProductOutState(order.get((Object)"productOutState").toString());
                    }
                    if (null != order.get((Object)"checkState")) {
                        reportVO.setCheckState(order.get((Object)"checkState").toString());
                    }
                    if (null != order.get((Object)"salesList")) {
                        reportVO.setSalesList(JSONObject.parseArray((String)order.get((Object)"salesList").toString(), JSONObject.class));
                    }
                    if (null != order.get((Object)"productOutVOList")) {
                        reportVO.setProductOutVOList(JSONObject.parseArray((String)order.get((Object)"productOutVOList").toString(), JSONObject.class));
                    }
                    if (null != order.get((Object)"checkList")) {
                        reportVO.setCheckList(JSONObject.parseArray((String)order.get((Object)"checkList").toString(), JSONObject.class));
                    }
                    if (null != order.get((Object)"deliveryNoticeList")) {
                        reportVO.setDeliveryNoticeNum(Integer.valueOf(reportVO.getDeliveryNoticeList().size()));
                    }
                }
                if (settleDataMap.containsKey(record.getId()) && (settle = (JSONObject)JSONObject.parseObject((String)String.valueOf(settleDataMap.get(record.getId())), JSONObject.class)).size() > 0) {
                    if (null != settle.get((Object)"sumSettleTaxMny")) {
                        reportVO.setSumSettleTaxMny(new BigDecimal(settle.get((Object)"sumSettleTaxMny").toString()));
                    }
                    if (null != settle.get((Object)"settleList")) {
                        reportVO.setSettleList(JSONObject.parseArray((String)settle.get((Object)"settleList").toString(), JSONObject.class));
                    }
                }
                registerReportVOList.add(reportVO);
            }
        }
        HashMap<String, ArrayList<ContractRegisterReportVO>> beans = new HashMap<String, ArrayList<ContractRegisterReportVO>>();
        beans.put("records", registerReportVOList);
        ExcelExport.getInstance().export("ContractRegisterReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryContractBoardList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectBoardVO> queryContractBoardList(@RequestBody QueryParam param) {
        ProjectBoardVO projectBoardVO = this.service.queryContractBoardList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u770b\u677f\u6570\u636e\u6210\u529f\uff01", (Object)projectBoardVO);
    }

    @RequestMapping(value={"/queryProjectBoardList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectBoardList(@RequestBody QueryParam param) {
        CommonResponse projectResponse;
        int pageSize = param.getPageSize();
        int pageIndex = param.getPageIndex();
        String warnNum = null;
        if (null != param.getParams().get("warnNum")) {
            warnNum = ((Parameter)param.getParams().get("warnNum")).getValue().toString();
            param.getParams().remove("warnNum");
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        if (!param.getParams().containsKey("projectStatus")) {
            param.getParams().put("projectStatus", new Parameter("not_in", Arrays.asList(1, 2, 3)));
        }
        if (!(projectResponse = this.projectArchiveApi.queryProjectArchivePage(param)).isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u9879\u76ee\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List<ProjectArchiveVO> projectRecords = ((Page)projectResponse.getData()).getRecords();
        int total = projectRecords.size();
        projectRecords = projectRecords.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        List<ProjectBoardTwoVO> projectBoardTwoVOList = this.service.queryProjectBoardList(param, projectRecords);
        JSONObject page = new JSONObject();
        page.put("records", projectBoardTwoVOList);
        page.put("total", (Object)total);
        page.put("current", (Object)pageIndex);
        page.put("size", (Object)pageSize);
        page.put("pages", (Object)(Math.ceil(total / pageSize) + 1.0));
        page.put("warnNum", (Object)warnNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

