/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.mapper.EngineeringReportMapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.bean.ReviewEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.IReviewService;
import com.ejianc.business.jlincome.report.bean.StrategyEntity;
import com.ejianc.business.jlincome.report.service.IStrategyService;
import com.ejianc.business.warn.vo.WarningReceiveVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/warn/"})
public class WarnController {
    private static final Long TEST_ORG_ID = 1247777316689256450L;
    private static final Long FORMAL_ORG_ID = 100000L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REVIEW_WARN_NAME = "\u5408\u540c\u8bc4\u5ba1\u672a\u5236\u5355";
    private static final String REGISTER_WARN_NAME = "\u767b\u8bb0\u672a\u5236\u5355";
    private static final String SETTLE_WARN_NAME = "\u5bf9\u7532\u7ed3\u7b97\u672a\u5236\u5355";
    private static final String PROJECT_WBS_WARN_NAME = "\u9879\u76ee\u5f85\u7f16\u5199wbs";
    private static final String STRATEGY_WARN_NAME = "\u5de5\u7a0b\u4ea7\u4e1a\u6218\u7565\u6280\u672f\u5408\u4f5c\u5f85\u5f55\u5165\u9884\u8b66";
    private static final String WBS_URL = "/ejc-share-frontend/#/projectWbs";
    private static final String REPORT_URL = "/ejc-jlincome-frontend/#/engineeringReport";
    private static final String REVIEW_URL = "/ejc-jlincome-frontend/#/review";
    private static final String REGISTER_URL = "/ejc-jlincome-frontend/#/contractRegister";
    private static final String SETTLE_URL = "/ejc-jlincome-frontend/#/settle";
    private static final String STRATEGY_URL = "/ejc-jlincome-frontend/#/strategy";
    @Autowired
    private IReviewService reviewService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;
    @Autowired
    private IStrategyService strategyService;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private EngineeringReportMapper engineeringReportMapper;

    @PostMapping(value={"reviewWarn"})
    public CommonResponse<String> reviewWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        QueryParam param = new QueryParam();
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        ArrayList<Object> Status = new ArrayList<Object>();
        Status.add(ArchiveProjectStatusEnum.\u5df2\u4e2d\u6807.getCode());
        Status.add(ArchiveProjectStatusEnum.\u5408\u540c\u9636\u6bb5.getCode());
        Status.add(ArchiveProjectStatusEnum.\u751f\u4ea7\u9636\u6bb5.getCode());
        Status.add(ArchiveProjectStatusEnum.\u4f9b\u8d27\u9636\u6bb5.getCode());
        Status.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        map.put("projectStatus", new Parameter("in", Status));
        map.put("dr", new Parameter("eq", (Object)0));
        param.setParams(map);
        CommonResponse page = this.projectApi.queryProjectArchivePage(param);
        List recordsList = ((Page)page.getData()).getRecords();
        List<ReviewEntity> reviewList = this.reviewService.selectList();
        List projectIds = reviewList.stream().map(ReviewEntity::getProjectId).collect(Collectors.toList());
        List filteredRecordsList = recordsList.stream().filter(record -> !projectIds.contains(record.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredRecordsList)) {
            this.logger.error("\u6267\u884c\u5408\u540c\u8bc4\u5ba1\u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u672a\u505a\u5408\u540c\u8bc4\u5ba1\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(filteredRecordsList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (ProjectArchiveVO projectArchiveVO : filteredRecordsList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(projectArchiveVO.getName());
            vo.setPcTitle("\u5408\u540c\u8bc4\u5ba1");
            vo.setPcUrl(REVIEW_URL);
            vo.setOrgId(projectArchiveVO.getProjectDepartmentId());
            vo.setOrgName(projectArchiveVO.getProjectDepartmentName());
            vo.setSourceId(projectArchiveVO.getId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            ArrayList<WarningReceiveVO> receiveList = new ArrayList<WarningReceiveVO>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            receiveVO.setName(projectArchiveVO.getSaleLeaderName());
            receiveVO.setNameId(projectArchiveVO.getSaleLeaderId());
            receiveVO.setType("user");
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", projectArchiveVO.getName()));
            resp.add(vo);
        }
        return this.sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"contractRegisterWarn"})
    public CommonResponse<String> contractRegisterWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<ReviewEntity> list = this.reviewService.selectReviewList();
        if (CollectionUtils.isEmpty(list)) {
            this.logger.error("\u6267\u884c\u767b\u8bb0\u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u672a\u505a\u5408\u540c\u767b\u8bb0\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(list));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (ReviewEntity reviewEntity : list) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(reviewEntity.getProjectName());
            vo.setPcTitle("\u5408\u540c\u767b\u8bb0");
            vo.setPcUrl(REGISTER_URL);
            vo.setOrgId(reviewEntity.getOrgId());
            vo.setOrgName(reviewEntity.getOrgName());
            vo.setSourceId(reviewEntity.getId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            ArrayList<WarningReceiveVO> receiveList = new ArrayList<WarningReceiveVO>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            receiveVO.setName(reviewEntity.getSaleLeaderName());
            receiveVO.setNameId(reviewEntity.getSaleLeaderId());
            receiveVO.setType("user");
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", reviewEntity.getProjectName()));
            resp.add(vo);
        }
        return this.sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"wbsWarn"})
    public CommonResponse<String> wbsWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse response = this.shareProjectWbsApi.getProjectIdsNoWbs();
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        List projectArchiveVOList = (List)response.getData();
        if (CollectionUtils.isEmpty((Collection)projectArchiveVOList)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u5f85\u7f16\u5199wbs\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        List projectIds = projectArchiveVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        List contractRegisterEntityList = this.contractRegisterService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"project_id", projectIds)).in((Object)"bill_state", billStates));
        Set set = contractRegisterEntityList.stream().map(ContractRegisterEntity::getProjectId).collect(Collectors.toSet());
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (ProjectArchiveVO project : projectArchiveVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            if (!set.contains(project.getId())) continue;
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(project.getName());
            vo.setPcTitle("\u5f85\u7f16\u5199WBS");
            vo.setPcUrl("/ejc-share-frontend/#/projectWbs?id=" + project.getId().toString() + "&name=" + project.getName());
            vo.setOrgId(project.getOrgId());
            vo.setOrgName(project.getOrgName());
            vo.setSourceId(project.getId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", project.getName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"reportWarn"})
    public CommonResponse<String> reportWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<EngineeringReportEntity> list = this.engineeringReportMapper.getAssistNoPass();
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (EngineeringReportEntity entity : list) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(entity.getEngineeringName());
            vo.setPcTitle("\u5f85\u6280\u672f\u51fa\u56fe");
            vo.setPcUrl(REPORT_URL);
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#engineeringName#", entity.getEngineeringName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"settleWarn"})
    public CommonResponse<String> settleWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<ContractRegisterEntity> list = this.contractRegisterService.selectExpireContractList();
        if (CollectionUtils.isEmpty(list)) {
            this.logger.error("\u6267\u884c\u5bf9\u7532\u7ed3\u7b97\u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u672a\u505a\u5bf9\u7532\u8ba1\u7b97\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(list));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (ContractRegisterEntity contractRegisterEntity : list) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(contractRegisterEntity.getContractName());
            vo.setPcTitle("\u5bf9\u7532\u7ed3\u7b97");
            vo.setPcUrl(SETTLE_URL);
            vo.setOrgId(contractRegisterEntity.getParentOrgId());
            vo.setOrgName(contractRegisterEntity.getParentOrgName());
            vo.setSourceId(contractRegisterEntity.getId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractRegisterEntity.getContractName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"strategyWarn"})
    public CommonResponse<String> receivableWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        ArrayList orgIds = new ArrayList();
        Date now = new Date();
        List list = this.strategyService.list((Wrapper)new LambdaQueryWrapper().eq(StrategyEntity::getReportMonth, (Object)new Date(now.getYear(), now.getMonth(), 1)));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.error("\u6267\u884c\u5de5\u7a0b\u4ea7\u4e1a\u6218\u7565\u6280\u672f\u5408\u4f5c\u5f85\u5f55\u5165\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        Object tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u5de5\u7a0b\u4ea7\u4e1a\u6218\u7565\u6280\u672f\u5408\u4f5c");
        vo.setOrgId(Long.valueOf(1247777316689256450L));
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u5de5\u7a0b\u4ea7\u4e1a\u6218\u7565\u6280\u672f\u5408\u4f5c");
        vo.setPcUrl(STRATEGY_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        vo.setEarlywarnContent(defaultWarnInfo.getString("earlywarnContent"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private CommonResponse<String> sendWarnToTaskWithReceive(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterWithReceive(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

