/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.ejianc.business.jlincome.income.bean.DisclosureDepDetailsEntity;
import com.ejianc.business.jlincome.income.bean.DisclosureEntity;
import com.ejianc.business.jlincome.income.mapper.DisclosureMapper;
import com.ejianc.business.jlincome.income.service.IDisclosureService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="disclosureService")
public class DisclosureServiceImpl
extends BaseServiceImpl<DisclosureMapper, DisclosureEntity>
implements IDisclosureService {
    @Autowired
    private IPushMessageApi pushMessageApi;
    private static final String PC_URL = "/ejc-jlincome-frontend/#/disclosure/card?id=";
    private static final String MOBILE_URL = "/ejc-jlincome-mobile/#/disclosure/card?id=";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String sendMsgToInstallPerson(DisclosureEntity entity) {
        this.logger.info("\u90e8\u95e8\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09");
        String msg = this.sendMsg(entity, "\u90e8\u95e8\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09", entity.getProjectName() + "\u9879\u76ee\u6709\u4e00\u9879\u91cd\u8981\u7684\u5408\u540c\u4ea4\u5e95\u9700\u8981\u67e5\u770b\uff01\uff01\uff01");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u90e8\u95e8\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09 \u5f02\u5e38\uff1a" + msg);
        }
        this.logger.info("\u90e8\u95e8\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09\u7ed3\u675f\uff01");
        return msg;
    }

    private String sendMsg(DisclosureEntity entity, String subject, String content) {
        List<DisclosureDepDetailsEntity> list = entity.getDisclosureDepDetailsList();
        ArrayList<String> idList = new ArrayList<String>();
        for (DisclosureDepDetailsEntity details : list) {
            String id = details.getDepartmentPeopleId();
            idList.add(id);
        }
        Object[] departmentPeopleIds = (String[])idList.stream().toArray(String[]::new);
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])departmentPeopleIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])departmentPeopleIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(content);
        msgParameter.setMsgType("bpmpass");
        msgParameter.setTenantId(entity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys", "zhiyuanoa"});
        msgParameter.setPcUrl(PC_URL + entity.getId());
        msgParameter.setMobileUrl(MOBILE_URL + entity.getId());
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}

