/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.report.bean.MarketAnalysisDetailEntity;
import com.ejianc.business.jlincome.report.bean.MarketAnalysisEntity;
import com.ejianc.business.jlincome.report.service.IMarketAnalysisDetailService;
import com.ejianc.business.jlincome.report.service.IMarketAnalysisService;
import com.ejianc.business.jlincome.report.vo.MarketAnalysisDetailVO;
import com.ejianc.business.jlincome.report.vo.MarketAnalysisReportVO;
import com.ejianc.business.jlincome.report.vo.MarketAnalysisVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"marketAnalysis"})
public class MarketAnalysisController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "YS_MANAGE_CODE";
    @Autowired
    private IMarketAnalysisService service;
    @Autowired
    private IMarketAnalysisDetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MarketAnalysisVO> saveOrUpdate(@RequestBody MarketAnalysisVO saveOrUpdateVO) {
        List list;
        MarketAnalysisEntity entity = (MarketAnalysisEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MarketAnalysisEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MarketAnalysisEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
        queryWrapper.eq(MarketAnalysisEntity::getMonth, (Object)saveOrUpdateVO.getMonth());
        if (null != entity.getId()) {
            queryWrapper.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.service.list((Wrapper)queryWrapper)))) {
            throw new BusinessException("\u76f8\u540c\u533a\u57df,\u6708\u4efd \u53ea\u80fd\u586b\u62a5\u4e00\u6b21\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        MarketAnalysisVO vo = (MarketAnalysisVO)BeanMapper.map((Object)((Object)entity), MarketAnalysisVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MarketAnalysisVO> queryDetail(Long id) {
        MarketAnalysisEntity entity = (MarketAnalysisEntity)((Object)this.service.selectById(id));
        MarketAnalysisVO vo = (MarketAnalysisVO)BeanMapper.map((Object)((Object)entity), MarketAnalysisVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailByOrg"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MarketAnalysisDetailVO>> queryDetail(Long orgId, String month) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        Date mm = null;
        try {
            Date date = dateFormat.parse(month);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(2, -1);
            mm = calendar.getTime();
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MarketAnalysisEntity::getOrgId, (Object)orgId);
        queryWrapper.eq(MarketAnalysisEntity::getMonth, (Object)mm);
        List list = this.service.list((Wrapper)queryWrapper);
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            queryWrapper2.eq(MarketAnalysisDetailEntity::getAnalysisId, (Object)((MarketAnalysisEntity)((Object)list.get(0))).getId());
            List marketAnalysisEntityList = this.detailService.list((Wrapper)queryWrapper2);
            marketAnalysisEntityList.forEach(e -> {
                e.setAnalysisId(null);
                e.setRowState("add");
            });
            resList = BeanMapper.mapList((Iterable)marketAnalysisEntityList, MarketAnalysisDetailVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", resList);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MarketAnalysisVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MarketAnalysisVO marketAnalysisVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MarketAnalysisVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("month")) {
            String month = ((Parameter)param.getParams().get("month")).toString();
            param.getParams().put("month", new Parameter("eq", (Object)(month + "-01")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MarketAnalysisVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryListReport(@RequestBody QueryParam param) {
        List<MarketAnalysisReportVO> detialList;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<MarketAnalysisReportVO> resList = this.service.queryListAll(page, wrapper);
        if (CollectionUtils.isNotEmpty(resList) && CollectionUtils.isNotEmpty(detialList = this.service.queryDetailAll(resList.stream().map(BaseVO::getId).collect(Collectors.toList())))) {
            resList.addAll(detialList);
        }
        JSONObject res = new JSONObject();
        res.put("records", (Object)TreeNodeBUtil.buildTree(resList));
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resList = BeanMapper.mapList((Iterable)list, MarketAnalysisVO.class);
            resList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", resList);
        ExcelExport.getInstance().export("MarketAnalysis-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<MarketAnalysisReportVO> resList = this.service.queryListAll(page, wrapper);
        List<MarketAnalysisReportVO> detialList = this.service.queryDetailAll(resList.stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(detialList)) {
            resList.addAll(detialList);
        }
        ArrayList list = new ArrayList();
        List res = TreeNodeBUtil.buildTree(resList);
        res.forEach(e -> {
            list.add(e);
            if (CollectionUtils.isNotEmpty((Collection)e.getChildren())) {
                list.addAll(e.getChildren());
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList(list, MarketAnalysisReportVO.class));
        ExcelExport.getInstance().export("MarketAnalysisReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMarketAnalysisData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MarketAnalysisVO>> refMarketAnalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MarketAnalysisVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

