/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.report.bean.ReceivableManageEntity;
import com.ejianc.business.jlincome.report.service.IReceivableManageService;
import com.ejianc.business.jlincome.report.vo.ReceivableManageReportVO;
import com.ejianc.business.jlincome.report.vo.ReceivableManageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"receivableManage"})
public class ReceivableManageController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "HZ_MARKET_CODE";
    @Autowired
    private IReceivableManageService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReceivableManageVO> saveOrUpdate(@RequestBody ReceivableManageVO saveOrUpdateVO) {
        ReceivableManageEntity entity = (ReceivableManageEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReceivableManageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ReceivableManageVO vo = (ReceivableManageVO)BeanMapper.map((Object)((Object)entity), ReceivableManageVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceivableManageVO> queryDetail(Long id) {
        ReceivableManageEntity entity = (ReceivableManageEntity)((Object)this.service.selectById(id));
        ReceivableManageVO vo = (ReceivableManageVO)BeanMapper.map((Object)((Object)entity), ReceivableManageVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceivableManageVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReceivableManageVO receivableManageVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReceivableManageVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReceivableManageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryListReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List<Object> resList = new ArrayList();
        HashMap map = new HashMap();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ReceivableManageReportVO> RecordVOList = this.service.queryListAll(page, wrapper);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        if (CollectionUtils.isNotEmpty(RecordVOList)) {
            RecordVOList.forEach(e -> {
                ArrayList<ReceivableManageReportVO> list = new ArrayList<ReceivableManageReportVO>();
                list.add((ReceivableManageReportVO)e);
                map.put(e.getOrgId().toString() + e.getReceivableDate(), list);
            });
        }
        String receivableDate = "";
        if (param.getParams().containsKey("receivableDate")) {
            receivableDate = ((Parameter)param.getParams().get("receivableDate")).getValue().toString();
        }
        List<ReceivableManageReportVO> detialList = this.service.queryDetailAll(receivableDate);
        detialList.forEach(e -> {
            String key = e.getOrgId().toString() + e.getReceivableDate();
            if (map.containsKey(key)) {
                List list = (List)map.get(key);
                e.setParentId(((ReceivableManageReportVO)list.get(0)).getId());
                list.add(e);
                map.put(key, list);
            }
        });
        resList = map.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
        JSONObject res = new JSONObject();
        res.put("records", (Object)TreeNodeBUtil.buildTree(resList));
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resList = BeanMapper.mapList((Iterable)list, ReceivableManageVO.class);
            resList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", resList);
        ExcelExport.getInstance().export("ReceivableManage-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List<Object> resList = new ArrayList();
        HashMap map = new HashMap();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ReceivableManageReportVO> RecordVOList = this.service.queryListAll(page, wrapper);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        if (CollectionUtils.isNotEmpty(RecordVOList)) {
            RecordVOList.forEach(e -> {
                ArrayList<ReceivableManageReportVO> list = new ArrayList<ReceivableManageReportVO>();
                list.add((ReceivableManageReportVO)e);
                map.put(e.getOrgId().toString() + sf.format(e.getReceivableDate()), list);
            });
        }
        String receivableDate = "";
        if (param.getParams().containsKey("receivableDate")) {
            receivableDate = ((Parameter)param.getParams().get("receivableDate")).getValue().toString();
        }
        List<ReceivableManageReportVO> detialList = this.service.queryDetailAll(receivableDate);
        detialList.forEach(e -> {
            String key = e.getOrgId().toString() + sf.format(e.getReceivableDate());
            if (map.containsKey(key)) {
                List list = (List)map.get(key);
                e.setParentId(((ReceivableManageReportVO)list.get(0)).getId());
                list.add(e);
                map.put(key, list);
            }
        });
        resList = map.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
        ArrayList list2 = new ArrayList();
        List res = TreeNodeBUtil.buildTree(resList);
        res.forEach(e -> {
            list2.add(e);
            if (CollectionUtils.isNotEmpty((Collection)e.getChildren())) {
                list2.addAll(e.getChildren());
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList(list2, ReceivableManageReportVO.class));
        ExcelExport.getInstance().export("ReceivableManageReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refReceivableManageData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReceivableManageVO>> refReceivableManageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReceivableManageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

