/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.report.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.report.vo.ProjectMnyReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectProgressPayment"})
public class projectProgressPaymentController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractRegisterService contractRegisterService;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectMnyReportVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ProjectMnyReportVO> fatherList = this.contractRegisterService.queryProjectMnyReportPage((Page<ProjectMnyReportVO>)page, wrapper);
        List<Long> ids = fatherList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<ProjectMnyReportVO> sonList = this.contractRegisterService.queryProjectMnyReportSonList(ids);
        Map<Long, ProjectMnyReportVO> fatherMap = fatherList.stream().collect(Collectors.toMap(BaseVO::getId, item -> item));
        if (CollectionUtils.isNotEmpty(sonList)) {
            sonList.forEach(son -> {
                Long projectId = son.getProjectId();
                son.setParentID(projectId);
                ProjectMnyReportVO projectMnyReportVO = (ProjectMnyReportVO)fatherMap.get(projectId);
                projectMnyReportVO.setSubcontractMny(projectMnyReportVO.getSubcontractMny().add(son.getSubcontractMny()));
                projectMnyReportVO.setSubcontractPayMny(projectMnyReportVO.getSubcontractPayMny().add(son.getSubcontractPayMny()));
                son.setSubcontractPayRatio(son.getSubcontractMny().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : son.getSubcontractPayMny().divide(son.getSubcontractMny(), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)));
            });
        }
        List<Object> resList = new ArrayList<ProjectMnyReportVO>(fatherMap.values());
        resList.forEach(father -> {
            if (father.getSettleMny().compareTo(BigDecimal.ZERO) == 0) {
                father.setSettleNoReceiveMny(BigDecimal.ZERO);
                father.setReceiveRatio(BigDecimal.ZERO);
            } else {
                father.setSettleNoReceiveMny(father.getSettleMny().subtract(father.getReceiveMny()));
                father.setReceiveRatio(father.getSettleNoReceiveMny().divide(father.getSettleMny(), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)));
            }
            father.setSubcontractPayRatio(father.getSubcontractMny().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : father.getSubcontractPayMny().divide(father.getSubcontractMny(), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)));
        });
        resList.addAll(sonList);
        resList = TreeNodeBUtil.buildTree(resList);
        page.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

