package com.ejianc.business.jlincome.bid.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlincome.bid.bean.EngineeringPersonEntity;
import com.ejianc.business.jlincome.bid.bean.EngineeringResearchEntity;
import org.apache.xpath.operations.Bool;

/**
 * 投标-工程调研报告
 *
 * @author generator
 *
 */
 @TableName("ejc_bid_engineering_report")
public class EngineeringReportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="custom_name")
    private String customName; // 客户名称
    @TableField(value="org_id")
    private Long orgId; // 组织/区域主键
    @TableField(value="org_name")
    private String orgName; // 组织名称/区域名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码/区域编码
    @TableField(value="project_type_id")
    private Long projectTypeId; // 项目类型
    @TableField(value="project_type_name")
    private String projectTypeName; // 项目类型名称
    @TableField(value="product_type")
    private String productType; // 产品类型
    @TableField(value="product_type_name")
    private String productTypeName; // 产品类型名称
    @TableField(value="owner_company")
    private String ownerCompany; // 业主单位
    @TableField(value="design_company")
    private String designCompany; // 设计单位
    @TableField(value="is_assist")
    private Integer isAssist; // 是否需要协助（1 需要，0）
    @TableField(value="expected_date")
    private Date expectedDate; // 期望出图时间
    @TableField(value="estimated_date")
    private Date estimatedDate; // 预计交货时间
    @TableField(value="estimated_contract_mny")
    private BigDecimal estimatedContractMny; // 预计合同金额
    @TableField(value="sale_leader_id")
    private Long saleLeaderId; // 销售负责人
    @TableField(value="sale_leader_name")
    private String saleLeaderName; // 销售负责人名称
    @TableField(value="sale_leader_phone")
    private String saleLeaderPhone; // 销售负责人联系电话
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="is_repeat")
    private Boolean isRepeat; // 是否重复询价
    @TableField(value="engineering_id")
    private Long engineeringId; // 工程主键
    @TableField(value="engineering_name")
    private String engineeringName; // 工程名称
    @TableField(value="engineering_code")
    private String engineeringCode; // 工程编码
    @TableField(value="change_code")
    private String changeCode; // 变更版本
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="change_memo")
    private String changeMemo; // 变更原因
    @TableField(value="effect_date")
    private Date effectDate; // 生效时间
    @TableField(value="install_leader_id")
    private Long installLeaderId; // 安装负责人
    @TableField(value="install_leader_name")
    private String installLeaderName; // 安装负责人名称

    @TableField(exist=false)
    @SubEntity(serviceName="engineeringPersonService",pidName = "reportId")
    private List<EngineeringPersonEntity> engineeringPersonList = new ArrayList<>(); // 投标-工程调研报告-项目主要负责人
    @TableField(exist=false)
    @SubEntity(serviceName="engineeringResearchService",pidName = "reportId")
    private List<EngineeringResearchEntity> engineeringResearchList = new ArrayList<>(); // 投标-工程调研报告-调研报告内容
    @TableField(value="engineering_progress")
    private String engineeringProgress; // 工程进度

    @TableField(value="quote")
    private Integer quote; // 是否施工报价 (1-需要 0-不需要)
    @TableField(value="quote_mny")
    private BigDecimal quoteMny; // 施工报价金额


    public Boolean getRepeat() {
        return isRepeat;
    }

    public void setRepeat(Boolean repeat) {
        isRepeat = repeat;
    }

    public Integer getQuote() {
        return quote;
    }

    public void setQuote(Integer quote) {
        this.quote = quote;
    }

    public BigDecimal getQuoteMny() {
        return quoteMny;
    }

    public void setQuoteMny(BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }

    public String getEngineeringProgress() {
        return engineeringProgress;
    }

    public void setEngineeringProgress(String engineeringProgress) {
        this.engineeringProgress = engineeringProgress;
    }
    public String getInstallLeaderName() {
        return installLeaderName;
    }

    public void setInstallLeaderName(String installLeaderName) {
        this.installLeaderName = installLeaderName;
    }

    public Long getInstallLeaderId() {
        return installLeaderId;
    }

    public void setInstallLeaderId(Long installLeaderId) {
        this.installLeaderId = installLeaderId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getCustomName() {
        return customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }

    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public String getOwnerCompany() {
        return ownerCompany;
    }

    public void setOwnerCompany(String ownerCompany) {
        this.ownerCompany = ownerCompany;
    }
    public String getDesignCompany() {
        return designCompany;
    }

    public void setDesignCompany(String designCompany) {
        this.designCompany = designCompany;
    }
    public Integer getIsAssist() {
        return isAssist;
    }

    public void setIsAssist(Integer isAssist) {
        this.isAssist = isAssist;
    }
    public Date getExpectedDate() {
        return expectedDate;
    }

    public void setExpectedDate(Date expectedDate) {
        this.expectedDate = expectedDate;
    }
    public Date getEstimatedDate() {
        return estimatedDate;
    }

    public void setEstimatedDate(Date estimatedDate) {
        this.estimatedDate = estimatedDate;
    }
    public BigDecimal getEstimatedContractMny() {
        return estimatedContractMny;
    }

    public void setEstimatedContractMny(BigDecimal estimatedContractMny) {
        this.estimatedContractMny = estimatedContractMny;
    }
    public Long getSaleLeaderId() {
        return saleLeaderId;
    }

    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEngineeringId() {
        return engineeringId;
    }

    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public String getEngineeringCode() {
        return engineeringCode;
    }

    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }


    public List<EngineeringPersonEntity> getEngineeringPersonList() {
        return engineeringPersonList;
    }

    public void setEngineeringPersonList(List<EngineeringPersonEntity> engineeringPersonList) {
        this.engineeringPersonList = engineeringPersonList;
    }

    public List<EngineeringResearchEntity> getEngineeringResearchList() {
        return engineeringResearchList;
    }

    public void setEngineeringResearchList(List<EngineeringResearchEntity> engineeringResearchList) {
        this.engineeringResearchList = engineeringResearchList;
    }

    public Boolean getIsRepeat() {
        return isRepeat;
    }

    public void setIsRepeat(Boolean isRepeat) {
        this.isRepeat = isRepeat;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeMemo() {
        return changeMemo;
    }

    public void setChangeMemo(String changeMemo) {
        this.changeMemo = changeMemo;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
}
