package com.ejianc.business.jlincome.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jlcost.cost.vo.ProductVO;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.bid.enums.BusinessStageEnum;
import com.ejianc.business.jlincome.bid.service.IResultRegisterService;
import com.ejianc.business.jlincome.bid.vo.BusinessReportHVO;
import com.ejianc.business.jlincome.bid.vo.BusinessReportVO;
import com.ejianc.business.jlincome.bid.vo.SalePromoteVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import com.ejianc.business.jlincome.bid.vo.BusinessVO;

/**
 * 投标-商机登记
 *
 * @author generator
 */
@RestController
@RequestMapping("business")
public class BusinessController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BUSINESS";//此处需要根据实际修改

    @Autowired
    private IBusinessService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectArchiveApi projectArchiveApi;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BusinessVO> saveOrUpdate(@RequestBody BusinessVO saveOrUpdateVO) {
        BusinessEntity entity = BeanMapper.map(saveOrUpdateVO, BusinessEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setAbandonFlag(false);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (null != entity.getBillState() && (1 == entity.getBillState() || 3 == entity.getBillState())) {
            BusinessEntity oldEntity = service.selectById(saveOrUpdateVO.getId());
            if ((null == oldEntity.getBusinessRound() && null != saveOrUpdateVO.getBusinessRound()) || (null != oldEntity.getBusinessRound() && null != saveOrUpdateVO.getBusinessRound() && oldEntity.getBusinessRound() != saveOrUpdateVO.getBusinessRound())) {
                CommonResponse<String> projectArchiveRes = projectArchiveApi.updateBusinessRound(entity.getBusinessRound(), entity.getId());
                if (!projectArchiveRes.isSuccess()) {
                    throw new BusinessException("修改项目信息-商机阶段失败，原因-" + projectArchiveRes.getMsg());
                }
            }
        }
        service.saveOrUpdate(entity, false);
        BusinessVO vo = BeanMapper.map(entity, BusinessVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BusinessVO> queryDetail(Long id) {
        BusinessEntity entity = service.selectById(id);
        BusinessVO vo = BeanMapper.map(entity, BusinessVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusinessVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BusinessVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BusinessVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BusinessVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("customName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("businessRound");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (null != param.getParams().get("selfFlag")) {
            String selfFlag = param.getParams().get("selfFlag").getValue().toString();
            param.getParams().remove("selfFlag");
            if ("1".equals(selfFlag)) {
                param.getParams().put("saleLeaderId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
            }
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = null;
        if (param.getParams().containsKey("orgId")) {
            orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().remove("orgId");
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        } else {
            orgId = InvocationInfoProxy.getOrgId();
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BusinessEntity> page = service.queryPage(param, false);
        IPage<BusinessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BusinessVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("customName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("businessRound");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        List<BusinessEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<BusinessVO> voList = BeanMapper.mapList(list, BusinessVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            e.setAbandonFlagName(null != e.getAbandonFlag() ? "是" : "否");
            e.setBusinessStageName("0".equals(e.getBusinessStage()) ? "跟踪" : "1".equals(e.getBusinessStage()) ? "中标" : "放弃");
            if (null != e.getBusinessRound()) {
                switch (e.getBusinessRound()) {
                    case 0:
                        e.setBusinessRoundName("项目立项");
                        break;
                    case 1:
                        e.setBusinessRoundName("设计方案");
                        break;
                    case 2:
                        e.setBusinessRoundName("业主招标");
                        break;
                    case 3:
                        e.setBusinessRoundName("总包招标");
                        break;
                    case 4:
                        e.setBusinessRoundName("合同签订");
                        break;
                }
            }
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("Business-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBusinessData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BusinessVO>> refBusinessData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        //设置模糊查询
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("saleLeaderPhone");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        /**
         * 数据过滤
         */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        // 组织过滤
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BusinessEntity> page = service.queryPage(param, false);
        IPage<BusinessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<BusinessVO> list = BeanMapper.mapList(page.getRecords(), BusinessVO.class);
        pageData.setRecords(list);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param id
     * @Description updateAbandonFlag 修改放弃状态
     */
    @RequestMapping(value = "/updateAbandonFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateAbandonFlag(Long id, Boolean abandonFlag) {
        return service.updateAbandonFlag(id, abandonFlag);
    }

    /**
     * @param id
     * @Description updateBusinessRound 修改商机阶段
     */
    @RequestMapping(value = "/updateBusinessRound", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateBusinessRound(Long id, Integer businessRound) {
        return service.updateBusinessRound(id, businessRound);
    }


    /**
     * 校验工程名是否重复
     * @param vo
     * @return
     */
    @PostMapping(value = "/checkIsSave")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody BusinessVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }


    /**
     * 查询销售推动漏斗数据
     * @param
     * @return
     */
    @RequestMapping(value = "/querySalePromoteDataList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SalePromoteVO> querySalePromoteDataList(@RequestBody QueryParam param) {
        SalePromoteVO saleReportVO = service.querySalePromoteDataList(param);
        return CommonResponse.success("查询销售推动漏斗数据成功！", saleReportVO);
    }



    /**
     * 查询项目、产品类型占比分析
     * @param
     * @return
     */
    @RequestMapping(value = "/queryProjectProductData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectProductData(@RequestBody QueryParam param) {
        JSONObject jsonObject = service.queryProjectProductData(param);
        return CommonResponse.success("查询项目、产品类型占比分析数据成功！", jsonObject);
    }

    @RequestMapping(value = "/querySjReportTopTen", method = RequestMethod.GET)
    public CommonResponse<List<BusinessReportVO>> querySjReportTopTen(String start, String end) {
        /** 模糊搜索配置字段示例 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = 2405220178L;
        List<OrgVO> orgList = iOrgApi.findChildrenByParentId(orgId).getData();
        Map<Long,OrgVO> childOrgMap = new HashMap<>();
        Map<Long,List<Long>> childOrgsMap = new HashMap<>();//key-工程部直接下级组织  key-工程部直接下级组织  的 本下组织id
        orgList.forEach(e->{
            if(orgId.equals(e.getParentId())){
                childOrgMap.put(e.getId(),e);
            }
        });
        for (Long key : childOrgMap.keySet()) {
            String korgId = key.toString();
            orgList.forEach(e->{
                if(e.getInnerCode().contains(korgId)){
                    if(childOrgsMap.containsKey(key)){
                        List<Long> orgIds =childOrgsMap.get(key);
                        orgIds.add(e.getId());
                        childOrgsMap.put(key,orgIds);
                    }else{
                        List<Long> orgIds = new ArrayList<>();
                        orgIds.add(e.getId());
                        childOrgsMap.put(key,orgIds);
                    }
                }
            });
        }

        List<BusinessReportVO> sjList = new ArrayList<>();
        Integer sjNums = service.querySjReportNum(start,end);//商机总数
        Integer gcbsjNum = 0;//工程部下边商机总数

        for (Long key : childOrgsMap.keySet()) {
            BusinessReportVO businessReportVO = new BusinessReportVO();
            businessReportVO.setId(key);
            businessReportVO.setOrgId(key);
            businessReportVO.setOrgName(childOrgMap.get(key).getName());
            Integer sjNum = service.querySjReportTopTen(start,end,childOrgsMap.get(key));
            if(null!=sjNum){
                gcbsjNum = gcbsjNum+sjNum;
            }
            businessReportVO.setSjNum(sjNum);
            sjList.add(businessReportVO);
        }
        //增加  剩余数量  设置为其他
        BusinessReportVO businessReportVO = new BusinessReportVO();
        businessReportVO.setId(11L);
        businessReportVO.setOrgId(11L);
        businessReportVO.setOrgName("其他");
        businessReportVO.setSjNum(sjNums-gcbsjNum);
        sjList.add(businessReportVO);
        //排序
        sjcoll(sjList);
        List<BusinessReportVO> sjList2 =  sjList.subList(0, Math.min(10, sjList.size()));
        return CommonResponse.success("查询列表数据成功！",sjList2);
    }


    @RequestMapping(value = "/queryZbReportTopTen", method = RequestMethod.GET)
    public CommonResponse<List<BusinessReportVO>> queryZbReportTopTen(String start, String end) {
        /** 模糊搜索配置字段示例 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = 2405220178L;
        List<OrgVO> orgList = iOrgApi.findChildrenByParentId(orgId).getData();
        Map<Long,OrgVO> childOrgMap = new HashMap<>();
        Map<Long,List<Long>> childOrgsMap = new HashMap<>();//key-工程部直接下级组织  key-工程部直接下级组织  的 本下组织id
        orgList.forEach(e->{
            if(orgId.equals(e.getParentId())){
                childOrgMap.put(e.getId(),e);
            }
        });
        for (Long key : childOrgMap.keySet()) {
            String korgId = key.toString();
            orgList.forEach(e->{
                if(e.getInnerCode().contains(korgId)){
                    if(childOrgsMap.containsKey(key)){
                        List<Long> orgIds =childOrgsMap.get(key);
                        orgIds.add(e.getId());
                        childOrgsMap.put(key,orgIds);
                    }else{
                        List<Long> orgIds = new ArrayList<>();
                        orgIds.add(e.getId());
                        childOrgsMap.put(key,orgIds);
                    }
                }
            });
        }

        List<BusinessReportVO> zbList = new ArrayList<>();
        Integer sjNums = service.querySjReportNum(start,end);//商机总数
        Integer zbNums = service.queryZbReportNum(start,end);//中标总数

        Integer gcbsjNum = 0;//工程部下边商机总数
        Integer gcbzbNum = 0;//工程部下边中标总数

        for (Long key : childOrgsMap.keySet()) {
            BusinessReportVO businessReportVO = new BusinessReportVO();
            businessReportVO.setId(key);
            businessReportVO.setOrgId(key);
            businessReportVO.setOrgName(childOrgMap.get(key).getName());
            Integer sjNum = service.querySjReportTopTen(start,end,childOrgsMap.get(key));
            if(null!=sjNum){
                gcbsjNum = gcbsjNum+sjNum;
            }
            businessReportVO.setSjNum(sjNum);
            Integer zbNum = service.queryZbReportTopTen(start,end,childOrgsMap.get(key));
            if(null!=zbNum){
                gcbzbNum = gcbzbNum+zbNum;
            }
            businessReportVO.setZbNum(zbNum);
            if(null==sjNum||0==sjNum||null==zbNum||0==zbNum){
                businessReportVO.setScale(BigDecimal.ZERO);
            }else{
                businessReportVO.setScale(ComputeUtil.safeDiv(new BigDecimal(zbNum),new BigDecimal(sjNum)).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP));
            }
            zbList.add(businessReportVO);
        }
        //增加  剩余数量  设置为其他
        BusinessReportVO businessReportVO = new BusinessReportVO();
        businessReportVO.setId(11L);
        businessReportVO.setOrgId(11L);
        businessReportVO.setOrgName("其他");
        businessReportVO.setSjNum(sjNums-gcbsjNum);
        businessReportVO.setZbNum(zbNums-gcbzbNum);
        businessReportVO.setScale(ComputeUtil.safeDiv(new BigDecimal(zbNums-gcbzbNum),new BigDecimal(sjNums-gcbsjNum)).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP));
        zbList.add(businessReportVO);

        //排序
        zbcoll(zbList);
        List<BusinessReportVO> zbList2 = zbList.subList(0, Math.min(10, zbList.size()));
        return CommonResponse.success("查询列表数据成功！",zbList2);
    }

    public static void sjcoll(List<BusinessReportVO> list) {
        Collections.sort(list, new Comparator<BusinessReportVO>() {
            @Override
            public int compare(BusinessReportVO o1, BusinessReportVO o2) {
                return o2.getSjNum() - o1.getSjNum(); //按数量从大到小排序
            }
        });
    }

    public static void zbcoll(List<BusinessReportVO> list) {
        Collections.sort(list, new Comparator<BusinessReportVO>() {
            @Override
            public int compare(BusinessReportVO o1, BusinessReportVO o2) {
                return o2.getScale().compareTo(o1.getScale()); //按数量从大到小排序
            }
        });
    }

}
