package com.ejianc.business.jlincome.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportRecordEntity;
import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportRecordService;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportExportVO;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportRecordVO;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportReportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 投标-工程调研报告
 *
 * @author generator
 */
@Controller
@RequestMapping("engineeringReport")
public class EngineeringReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    private static final String BILL_CODE = "EResearch";//此处需要根据实际修改

    @Autowired
    private IEngineeringReportService service;
    @Autowired
    private IEngineeringReportRecordService recordService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private BusinessMapper businessMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EngineeringReportVO> saveOrUpdate(@RequestBody EngineeringReportVO saveOrUpdateVO) {
        EngineeringReportEntity entity = BeanMapper.map(saveOrUpdateVO, EngineeringReportEntity.class);
    /*    if (saveOrUpdateVO.getIsAssist()) {
            entity.setIsAssist(1);
        } else {
            entity.setIsAssist(0);
        }*/
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        service.saveOrUpdate(entity, false);
        EngineeringReportVO vo = BeanMapper.map(entity, EngineeringReportVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngineeringReportVO> queryDetail(Long id) {
        EngineeringReportEntity entity = service.selectById(id);

        EngineeringReportVO vo = BeanMapper.map(entity, EngineeringReportVO.class);
        if (entity.getIsAssist() == 1) {
            vo.setIsAssist(true);
        } else {
            vo.setIsAssist(false);
        }
        List<EngineeringReportRecordEntity> recordList = recordService.list(new QueryWrapper<EngineeringReportRecordEntity>().eq("report_id", entity.getId()));
        vo.setRecordList(BeanMapper.mapList(recordList, EngineeringReportRecordVO.class));
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EngineeringReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (EngineeringReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(EngineeringReportVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EngineeringReportVO>> queryList(@RequestBody QueryParam param) {





        /** 模糊搜索配置字段示例 */
        extracted(param);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<EngineeringReportEntity> page = service.queryPage(param, false);
        IPage<EngineeringReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngineeringReportVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        /** 模糊搜索配置字段示例 */
        extracted(param);
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EngineeringReportEntity> list = service.queryList(param);
        List<EngineeringReportExportVO> engineeringReportExportList = BeanMapper.mapList(list, EngineeringReportExportVO.class);

        for (EngineeringReportExportVO engineeringReportExportVO : engineeringReportExportList) {
            if (engineeringReportExportVO.getIsAssist() == 1) {
                engineeringReportExportVO.setNeedAssistance("是");
            } else {
                engineeringReportExportVO.setNeedAssistance("否");
            }
            if (engineeringReportExportVO.getBillState() == 0) {
                engineeringReportExportVO.setState("自由态");
            }
            if (engineeringReportExportVO.getBillState() == 2 || engineeringReportExportVO.getBillState() == 5) {
                engineeringReportExportVO.setState("审批中");
            }
            if (engineeringReportExportVO.getBillState() == 1) {
                engineeringReportExportVO.setState("已提交");
            }
            if (engineeringReportExportVO.getBillState() == 3) {
                engineeringReportExportVO.setState("审批通过");
            }
            if (engineeringReportExportVO.getBillState() == 4) {
                engineeringReportExportVO.setState("审批驳回");
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", engineeringReportExportList);
        ExcelExport.getInstance().export("EngineeringReport-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refEngineeringReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EngineeringReportVO>> refEngineeringReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EngineeringReportEntity> page = service.queryPage(param, false);
        IPage<EngineeringReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngineeringReportVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 修订时查询最新的数据
     *
     * @param id
     * @return
     */
    @GetMapping("/selectLatest")
    @ResponseBody
    public CommonResponse selectMoney(String id) {
        LambdaQueryWrapper<BusinessEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BusinessEntity::getId, id);
        BusinessEntity businessEntity = businessMapper.selectOne(wrapper);
        return CommonResponse.success("成功", businessEntity);
    }

    private static void extracted(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        //模糊搜索：单据编号、工程名称、区域名称、客户名称、业主单位、设计单位、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customName");
        fuzzyFields.add("ownerCompany");
        fuzzyFields.add("designCompany");
        fuzzyFields.add("employeeName");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListReoprt", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<EngineeringReportReportVO>> queryListReoprt(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        //模糊搜索：单据编号、工程名称、区域名称、客户名称、业主单位、设计单位、经办人
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customName");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<EngineeringReportReportVO> resList = new ArrayList<>();
        List<EngineeringReportReportVO> firstList = new ArrayList<>();

        //取项目状态
        QueryParam param2 = new QueryParam();
        param2.setPageIndex(1);
        param2.setPageSize(-1);
        param2.getParams().put("orgId", new Parameter(QueryParam.EQ, 1111));
        CommonResponse<Page<ProjectArchiveVO>> projectResponse = projectArchiveApi.queryProjectArchivePage(param2);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("网络异常， 获取项目失败， 请稍后再试");
        }
        List<ProjectArchiveVO> records = projectResponse.getData().getRecords();
        Map<Long,ProjectArchiveVO> projectMap = records.stream().collect(Collectors.toMap(ProjectArchiveVO::getSourceBillId, x -> x));

        //第一步 取工程部下 的直接下级做为 报表父级
        Long gcOrgId = 2405220178L;
        List<OrgVO> orgVOList = iOrgApi.findChildrenByParentId(gcOrgId).getData();
        Map<Long,List<Long>> map = new HashMap<>();
        Set<Long> set = new HashSet<>();
        for(OrgVO orgVO:orgVOList){
            if(null!=orgVO.getParentId()&&gcOrgId.equals(orgVO.getParentId())&&1==orgVO.getState()){
                EngineeringReportReportVO vo = new EngineeringReportReportVO();
                vo.setId(orgVO.getId());
                vo.setOrgId(orgVO.getId());
                vo.setOrgName(orgVO.getName());
                firstList.add(vo);
                List<Long> orgList = new ArrayList<>();
                orgList.add(orgVO.getId());
                map.put(orgVO.getId(),orgList);
                set.add(orgVO.getId());
            }
        }
        for(OrgVO orgVO:orgVOList){
            if(null!=orgVO.getParentId()&&gcOrgId.equals(orgVO.getParentId())){
            }else{
                for (Long orgId : set) {
                    if(orgVO.getInnerCode().contains(orgId.toString())&&1==orgVO.getState()){
                        map.get(orgId).add(orgVO.getId());
                    }
                }
            }
        }
        //第二步 取自定义档案 -项目类型  做为 报表子级
        List<DefdocDetailVO> defdocList = defdocApi.getDefDocByDefCode("bid-project-type").getData();
        firstList.forEach(e->{

            //第三步 根据组织  查询数据
            List<EngineeringReportReportVO> reportVOList =  service.queryListByOrg(wrapper,map.get(e.getId()));
            BigDecimal firstContractMny = BigDecimal.ZERO; // 一级的报价金额
            for(DefdocDetailVO detailVO:defdocList){
                EngineeringReportReportVO vo = new EngineeringReportReportVO();
                vo.setId(e.getId()+detailVO.getId());
                vo.setParentId(e.getId());
                vo.setProjectTypeId(detailVO.getId());
                vo.setProjectTypeName(detailVO.getName());
                if(CollectionUtils.isNotEmpty(reportVOList)){
                    BigDecimal estimatedContractMny = BigDecimal.ZERO; // 报价金额
                    for(EngineeringReportReportVO reportVO:reportVOList){
                        if(null!=reportVO.getProjectTypeId()&&detailVO.getId().equals(reportVO.getProjectTypeId())){
                            reportVO.setParentId(e.getId()+detailVO.getId());
                            if(projectMap.containsKey(reportVO.getEngineeringId())){
                                reportVO.setProjectStatusName(ArchiveProjectStatusEnum.getByCode(projectMap.get(reportVO.getEngineeringId()).getProjectStatus()).getName());
                            }
                            estimatedContractMny = ComputeUtil.safeAdd(estimatedContractMny,reportVO.getEstimatedContractMny());
                            resList.add(reportVO);//三级
                        }
                    }
                    vo.setEstimatedContractMny(estimatedContractMny);
                }
                firstContractMny = ComputeUtil.safeAdd(firstContractMny,vo.getEstimatedContractMny());
                resList.add(vo);//二级
            }
            e.setEstimatedContractMny(firstContractMny);
            resList.add(e);//一级
        });
        Collections.reverse(resList);//倒序
        return CommonResponse.success("查询列表数据成功！",TreeNodeBUtil.buildTree(resList));
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<String> fuzzyFields = param.getFuzzyFields();
        //模糊搜索：单据编号、工程名称、区域名称、客户名称、业主单位、设计单位、经办人
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customName");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<EngineeringReportReportVO> resList = new ArrayList<>();
        List<EngineeringReportReportVO> firstList = new ArrayList<>();

        //取项目状态
        QueryParam param2 = new QueryParam();
        param2.setPageIndex(1);
        param2.setPageSize(-1);
        param2.getParams().put("orgId", new Parameter(QueryParam.EQ, 1111));
        CommonResponse<Page<ProjectArchiveVO>> projectResponse = projectArchiveApi.queryProjectArchivePage(param2);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("网络异常， 获取项目失败， 请稍后再试");
        }
        List<ProjectArchiveVO> records = projectResponse.getData().getRecords();
        Map<Long,ProjectArchiveVO> projectMap = records.stream().collect(Collectors.toMap(ProjectArchiveVO::getSourceBillId, x -> x));
        //第一步 取工程部下 的直接下级做为 报表父级
        Long gcOrgId = 2405220178L;
        List<OrgVO> orgVOList = iOrgApi.findChildrenByParentId(gcOrgId).getData();
        Map<Long,List<Long>> map = new HashMap<>();
        Set<Long> set = new HashSet<>();
        for(OrgVO orgVO:orgVOList){
            if(null!=orgVO.getParentId()&&gcOrgId.equals(orgVO.getParentId())){
                EngineeringReportReportVO vo = new EngineeringReportReportVO();
                vo.setId(orgVO.getId());
                vo.setOrgId(orgVO.getId());
                vo.setOrgName(orgVO.getName());
                firstList.add(vo);
                List<Long> orgList = new ArrayList<>();
                orgList.add(orgVO.getId());
                map.put(orgVO.getId(),orgList);
                set.add(orgVO.getId());
            }
        }
        for(OrgVO orgVO:orgVOList){
            if(null!=orgVO.getParentId()&&gcOrgId.equals(orgVO.getParentId())){
            }else{
                for (Long orgId : set) {
                    if(orgVO.getInnerCode().contains(orgId.toString())){
                        map.get(orgId).add(orgVO.getId());
                    }
                }
            }
        }
        //第二步 取自定义档案 -项目类型  做为 报表子级
        List<DefdocDetailVO> defdocList = defdocApi.getDefDocByDefCode("bid-project-type").getData();
        firstList.forEach(e->{
            //第三步 根据组织  查询数据
            List<EngineeringReportReportVO> reportVOList =  service.queryListByOrg(wrapper,map.get(e.getId()));
            BigDecimal firstContractMny = BigDecimal.ZERO; // 一级的报价金额
            for(DefdocDetailVO detailVO:defdocList){
                EngineeringReportReportVO vo = new EngineeringReportReportVO();
                vo.setId(e.getId()+detailVO.getId());
                vo.setParentId(e.getId());
                vo.setProjectTypeId(detailVO.getId());
                vo.setProjectTypeName(detailVO.getName());
                if(CollectionUtils.isNotEmpty(reportVOList)){
                    BigDecimal estimatedContractMny = BigDecimal.ZERO; // 报价金额
                    for(EngineeringReportReportVO reportVO:reportVOList){
                        if(null!=reportVO.getProjectTypeId()&&detailVO.getId().equals(reportVO.getProjectTypeId())){
                            reportVO.setParentId(e.getId()+detailVO.getId());
                            if(projectMap.containsKey(reportVO.getEngineeringId())){
                                reportVO.setProjectStatusName(ArchiveProjectStatusEnum.getByCode(projectMap.get(reportVO.getEngineeringId()).getProjectStatus()).getName());
                            }
                            estimatedContractMny = ComputeUtil.safeAdd(estimatedContractMny,reportVO.getEstimatedContractMny());
                            resList.add(reportVO);//三级
                        }
                    }
                    vo.setEstimatedContractMny(estimatedContractMny);
                }
                firstContractMny = ComputeUtil.safeAdd(firstContractMny,vo.getEstimatedContractMny());
                resList.add(vo);//二级
            }
            e.setEstimatedContractMny(firstContractMny);
            resList.add(e);//一级
        });
        Collections.reverse(resList);//倒序
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("EngineeringReportReport-export.xlsx", beans, response);
    }



    @RequestMapping(value = "/reportQueryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> reportQueryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        /** 租户隔离 */
        Page<EngineeringReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<EngineeringReportVO> list = new ArrayList<>();
        String startOfMonth = "";
        String endOfMonth = "";

       if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("createTime", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }

        QueryWrapper wrapper = changeToQueryWrapper(param);
        list = service.reportQueryList(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }
    /**
     * @param param
     * @Description 报表导出
     * @Return void
     */
    @RequestMapping(value = "/projectQuotationReport", method = RequestMethod.POST)
    @ResponseBody
    public void projectQuotationReport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        Page<EngineeringReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<EngineeringReportVO> list = new ArrayList<>();
        String startOfMonth = "";
        String endOfMonth = "";

        if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("createTime", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }

        QueryWrapper wrapper = changeToQueryWrapper(param);
        list = service.reportQueryList(page, wrapper);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("projectQuotationReport-export.xlsx", beans, response);
    }



}

