package com.ejianc.business.jlincome.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterDetailEntity;
import com.ejianc.business.jlincome.bid.service.IResultRegisterDetailService;
import com.ejianc.business.jlincome.bid.service.impl.ResultRegisterBpmServiceImpl;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.bid.service.IResultRegisterService;
import com.ejianc.business.jlincome.bid.vo.ResultRegisterVO;

/**
 * 投标管理-投标结果登记-主表
 *
 * @author generator
 */
@RestController
@RequestMapping("resultRegister")
public class ResultRegisterController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID_RESULT_REGISTER";//此处需要根据实际修改

    @Autowired
    private IResultRegisterService service;

    @Autowired
    private IResultRegisterDetailService detailService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ResultRegisterBpmServiceImpl resultRegister;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ResultRegisterVO> saveOrUpdate(@RequestBody ResultRegisterVO saveOrUpdateVO) {
        ResultRegisterEntity entity = BeanMapper.map(saveOrUpdateVO, ResultRegisterEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            //判断是否手动新增
            if (null == entity.getSourceType()) {
                entity.setSourceType(0);
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        Boolean sendFlag = false;
        //如果涉及安装及发信息
        if (null != entity.getBillState() && (1 == entity.getBillState() || 3 == entity.getBillState()) && entity.getRelateInstallFlag() && null != entity.getInstallLeaderId()) {
            ResultRegisterEntity oldEntity = service.selectById(entity.getId());
            if (oldEntity.getRelateInstallFlag()) {
                if (!oldEntity.getInstallLeaderId().toString().equals(entity.getInstallLeaderId().toString())) {
                    sendFlag = true;
                }
            } else {
                sendFlag = true;
            }
        }
        service.saveOrUpdate(entity, false);
        if (sendFlag) {
            service.sendMsgToInstallPerson(entity);
        }
        ResultRegisterVO vo = BeanMapper.map(entity, ResultRegisterVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ResultRegisterVO> queryDetail(Long id) {
        ResultRegisterEntity entity = service.selectById(id);
        ResultRegisterVO vo = BeanMapper.map(entity, ResultRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ResultRegisterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ResultRegisterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ResultRegisterVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResultRegisterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("bidWinUnitName");
        fuzzyFields.add("saleLeaderName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = null;
        if (param.getParams().containsKey("orgId")) {
            orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().remove("orgId");
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        } else {
            orgId = InvocationInfoProxy.getOrgId();
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ResultRegisterEntity> page = service.queryPage(param, false);
        IPage<ResultRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ResultRegisterVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResultRegisterVO>> queryReportList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("productTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));
        IPage<ResultRegisterEntity> page = service.queryPage(param, false);
        IPage<ResultRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        Map<Long, ResultRegisterVO> recordMap = BeanMapper.mapList(page.getRecords(), ResultRegisterVO.class).stream().collect(Collectors.toMap(ResultRegisterVO::getId, (item) -> {
            if (item.getBidWinFlag()) {
                item.setWinMny(item.getBidWinMny());
            }
            return item;
        }));

        List<ResultRegisterDetailEntity> list;
        if (recordMap.isEmpty()) {
            // 如果 recordMap 为空，则不加查询条件
            list = detailService.list();
        } else {
            // 如果 recordMap 不为空，构建带条件的查询
            list = detailService.list(new QueryWrapper<ResultRegisterDetailEntity>()
                    .in("bid_result_register_id", recordMap.keySet().toArray()));
        }

        for (ResultRegisterDetailEntity item : list) {
            ResultRegisterVO resultRegisterVO = recordMap.get(item.getBidResultRegisterId());
            if(Objects.isNull(resultRegisterVO)){
                continue;
            }else {
                if (item.getDetailBidWinFlag()) {
                    resultRegisterVO.setWinMny(item.getDetailBidEntryMny());
                }
                if (resultRegisterVO.getUnitName1() == null) {
                    resultRegisterVO.setUnitName1(item.getCompeteBidUnitName());
                    resultRegisterVO.setBidMny1(item.getDetailBidEntryMny());
                    continue;
                }
                if (resultRegisterVO.getUnitName2() == null) {
                    resultRegisterVO.setUnitName2(item.getCompeteBidUnitName());
                    resultRegisterVO.setBidMny2(item.getDetailBidEntryMny());
                    continue;
                }
                if (resultRegisterVO.getUnitName3() == null) {
                    resultRegisterVO.setUnitName3(item.getCompeteBidUnitName());
                    resultRegisterVO.setBidMny3(item.getDetailBidEntryMny());
                    continue;
                }
                if (resultRegisterVO.getUnitName4() == null) {
                    resultRegisterVO.setUnitName4(item.getCompeteBidUnitName());
                    resultRegisterVO.setBidMny4(item.getDetailBidEntryMny());
                }
            }
        }

        pageData.setRecords(new ArrayList<>(recordMap.values()));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("bidWinUnitName");
        fuzzyFields.add("saleLeaderName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<ResultRegisterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        List<ResultRegisterVO> voList = BeanMapper.mapList(list, ResultRegisterVO.class);
        voList.forEach(e -> {
            e.setBidWinFlagName(e.getBidWinFlag() ? "是" : "否");
            e.setRelateInstallFlagName(e.getRelateInstallFlag() ? "是" : "否");
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("ResultRegister-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));
        List<ResultRegisterEntity> resultRegisterEntities = service.queryList(param);
        Map<Long, ResultRegisterVO> recordMap = BeanMapper.mapList(resultRegisterEntities, ResultRegisterVO.class).stream().collect(Collectors.toMap(ResultRegisterVO::getId, (item) -> {
            if (item.getBidWinFlag()) {
                item.setWinMny(item.getBidWinMny());
            }
            item.setBidWinFlagName(item.getBidWinFlag() ? "是" : "否");

            return item;
        }));

        List<ResultRegisterDetailEntity> list = detailService.list(new QueryWrapper<ResultRegisterDetailEntity>().in("bid_result_register_id", recordMap.keySet().toArray()));
        for (ResultRegisterDetailEntity item : list) {
            ResultRegisterVO resultRegisterVO = recordMap.get(item.getBidResultRegisterId());
            if (item.getDetailBidWinFlag()) {
                resultRegisterVO.setWinMny(item.getDetailBidEntryMny());
            }
            if (resultRegisterVO.getUnitName1() == null) {
                resultRegisterVO.setUnitName1(item.getCompeteBidUnitName());
                resultRegisterVO.setBidMny1(item.getDetailBidEntryMny());
                continue;
            }
            System.out.println(123);
            if (resultRegisterVO.getUnitName2() == null) {
                resultRegisterVO.setUnitName2(item.getCompeteBidUnitName());
                resultRegisterVO.setBidMny2(item.getDetailBidEntryMny());
                continue;
            }
            if (resultRegisterVO.getUnitName3() == null) {
                resultRegisterVO.setUnitName3(item.getCompeteBidUnitName());
                resultRegisterVO.setBidMny3(item.getDetailBidEntryMny());
                continue;
            }
            if (resultRegisterVO.getUnitName4() == null) {
                resultRegisterVO.setUnitName4(item.getCompeteBidUnitName());
                resultRegisterVO.setBidMny4(item.getDetailBidEntryMny());
            }
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        beans.put("records", new ArrayList<>(recordMap.values()));
        ExcelExport.getInstance().export("ResultRegisterReport-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refResultRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ResultRegisterVO>> refResultRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ResultRegisterEntity> page = service.queryPage(param, false);
        IPage<ResultRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ResultRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param businessId
     * @Author
     * @Description 新增根据商机登记 新加的数据
     * @Return
     */
    @RequestMapping(value = "/addResultRegisterByBusinessId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ResultRegisterVO> addResultRegisterByBusinessId(@RequestParam Long businessId) {
        ResultRegisterVO vo = service.addResultRegisterByBusinessId(businessId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }


    /**
     * 查询近30天中标项目
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/queryThirtyDaysData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ResultRegisterVO>> queryThirtyDaysData() {
        QueryParam param = new QueryParam();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        Date endDate = new Date();
        Date startDate = DateUtil.subDays(endDate, 30);
        param.getParams().put("create_time", new Parameter(QueryParam.BETWEEN, sim.format(startDate) + "," + sim.format(DateUtil.addDays(endDate, 1))));
        param.getParams().put("org_id", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        param.getOrderMap().put("createTime", QueryParam.ASC);
        List<ResultRegisterEntity> dataList = service.queryList(param);

        List<ResultRegisterVO> registerVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(dataList) && dataList.size() > 0) {
            registerVOList = BeanMapper.mapList(dataList, ResultRegisterVO.class);
        }
        return CommonResponse.success("查询查询近30天中标项目数据成功！", registerVOList);
    }
}
