package com.ejianc.business.jlincome.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.bid.bean.*;
import com.ejianc.business.jlincome.bid.service.IEngineeringChangePersonService;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportChangeService;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import com.ejianc.business.jlincome.income.bean.*;
import com.ejianc.business.jlincome.income.enums.ChangeStatusEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

@Service("engineeringReportChange")
public class EngineeringReportChangeBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEngineeringReportService engineeringReportService;
    @Autowired
    private IEngineeringReportChangeService engineeringReportChangeService;
    @Autowired
    private EngineeringReportRecordServiceImpl engineeringReportRecordService;
    @Autowired
    private EngineeringChangeResearchServiceImpl engineeringChangeResearchService;
    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {


        EngineeringReportChangeEntity entity = engineeringReportChangeService.selectById(billId);

        //3.发消息
        //单据提交之后给“部门负责人”推送系统消息，OA消息（钉钉消息）消息内容：2、你有一个合同包含施工，请尽快处理！点击查看详情
        if (null != entity.getInstallLeaderId() && BillStateEnum.PASSED_STATE.getBillStateCode()==entity.getBillState()){
            engineeringReportChangeService.sendMsgToInstallPerson(entity);
        }






        logger.info("进入审批同意后回写--- billId:" + billId + "  state:" + state);
        EngineeringReportChangeEntity changeEntity = engineeringReportChangeService.selectById(billId);
        changeEntity.setEffectDate(new Date());

        EngineeringReportEntity reportEntity = engineeringReportService.selectById(changeEntity.getReportId());

        //2，先复制询价表到询价历史表
        EngineeringReportRecordEntity recordEntity = BeanMapper.map(reportEntity, EngineeringReportRecordEntity.class);
        logger.info("进入审批同意后回写--- changeEntity:" + changeEntity + "  contractEntity:" + reportEntity);
        recordEntity.setReportId(recordEntity.getId());
        recordEntity.setId(null);
        recordEntity.setChangeEmployeeId(changeEntity.getChangeEmployeeId());
        recordEntity.setChangeEmployeeName(changeEntity.getChangeEmployeeName());
        recordEntity.setChangeMemo(changeEntity.getChangeMemo());
        if (CollectionUtils.isNotEmpty(recordEntity.getEngineeringPersonList())) {
            recordEntity.getEngineeringPersonList().forEach(vo -> {
                vo.setSourceId(reportEntity.getId());
                vo.setSourcePersonId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getEngineeringResearchList())) {
            recordEntity.getEngineeringResearchList().forEach(vo -> {
                vo.setSourceId(reportEntity.getId());
                vo.setSourceResearchId(vo.getId());
                vo.setId(null);
            });
        }

        engineeringReportRecordService.saveOrUpdate(recordEntity, false);
        logger.info("进入审批同意后回写--2");

        //3，回写合同，变更状态改为已变更，并回写字段
        reportEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        reportEntity.setBillCode(changeEntity.getBillCode());
        reportEntity.setCustomName(changeEntity.getCustomName());

        reportEntity.setProjectTypeId(changeEntity.getProjectTypeId());
        reportEntity.setProjectTypeName(changeEntity.getProjectTypeName());
        reportEntity.setProductType(changeEntity.getProductType());
        reportEntity.setProductTypeName(changeEntity.getProductTypeName());

        reportEntity.setOwnerCompany(changeEntity.getOwnerCompany());
        reportEntity.setDesignCompany(changeEntity.getDesignCompany());
        reportEntity.setIsAssist(changeEntity.getIsAssist());
        reportEntity.setExpectedDate(changeEntity.getExpectedDate());
        reportEntity.setEffectDate(changeEntity.getEffectDate());

        reportEntity.setEstimatedContractMny(changeEntity.getEstimatedContractMny());

        reportEntity.setSaleLeaderId(changeEntity.getSaleLeaderId());
        reportEntity.setSaleLeaderName(changeEntity.getSaleLeaderName());
        reportEntity.setSaleLeaderPhone(changeEntity.getSaleLeaderPhone());

        reportEntity.setEmployeeId(changeEntity.getEmployeeId());
        reportEntity.setEmployeeName(changeEntity.getEmployeeName());
        reportEntity.setDeptId(changeEntity.getDeptId());
        reportEntity.setDeptName(changeEntity.getDeptName());
        reportEntity.setIsRepeat(changeEntity.getIsRepeat());
        reportEntity.setMemo(changeEntity.getMemo());
        reportEntity.setInstallLeaderId(changeEntity.getInstallLeaderId());
        reportEntity.setInstallLeaderName(changeEntity.getInstallLeaderName());
        reportEntity.setQuote(changeEntity.getQuote()); //是否施工报价

        QueryWrapper<EngineeringChangeResearchEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("report_id", changeEntity.getReportId());
        engineeringChangeResearchService.remove(deleteWrapper);
        if (CollectionUtils.isNotEmpty(changeEntity.getEngineeringPersonList())) {
            logger.info("复制子表开始--" + changeEntity.getEngineeringPersonList());
            changeEntity.getEngineeringPersonList().forEach(vo -> {
                Map<Long, Integer> map = reportEntity.getEngineeringPersonList().stream().collect(Collectors.toMap(EngineeringPersonEntity::getId, EngineeringPersonEntity::getVersion));
                vo.setId(vo.getSourcePersonId());
                vo.setVersion(map.get(vo.getSourcePersonId()));
            });
            reportEntity.setEngineeringPersonList(BeanMapper.mapList(changeEntity.getEngineeringPersonList(), EngineeringPersonEntity.class));
        }

        if (CollectionUtils.isNotEmpty(changeEntity.getEngineeringResearchList())) {
            changeEntity.getEngineeringResearchList().forEach(vo -> {
                logger.info("复制子表--" + vo.getSourceResearchId());
                if (null != vo.getSourceResearchId()) {
                    Map<Long, Integer> map = reportEntity.getEngineeringResearchList().stream().collect(Collectors.toMap(EngineeringResearchEntity::getId, EngineeringResearchEntity::getVersion));
                    vo.setId(vo.getSourceResearchId());
                    vo.setVersion(map.get(vo.getSourceResearchId()));
                }
            });
            reportEntity.setEngineeringResearchList(BeanMapper.mapList(changeEntity.getEngineeringResearchList(), EngineeringResearchEntity.class));
        }
        boolean flag = engineeringReportService.saveOrUpdate(reportEntity, false);
        engineeringReportChangeService.saveOrUpdate(changeEntity);
        logger.info("业务逻辑完成--返回" + flag);
        if (flag) {
            //变更合同附件复制到主合同
            //todo 复制附件
            attachmentApi.copyFiles(String.valueOf(billId), "EJCBT202409000001", "file01", String.valueOf(recordEntity.getId()), "EJCBT202404000021", "file01", true);

            attachmentApi.copyFiles(String.valueOf(billId), "EJCBT202409000001", "file1", String.valueOf(recordEntity.getId()), "EJCBT202404000021", "file1", true);
            return CommonResponse.success();
        } else {
            return CommonResponse.error("审批回写异常!");
        }
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return bpmBackCheck(billId, state, billTypeCode);
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("该单据不可撤回！");
    }

}
