package com.ejianc.business.jlincome.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlincome.bid.bean.EngineeringChangePersonEntity;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.service.IEngineeringChangePersonService;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import com.ejianc.business.jlincome.bid.vo.*;
import com.ejianc.business.jlincome.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.enums.ChangeStatusEnum;
import com.ejianc.business.jlincome.income.enums.ChangeTypeEnum;
import com.ejianc.business.jlincome.income.vo.ContractRegisterChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.bid.mapper.EngineeringReportChangeMapper;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportChangeEntity;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportChangeService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 投标管理-工程调研报告-变更
 *
 * @author generator
 */
@Service("engineeringReportChangeService")
public class EngineeringReportChangeServiceImpl extends BaseServiceImpl<EngineeringReportChangeMapper, EngineeringReportChangeEntity> implements IEngineeringReportChangeService {
    @Autowired
    private IEngineeringReportService engineeringReportService;
    @Autowired
    private IEngineeringChangePersonService engineeringChangePersonService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPushMessageApi pushMessageApi;

    private static final String PC_URL = "/ejc-jlincome-frontend/#/engineeringReport/card?id=";
    private static final String MOBILE_URL = "/ejc-jlincome-mobile/#/engineeringReport/card?id=";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public EngineeringReportChangeVO addConvertByReportId(Long reportId) {
        EngineeringReportEntity entity = engineeringReportService.selectById(reportId);
        EngineeringReportChangeVO changeVo = BeanMapper.map(entity, EngineeringReportChangeVO.class);
        //新增逻辑处理
        changeVo.setReportId(reportId);
        //新增即点变更按钮穿透过来，此时ID为合同id
        changeVo.setId(IdWorker.getId());
        changeVo.setBillState(0);
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);
        changeVo.setChangeDate(new Date());

        List<EngineeringChangePersonVO> personVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(changeVo.getEngineeringPersonList())) {
            for (EngineeringChangePersonVO personVO : changeVo.getEngineeringPersonList()) {
                if (null != personVO.getChangeType() && ChangeTypeEnum.终止项.getCode().toString().equals(personVO.getChangeType())) {
                    continue;
                }
                personVO.setChangeType(ChangeTypeEnum.未变更.getCode().toString());
                personVO.setSourcePersonId(personVO.getId());
                personVO.setSourceId(reportId);
                personVO.setRowState("edit");
                personVOList.add(personVO);
            }
            changeVo.setEngineeringPersonList(personVOList);

        }

        if (CollectionUtils.isNotEmpty(changeVo.getEngineeringResearchList())) {
            for (EngineeringChangeResearchVO researchVO : changeVo.getEngineeringResearchList()) {
                researchVO.setSourceResearchId(researchVO.getId());
                researchVO.setSourceId(reportId);
                researchVO.setRowState("add");
            }
        }

        //复制附件
        //附件
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(reportId), "EJCBT202404000021", "file01", String.valueOf(changeVo.getId()), "EJCBT202409000001", "file01");
        //管理
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(reportId), "EJCBT202404000021", "file1", String.valueOf(changeVo.getId()), "EJCBT202409000001", "file1");

        return changeVo;
    }

    @Override
    public EngineeringReportChangeVO queryChangeRecordByContId(Long id) {
        EngineeringReportChangeVO changeVO = new EngineeringReportChangeVO();
        EngineeringReportEntity entity = engineeringReportService.selectById(id);

        changeVO.setId(id);
        changeVO.setChangeStatus(entity.getChangeStatus());
        if (null != entity.getChangeVersion() && entity.getChangeVersion() > 0) {
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<EngineeringReportChangeEntity> lambda = Wrappers.<EngineeringReportChangeEntity>lambdaQuery();
            lambda.eq(EngineeringReportChangeEntity::getReportId, id);
            lambda.in(EngineeringReportChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
            lambda.orderByDesc(EngineeringReportChangeEntity::getChangeVersion);
            List<EngineeringReportChangeEntity> entities = super.list(lambda);
            changeVO.setChangeRecord(BeanMapper.mapList(entities, ContractRegisterChangeVO.class));
        }
        return changeVO;
    }

    /**
     * 保存或修改信息
     *
     * @param reportChangeVO
     * @return
     */
    @Override
    public CommonResponse<EngineeringReportChangeVO> saveOrUpdate(EngineeringReportChangeVO reportChangeVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        EngineeringReportChangeEntity entity = null;
        List<EngineeringReportEntity> entitiesc = null;
        List<EngineeringReportChangeEntity> entities = null;
        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<EngineeringReportChangeEntity> lambdachange = Wrappers.<EngineeringReportChangeEntity>lambdaQuery();
        lambdachange.eq(EngineeringReportChangeEntity::getReportId, reportChangeVO.getReportId());
        if (reportChangeVO.getId() != null && reportChangeVO.getId() > 0) {
            lambdachange.ne(EngineeringReportChangeEntity::getId, reportChangeVO.getId());
        }
        lambdachange.ne(EngineeringReportChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(EngineeringReportChangeEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if (num > 0) {
            throw new BusinessException("该出图询价已存在未生效的变更单!");
        }
        EngineeringReportEntity parentEntity = engineeringReportService.selectById(reportChangeVO.getReportId());
        if (reportChangeVO.getId() != null && reportChangeVO.getId() > 0 && super.getById(reportChangeVO.getId()) != null) {
            //修改 校验合同编号唯一，变更单除去本单，合同  同时唯一
            LambdaQueryWrapper<EngineeringReportChangeEntity> lambda = Wrappers.<EngineeringReportChangeEntity>lambdaQuery();
            lambda.eq(EngineeringReportChangeEntity::getBillCode, reportChangeVO.getBillCode());
            lambda.ne(EngineeringReportChangeEntity::getReportId, reportChangeVO.getReportId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, reportChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, reportChangeVO.getReportId()));
            entitiesc = engineeringReportService.queryList(queryParam, false);
            parentEntity.setId(reportChangeVO.getReportId());
            entity = BeanMapper.map(reportChangeVO, EngineeringReportChangeEntity.class);
            entity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
            super.saveOrUpdate(entity, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<EngineeringReportChangeEntity> lambda = Wrappers.<EngineeringReportChangeEntity>lambdaQuery();
            lambda.eq(EngineeringReportChangeEntity::getBillCode, reportChangeVO.getBillCode());
            lambda.ne(EngineeringReportChangeEntity::getReportId, reportChangeVO.getReportId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, reportChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, reportChangeVO.getReportId()));
            entitiesc = engineeringReportService.queryList(queryParam, false);
            //新增即点变更按钮穿透过来，此时ID为合同id
            parentEntity.setId(reportChangeVO.getReportId());
            parentEntity.setChangeVersion(reportChangeVO.getChangeVersion() + 1);
            reportChangeVO.setChangeVersion(reportChangeVO.getChangeVersion() + 1);
            if (CollectionUtils.isNotEmpty(entities) || CollectionUtils.isNotEmpty(entitiesc)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        if (CollectionUtils.isNotEmpty(reportChangeVO.getEngineeringPersonList())) {
            reportChangeVO.getEngineeringPersonList().forEach(vo -> {
                //变更类型1-增补，2-变更，3-中止
                if (this.isInsertReportChange(reportChangeVO)) {
                    vo.setId(null);
                }
                if ("del".equals(vo.getRowState()) && null != vo.getReportId()) {
                    vo.setChangeType(ChangeTypeEnum.终止项.getCode().toString());
                    vo.setRowState("edit");
                }
            });
        }
        if (CollectionUtils.isNotEmpty(reportChangeVO.getEngineeringResearchList())) {
            reportChangeVO.getEngineeringResearchList().forEach(vo -> {
                //变更类型1-增补，2-变更，3-中止
                if (this.isInsertReportChange(reportChangeVO)) {
                    vo.setId(null);
                }
                if ("del".equals(vo.getRowState()) && null != vo.getReportId()) {
                    vo.setChangeType(ChangeTypeEnum.终止项.getCode().toString());
                    vo.setRowState("edit");
                }
            });
        }
        entity = BeanMapper.map(reportChangeVO, EngineeringReportChangeEntity.class);
        entity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
    /*    if (reportChangeVO.getIsAssist()) {
            entity.setIsAssist(1);
        } else {
            entity.setIsAssist(0);
        }*/
        super.saveOrUpdate(entity, false);

        //回写合同表
        parentEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
        parentEntity.setChangeDate(entity.getChangeDate());
        parentEntity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
        parentEntity.setChangeId(entity.getId());

        engineeringReportService.update(parentEntity, new QueryWrapper<EngineeringReportEntity>().eq("id", parentEntity.getId()), false);
        EngineeringReportChangeVO res = BeanMapper.map(this.queryDetail(entity.getId()), EngineeringReportChangeVO.class);
        return CommonResponse.success(res);
    }

    @Override
    public void deleteContractChange(List<EngineeringReportChangeVO> vos) {
        EngineeringReportChangeVO changeVo = vos.get(0);
        EngineeringReportChangeEntity entity = super.selectById(changeVo.getId());
        //合同变更只有详情页有删除
        EngineeringReportEntity parentEntity = engineeringReportService.selectById(entity.getReportId());
        //回写合同表
        parentEntity.setId(entity.getReportId());
        parentEntity.setChangeVersion(parentEntity.getChangeVersion() - 1);

        parentEntity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        if (super.list(new QueryWrapper<EngineeringReportChangeEntity>().eq("report_id", entity.getReportId())).size() > 1) {
            parentEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        }
        parentEntity.setChangeCode(null);
        parentEntity.setChangeId(null);
        engineeringReportService.update(parentEntity, new QueryWrapper<EngineeringReportEntity>().eq("id", parentEntity.getId()), false);
        super.removeByIds(vos.stream().map(EngineeringReportChangeVO::getId).collect(Collectors.toList()), false);
    }

    /**
     * 是否合同变更新增
     *
     * @param reportChangeVO 合同变更数据
     * @return 是否新增
     */
    private boolean isInsertReportChange(EngineeringReportChangeVO reportChangeVO) {
        return reportChangeVO.getId() == null || reportChangeVO.getId() == 0;
    }

    @Override
    public EngineeringReportChangeVO queryDetail(Long id) {
        EngineeringReportChangeEntity entity = super.selectById(id);
        entity.setEngineeringPersonList(null);
        EngineeringReportChangeVO contractVo = BeanMapper.map(entity, EngineeringReportChangeVO.class);
        List<EngineeringChangePersonEntity> details = null;
        LambdaQueryWrapper<EngineeringChangePersonEntity> lambda = Wrappers.<EngineeringChangePersonEntity>lambdaQuery();
        lambda.eq(EngineeringChangePersonEntity::getReportId, id);
        lambda.ne(EngineeringChangePersonEntity::getChangeType, ChangeTypeEnum.终止项.getCode());
        details = engineeringChangePersonService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            contractVo.setEngineeringPersonList(BeanMapper.mapList(details, EngineeringChangePersonVO.class));
        }
        return contractVo;
    }

    @Override
    public void sendMsgToInstallPerson(EngineeringReportChangeEntity entity) {
        logger.info("安装负责人”推送系统消息，OA消息（钉钉消息）");
        //消息内容：XXX项目有一项重要的合同交底需要查看！！！支持链接打开查看详情
        String msg = this.sendMsg(entity, "安装负责人”推送系统消息，OA消息（钉钉消息）", "你有一个施工报价，请尽快处理！点击查看详情！！！");
        if (StringUtils.isNotBlank(msg)) {
            logger.error("安装负责人”推送系统消息，OA消息（钉钉消息） 异常：" + msg);
        }
        logger.info("安装负责人”推送系统消息，OA消息（钉钉消息）结束！");

    }

    private String sendMsg(EngineeringReportChangeEntity entity, String subject, String content) {

        String[] msgRecUserIds = new String[]{entity.getInstallLeaderId().toString()};

        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(content);
        //消息类型
        msgParameter.setMsgType("bpmpass");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_ZHIYUANOA});
        msgParameter.setPcUrl(PC_URL + entity.getReportId());
        msgParameter.setMobileUrl(MOBILE_URL + entity.getReportId());
        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        return msgSendResp.isSuccess() ? null : msgSendResp.getMsg();

    }
}
