package com.ejianc.business.jlincome.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import com.ejianc.business.jlincome.bid.vo.ResultRegisterVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.bid.mapper.ResultRegisterMapper;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.bid.service.IResultRegisterService;


/**
 * 投标管理-投标结果登记-主表
 * 
 * @author generator
 * 
 */
@Service("resultRegisterService")
public class ResultRegisterServiceImpl extends BaseServiceImpl<ResultRegisterMapper, ResultRegisterEntity> implements IResultRegisterService{
    @Autowired
    private IBusinessService businessService;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    public ResultRegisterVO addResultRegisterByBusinessId(Long businessId) {
        //校验是否重复引用商机登记
        LambdaQueryWrapper<ResultRegisterEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ResultRegisterEntity::getSourceId, businessId);
        if (super.list(lambda).size() > 0){
            throw new BusinessException("该工程已经被引用，不可重复引用！");
        }

        BusinessEntity businessEntity = businessService.selectById(businessId);
        ResultRegisterVO resultRegisterVO = new ResultRegisterVO();
                
        resultRegisterVO.setOrgId(businessEntity.getOrgId());
        resultRegisterVO.setOrgName(businessEntity.getOrgName());
        resultRegisterVO.setOrgCode(businessEntity.getOrgCode());
        resultRegisterVO.setProjectName(businessEntity.getProjectName());

        resultRegisterVO.setCustomName(businessEntity.getCustomName());

        resultRegisterVO.setProjectTypeId(businessEntity.getProjectTypeId());
        resultRegisterVO.setProjectTypeName(businessEntity.getProjectTypeName());
        resultRegisterVO.setProductType(businessEntity.getProductType());
        resultRegisterVO.setProductTypeName(businessEntity.getProductTypeName());

        resultRegisterVO.setProductName(businessEntity.getProductName());

        resultRegisterVO.setSpec(businessEntity.getSpec());
        resultRegisterVO.setNum(businessEntity.getNum());

        resultRegisterVO.setSaleLeaderId(businessEntity.getSaleLeaderId());
        resultRegisterVO.setSaleLeaderName(businessEntity.getSaleLeaderName());
        resultRegisterVO.setSaleLeaderPhone(businessEntity.getSaleLeaderPhone());

        resultRegisterVO.setBidFileReceiveDate(businessEntity.getBidFilePlanReceiveDate());
        resultRegisterVO.setBidOpenDate(businessEntity.getPlanBidOpenDate());


        resultRegisterVO.setCustomLinkName(businessEntity.getCustomLinkName());
        resultRegisterVO.setCustomLinkPhone(businessEntity.getCustomLinkPhone());

        resultRegisterVO.setPlanDeliverDate(businessEntity.getPlanDeliverDate());
        resultRegisterVO.setProjectSituation(businessEntity.getProjectSituation());
        resultRegisterVO.setAddress(businessEntity.getDetailedAddress());

        resultRegisterVO.setSourceId(businessEntity.getId());
        resultRegisterVO.setSourceCode(businessEntity.getBillCode());
        resultRegisterVO.setSourceType(1);

        return resultRegisterVO;
    }

    @Override
    public CommonResponse<String> pushResultRegisterProjectArchive(ResultRegisterEntity entity) {
        ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();

        projectArchiveVO.setProjectStatus(entity.getBidWinFlag() ? ArchiveProjectStatusEnum.已中标.getCode() : ArchiveProjectStatusEnum.未中标.getCode());
        projectArchiveVO.setSourceUpdateId(1 == entity.getSourceType() ? entity.getId().toString() : null);
        if (0 == entity.getSourceType()){
            projectArchiveVO.setSourceType("bid");
            projectArchiveVO.setSourceBillId(entity.getId());
            projectArchiveVO.setSourceBillCode(entity.getBillCode());
        }else if (1 == entity.getSourceType()){
            projectArchiveVO.setSourceBillId(entity.getSourceId());
        }

        projectArchiveVO.setName(entity.getProjectName());
        projectArchiveVO.setOrgId(entity.getOrgId());
        projectArchiveVO.setOrgCode(entity.getOrgCode());
        projectArchiveVO.setOrgName(entity.getOrgName());
        projectArchiveVO.setProjectTypeId(entity.getProjectTypeId());
        projectArchiveVO.setProjectTypeName(entity.getProjectTypeName());
        projectArchiveVO.setProductType(entity.getProductType());
        projectArchiveVO.setProductTypeName(entity.getProductTypeName());
        projectArchiveVO.setProjectDate(entity.getProjectApprovalDate());

        projectArchiveVO.setBusinessCustomName(entity.getCustomName());
        projectArchiveVO.setCustomLinkName(entity.getCustomLinkName());
        projectArchiveVO.setCustomLinkPhone(entity.getCustomLinkPhone());
        projectArchiveVO.setDesignUnit(entity.getDesignUnit());
        projectArchiveVO.setConstructUnit(entity.getContractingUnit());
        projectArchiveVO.setArea(entity.getArea());
        projectArchiveVO.setAreaName(entity.getAreaName());
        projectArchiveVO.setAddress(entity.getAddress());
        projectArchiveVO.setNationalId(entity.getNationalId());
        projectArchiveVO.setNationalName(entity.getNationalName());
        projectArchiveVO.setProjectHeight(entity.getProjectHeight());
        projectArchiveVO.setProjectSpan(entity.getProjectSpan());
        projectArchiveVO.setBidOpenDate(entity.getBidOpenDate());
        projectArchiveVO.setBidDate(entity.getBidDate());
        projectArchiveVO.setPlanProductDate(entity.getPlanProductDate());
        projectArchiveVO.setPlanDeliverDate(entity.getPlanDeliverDate());
        projectArchiveVO.setProductName(entity.getProductName());
        projectArchiveVO.setSpec(entity.getSpec());
        projectArchiveVO.setNum(entity.getNum());
        projectArchiveVO.setSaleLeaderId(entity.getSaleLeaderId());
        projectArchiveVO.setSaleLeaderName(entity.getSaleLeaderName());
        projectArchiveVO.setSaleLeaderPhone(entity.getSaleLeaderPhone());
        projectArchiveVO.setProjectSituation(entity.getProjectSituation());
        logger.info("招标结果登记-推送项目信息数据----" + JSONObject.toJSONString(projectArchiveVO));
        return projectArchiveApi.pushProjectArchive(projectArchiveVO);
    }

    @Override
    public String sendMsgToInstallPerson(ResultRegisterEntity entity) {
        logger.info("开始给安装人员发送消息：----");
        //客户名称：-工程名称：-+区域名称：已中标，需要现场安装，请注意
        String msg = this.sendMsg(entity, "中标信息", entity.getCustomName() + "：-" + entity.getProjectName() + "-" + entity.getOrgName() + "：已中标，需要现场安装，请注意！");
        if (StringUtils.isNotBlank(msg)){
            logger.error("给安装人员发送消息异常：" + msg);
        }
        logger.info("给安装人员发送消息结束！");
        return msg;
    }

    private String sendMsg(ResultRegisterEntity registerEntity, String subject, String content) {
        String[] msgRecUserIds = new String[]{registerEntity.getInstallLeaderId().toString()};

        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(content);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(registerEntity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}
