package com.ejianc.business.jlincome.income.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.income.vo.ProjectBoardTwoVO;
import com.ejianc.business.jlincome.income.vo.ProjectBoardVO;
import com.ejianc.business.jlincome.report.vo.ProjectMnyReportVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.List;

/**
 * 收入管理-合同登记
 *
 * @author generator
 */
@Mapper
public interface ContractRegisterMapper extends BaseCrudMapper<ContractRegisterEntity> {

    ProjectBoardVO queryContractBordData(@Param("orgIds") List<Long> orgIds, @Param("startDate") String startDate, @Param("endDate") String endDate);

    List<ProjectBoardTwoVO> queryProjectBordData(@Param("orgIds") List<Long> orgIds, @Param("projectIds") List<Long> projectIds);

    List<ContractRegisterEntity> selectExpireContractList();

    List<ProjectMnyReportVO> queryProjectMnyReportList(Page<ProjectMnyReportVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<ProjectMnyReportVO> queryProjectMnyReportList(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<ProjectMnyReportVO> queryProjectMnyReportSonList(@Param("ids") List<Long> ids);
}
