package com.ejianc.business.jlincome.performance.config;

import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

/**
 * @author baipengyan
 * @date 2022/6/10
 * @description 异步任务装饰器（带上下文）
 */

public class ThreadContextDecorator implements TaskDecorator {

	@Override
	public Runnable decorate(Runnable runnable) {
		RequestAttributes context = RequestContextHolder.currentRequestAttributes();
		return () -> {
			try {
				RequestContextHolder.setRequestAttributes(context, true);
				runnable.run();
			} finally {
				RequestContextHolder.resetRequestAttributes();
			}
		};
	}
}
