package com.ejianc.business.jlincome.performance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.performance.bean.ForecastDetailEntity;
import com.ejianc.business.jlincome.performance.bean.SaleReportEntity;
import com.ejianc.business.jlincome.performance.enums.ChangeStateEnum;
import com.ejianc.business.jlincome.performance.mapper.ForecastDetailMapper;
import com.ejianc.business.jlincome.performance.mapper.SaleReportMapper;
import com.ejianc.business.jlincome.performance.vo.*;
import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.index.qual.PolyUpperBound;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.performance.mapper.ForecastMapper;
import com.ejianc.business.jlincome.performance.bean.ForecastEntity;
import com.ejianc.business.jlincome.performance.service.IForecastService;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 绩效管理-销售预报-主表
 *
 * @author generator
 */
@Service("forecastService")
public class ForecastServiceImpl extends BaseServiceImpl<ForecastMapper, ForecastEntity> implements IForecastService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "FORECAST_CODE";//此处需要根据实际修改

    @Autowired
    private SaleReportMapper saleReportMapper;

    @Autowired
    private ForecastDetailMapper detailMapper;

    @Override
    public CommonResponse<ForecastVO> insertOrUpdate(ForecastVO saveOrUpdateVO) {
        ForecastEntity entity = BeanMapper.map(saveOrUpdateVO, ForecastEntity.class);
        if (entity.getIncomeForecastMny() == null) entity.setIncomeForecastMny(BigDecimal.ZERO);
        if (entity.getInvoiceForecastMny() == null) entity.setInvoiceForecastMny(BigDecimal.ZERO);
        if (entity.getSaleForecastMny() == null) entity.setSaleForecastMny(BigDecimal.ZERO);
        if (entity.getId() == null || entity.getId() == 0) {
            //第一版设置版本号、原始版本主键、第一版本创建时间
            if (null == entity.getLastForecastId()) {
                entity.setForecastVersion(1);

                entity.setOneTime(entity.getCreateTime());
                entity.setChangeState(ChangeStateEnum.未变更.getCode());
            }

            entity.setLatestFlag(true);//新增时默认最新版本
            entity.setEnableState(false);//新增时默认不生效

            if (null == entity.getBillCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
        //重置父id
        this.resetPid(entity.getForecastDetailList());
        super.saveOrUpdate(entity, false);

        //如果是变更单，则原单据保存变更信息
        if (entity.getLastForecastId() != null) {
            ForecastEntity revise = super.getById(entity.getLastForecastId());
            if (revise.getLatestFlag()) {

                revise.setChangeId(entity.getId());
                revise.setChangeState(ChangeStateEnum.变更中.getCode());
                //变更单保存后，原单据就不是最新版本！（这里是否变更单生效后再把原单据改为 非最新版本）
                revise.setLatestFlag(false);
                //第一次变更保存，设置原单据初始版本id
                revise.setBaseForecastId(null != revise.getBaseForecastId() ? revise.getBaseForecastId() : revise.getId());

                super.saveOrUpdate(revise);
            }
        }
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    private void resetPid(List<ForecastDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (ForecastDetailEntity detail : detailList) {
                if (!("del").equals(detail.getRowState())) {
                    if (detail.getId() == null) {
                        detail.setId(IdWorker.getId());
                    }
                    idMap.put(detail.getTid(), detail.getId());
                    detail.setParentId(null);
                }
            }
            for (ForecastDetailEntity detail : detailList) {
                if (!("del").equals(detail.getRowState())) {
                    if (StringUtils.isNotEmpty(detail.getTpid())) {
                        detail.setParentId(idMap.get(detail.getTpid()));
                    }
                }
            }
        }
    }

    @Override
    public ForecastVO queryDetail(Long id) {
        ForecastEntity entity = super.selectById(id);
        ForecastVO vo = BeanMapper.map(entity, ForecastVO.class);

        //子表
        List<ForecastDetailVO> detailList = vo.getForecastDetailList();
        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (ForecastDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setForecastDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        //记录表
        List<ForecastRecordVO> list = new ArrayList<>();
        LambdaQueryWrapper<ForecastEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ForecastEntity::getBaseForecastId, entity.getBaseForecastId());
        queryWrapper.in(ForecastEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.ne(ForecastEntity::getId, id);
        queryWrapper.orderByAsc(ForecastEntity::getCreateTime);
        List<ForecastEntity> forecastEntityList = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(forecastEntityList)) {
            list = BeanMapper.mapList(forecastEntityList, ForecastRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    //变更单赋值
    @Override
    public ForecastVO queryChangeDetail(Long id) {
        ForecastEntity entity = super.selectById(id);
        ForecastVO vo = BeanMapper.map(entity, ForecastVO.class);
        vo.setId(null);
//        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);

        vo.setBeforeForecastVersion(vo.getForecastVersion());
        vo.setForecastVersion(vo.getForecastVersion() + 1);
        vo.setLastForecastId(id);
        vo.setBaseForecastId(null != entity.getBaseForecastId() ? entity.getBaseForecastId() : id);

        vo.setChangeEmployeeId(null);
        vo.setChangeEmployeeName(null);
        vo.setChangeReason(null);

        List<ForecastDetailVO> detailList = vo.getForecastDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTid(changeDetailVO.getId());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("add");
            });
            detailList = TreeNodeBUtil.buildTree(detailList);
            detailList.forEach((detail) -> {
                detail.setId(IdWorker.getId());
                detail.getChildren().forEach((child) -> {
                    ((ForecastDetailVO) child).setId(IdWorker.getId());
                    ((ForecastDetailVO) child).setParentId(detail.getId());
                });
            });
            vo.setForecastDetailList(detailList);

        }
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<ForecastVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ForecastVO forecastVO : vos) {
                ForecastEntity forecastEntity = super.selectById(forecastVO.getId());
                //删除变更中的数据、回写原数据
                // （这里是否有问题，如果变更一次后，第二次变更怎么显示？版本号是不是这里体现意义？这里得价格版本号）
                if (forecastEntity.getLastForecastId() != null) {
                    ForecastEntity revise = super.getById(forecastEntity.getLastForecastId());
                    revise.setChangeId(null);
                    revise.setLatestFlag(true);

                    //可能不是第一次变更
                    revise.setChangeState(1 == forecastEntity.getForecastVersion() ? ChangeStateEnum.未变更.getCode() : ChangeStateEnum.已变更.getCode());
                    super.saveOrUpdate(revise);
                }
            }
        }
        super.removeByIds(vos.stream().map(ForecastVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @Override
    public CommonResponse<String> checkOrgMonth(Long rowId, Long orgId, String forecastMonth) {
        QueryWrapper<ForecastEntity> query = new QueryWrapper<>();
        query.eq("org_id", orgId);
        query.eq("forecast_month", forecastMonth + "-01");
        if (rowId != null) {
            query.ne("id", rowId);
        }
        List<ForecastEntity> billList = super.list(query);
        billList.forEach((bill) -> {
            System.out.println(bill.getId());
        });
        return CommonResponse.success(CollectionUtils.isNotEmpty(billList) ? "本区域 + 预报月份已有销售预报的单据！" : null);
    }

    @Override
    public void updateResDatas(List<ForecastLedgerVO> resDatas) {
        if (CollectionUtils.isNotEmpty(resDatas)) {
            for (ForecastLedgerVO resData : resDatas) {
                //父级 完成金额
                BigDecimal child2CompletionCount = new BigDecimal(0);
                BigDecimal child2CompletionGapCount = new BigDecimal(0);
                //父级 开票金额
                BigDecimal child2invoiceCompletionMny = new BigDecimal(0);
                BigDecimal child2invoiceCompletionGap = new BigDecimal(0);
                //父级 收款金额
                BigDecimal child2incomeCompletionMny = new BigDecimal(0);
                BigDecimal child2incomeCompletionGap = new BigDecimal(0);
                for (ITreeNodeB child : resData.getChildren()) {
                    ForecastLedgerVO child2 = (ForecastLedgerVO) child;
                    //孙级 完成金额
                    BigDecimal child3CompletionCount = new BigDecimal(0);
                    BigDecimal child3CompletionGapCount = new BigDecimal(0);
                    //孙级 开票金额
                    BigDecimal child3invoiceCompletionMny = new BigDecimal(0);
                    BigDecimal child3invoiceCompletionGap = new BigDecimal(0);
                    //孙级 收款金额
                    BigDecimal child3incomeCompletionMny = new BigDecimal(0);
                    BigDecimal child3incomeCompletionGap = new BigDecimal(0);
                    //如果有第二层 下边还有第三层
                    if (!child2.getLeafFlag()) {
                        for (ITreeNodeB childChild : child.getChildren()) {
                            ForecastLedgerVO child3 = (ForecastLedgerVO) childChild;

                            extract3(child3);

                            child3CompletionCount = child3CompletionCount.add(child3.getSaleCompletionMny());
                            child3CompletionGapCount = child3CompletionGapCount.add(child3.getSaleCompletionGap());

                            child3invoiceCompletionMny = child3invoiceCompletionMny.add(child3.getInvoiceCompletionMny());
                            child3invoiceCompletionGap = child3invoiceCompletionGap.add(child3.getInvoiceCompletionGap());

                            child3incomeCompletionMny = child3incomeCompletionMny.add(child3.getIncomeCompletionMny());
                            child3incomeCompletionGap = child3incomeCompletionGap.add(child3.getIncomeCompletionGap());
                        }
                        //为 父级完成金额 赋值
                        child2.setSaleCompletionMny(child3CompletionCount);
                        //为 父级完成金额差距 赋值
                        child2.setSaleCompletionGap(child3CompletionGapCount);

                        //为 父级开票金额 赋值
                        child2.setInvoiceCompletionMny(child3invoiceCompletionMny);
                        child2.setInvoiceCompletionGap(child3invoiceCompletionGap);

                        //为 父级收款金额 赋值
                        child2.setIncomeCompletionMny(child3incomeCompletionMny);
                        child2.setIncomeCompletionGap(child3incomeCompletionGap);


                    } else {
                        extract2(child2);
                    }
                    //合计 所有父级 的完成金额
                    child2CompletionCount = child2CompletionCount.add(child2.getSaleCompletionMny());

                    //合计 所有父级 的完成金额差距
                    child2CompletionGapCount = child2CompletionGapCount.add(child2.getSaleCompletionGap());

                    child2invoiceCompletionMny = child2invoiceCompletionMny.add(child2.getInvoiceCompletionMny());
                    child2invoiceCompletionGap = child2invoiceCompletionGap.add(child2.getInvoiceCompletionGap());

                    child2incomeCompletionMny = child2incomeCompletionMny.add(child2.getIncomeCompletionMny());
                    child2incomeCompletionGap = child2incomeCompletionGap.add(child2.getIncomeCompletionGap());

                }

                //为 爷爷级 完成金额child2incomeCompletionGap 赋值
                resData.setSaleCompletionMny(child2CompletionCount);
                //为 爷爷级 完成金额差距赋值
                resData.setSaleCompletionGap(child2CompletionGapCount);

                resData.setInvoiceCompletionMny(child2invoiceCompletionMny);
                resData.setInvoiceCompletionGap(child2invoiceCompletionGap);

                resData.setIncomeCompletionMny(child2incomeCompletionMny);
                resData.setIncomeCompletionGap(child2incomeCompletionGap);

            }
        }
    }

    @Override
    public List<ForecastReportVO> queryListAll(Page pages, QueryWrapper queryWrapper) {
        return baseMapper.queryListAll(pages, queryWrapper);
    }

    @Override
    public List<ForecastReportVO> queryDetailAll(List<Long> ids) {
        return baseMapper.queryDetailAll(ids);
    }

    private void extract3(ForecastLedgerVO child) {
        LambdaQueryWrapper<ForecastEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.select(ForecastEntity::getForecastMonth);
        wrapper.eq(ForecastEntity::getId, child.getPid());
        ForecastEntity forecastEntity = baseMapper.selectOne(wrapper);

        Date forecastMonth = forecastEntity.getForecastMonth();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        String month = sim.format(forecastMonth).substring(5, 7);
        String year = sim.format(forecastMonth).substring(0, 4);
        LambdaQueryWrapper<ForecastDetailEntity> wrapper1 = new LambdaQueryWrapper<>();
        wrapper1.eq(ForecastDetailEntity::getId, child.getParentId());
        ForecastDetailEntity forecastDetailEntity = detailMapper.selectOne(wrapper1);
        //查询报表
        LambdaQueryWrapper<SaleReportEntity> saleReportWrapper = new LambdaQueryWrapper<>();
        saleReportWrapper.eq(SaleReportEntity::getYear, year);
        saleReportWrapper.eq(SaleReportEntity::getEmployeeId, child.getDetailPersonId());
        saleReportWrapper.eq(SaleReportEntity::getTeamOrgId, forecastDetailEntity.getDetailOrgId());
        switch (month) {
            case "01": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);


                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstOneMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstOneMny());
                        }
                        if(saleReportEntity.getKpFirstOneMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFirstOneMny());
                        }
                        if(saleReportEntity.getSkFirstOneMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFirstOneMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "02": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstTwoMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstTwoMny());

                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstTwoMny());
                        }
                        if (saleReportEntity.getKpFirstTwoMny() != null) {

                        }
                        if (saleReportEntity.getSkFirstTwoMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstTwoMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "03": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstThreeMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstThreeMny());

                        }
                        if(saleReportEntity.getKpFirstThreeMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFirstThreeMny());
                        }
                        if(saleReportEntity.getSkFirstThreeMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFirstThreeMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "04": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFourMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFourMny());
                        }
                        if(saleReportEntity.getKpSecondFourMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpSecondFourMny());
                        }
                        if(saleReportEntity.getSkSecondFourMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkSecondFourMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "05": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFiveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFiveMny());

                        }
                        if(saleReportEntity.getKpSecondFiveMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpSecondFiveMny());
                        }
                        if(saleReportEntity.getSkSecondFiveMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkSecondFiveMny());
                        }
                    }

                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "06": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondSixMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondSixMny());
                        }
                        if(saleReportEntity.getKpSecondSixMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpSecondSixMny());
                        }
                        if(saleReportEntity.getSkSecondSixMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkSecondSixMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "07": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdSevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdSevenMny());
                        }
                        if(saleReportEntity.getKpThirdSevenMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpThirdSevenMny());
                        }
                        if(saleReportEntity.getSkThirdSevenMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkThirdSevenMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }


                break;
            }
            case "08": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdEightMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdEightMny());
                        }
                        if(saleReportEntity.getKpThirdEightMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpThirdEightMny());
                        }
                        if(saleReportEntity.getSkThirdEightMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkThirdEightMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "09": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdNineMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdNineMny());
                        }
                        if(saleReportEntity.getKpThirdNineMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpThirdNineMny());
                        }
                        if(saleReportEntity.getSkThirdNineMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkThirdNineMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }


                break;
            }
            case "10": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTenMny());
                        }
                        if(saleReportEntity.getKpFourthTenMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFourthTenMny());
                        }
                        if(saleReportEntity.getSkFourthTenMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFourthTenMny());

                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }
                break;
            }
            case "11": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthElevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthElevenMny());
                        }
                        if(saleReportEntity.getKpFourthElevenMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFourthElevenMny());
                        }
                        if(saleReportEntity.getSkFourthElevenMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFourthElevenMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "12": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTwelveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTwelveMny());
                        }
                        if(saleReportEntity.getKpFourthTwelveMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFourthTwelveMny());
                        }
                        if(saleReportEntity.getSkFourthTwelveMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFourthTwelveMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
        }
    }



    private void extract2(ForecastLedgerVO child) {
        LambdaQueryWrapper<ForecastEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.select(ForecastEntity::getForecastMonth);
        wrapper.eq(ForecastEntity::getId, child.getPid());
        ForecastEntity forecastEntity = baseMapper.selectOne(wrapper);

        Date forecastMonth = forecastEntity.getForecastMonth();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        String month = sim.format(forecastMonth).substring(5, 7);
        String year = sim.format(forecastMonth).substring(0, 4);

        //查询报表
        LambdaQueryWrapper<SaleReportEntity> saleReportWrapper = new LambdaQueryWrapper<>();
        saleReportWrapper.eq(SaleReportEntity::getYear, year);
        saleReportWrapper.eq(SaleReportEntity::getEmployeeId, child.getDetailPersonId());
        saleReportWrapper.eq(SaleReportEntity::getTeamOrgId, child.getDetailOrgId());
        switch (month) {
            case "01": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);


                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstOneMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstOneMny());
                        }
                        if(saleReportEntity.getKpFirstOneMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFirstOneMny());
                        }
                        if(saleReportEntity.getSkFirstOneMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFirstOneMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "02": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstTwoMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstTwoMny());

                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstTwoMny());
                        }
                        if (saleReportEntity.getKpFirstTwoMny() != null) {

                        }
                        if (saleReportEntity.getSkFirstTwoMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstTwoMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "03": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstThreeMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstThreeMny());

                        }
                        if(saleReportEntity.getKpFirstThreeMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFirstThreeMny());
                        }
                        if(saleReportEntity.getSkFirstThreeMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFirstThreeMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "04": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFourMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFourMny());
                        }
                        if(saleReportEntity.getKpSecondFourMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpSecondFourMny());
                        }
                        if(saleReportEntity.getSkSecondFourMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkSecondFourMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "05": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFiveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFiveMny());

                        }
                        if(saleReportEntity.getKpSecondFiveMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpSecondFiveMny());
                        }
                        if(saleReportEntity.getSkSecondFiveMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkSecondFiveMny());
                        }
                    }

                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "06": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondSixMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondSixMny());
                        }
                        if(saleReportEntity.getKpSecondSixMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpSecondSixMny());
                        }
                        if(saleReportEntity.getSkSecondSixMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkSecondSixMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "07": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdSevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdSevenMny());
                        }
                        if(saleReportEntity.getKpThirdSevenMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpThirdSevenMny());
                        }
                        if(saleReportEntity.getSkThirdSevenMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkThirdSevenMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }


                break;
            }
            case "08": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdEightMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdEightMny());
                        }
                        if(saleReportEntity.getKpThirdEightMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpThirdEightMny());
                        }
                        if(saleReportEntity.getSkThirdEightMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkThirdEightMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "09": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdNineMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdNineMny());
                        }
                        if(saleReportEntity.getKpThirdNineMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpThirdNineMny());
                        }
                        if(saleReportEntity.getSkThirdNineMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkThirdNineMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }


                break;
            }
            case "10": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTenMny());
                        }
                        if(saleReportEntity.getKpFourthTenMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFourthTenMny());
                        }
                        if(saleReportEntity.getSkFourthTenMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFourthTenMny());

                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }
                break;
            }
            case "11": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthElevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthElevenMny());
                        }
                        if(saleReportEntity.getKpFourthElevenMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFourthElevenMny());
                        }
                        if(saleReportEntity.getSkFourthElevenMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFourthElevenMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
            case "12": {

                List<SaleReportEntity> saleReportEntities = saleReportMapper.selectList(saleReportWrapper);
                //完成金额
                BigDecimal CompletionMny = new BigDecimal(0);
                //完成差距
                BigDecimal completionGap = new BigDecimal(0);
                //开票完成金额
                BigDecimal  invoiceCompletionMny = new BigDecimal(0);
                //开票完成差距
                BigDecimal  invoiceCompletionGap = new BigDecimal(0);

                // 收款完成金额
                BigDecimal  incomeCompletionMny = new BigDecimal(0);
                //收款完成差距
                BigDecimal  incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty(saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTwelveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTwelveMny());
                        }
                        if(saleReportEntity.getKpFourthTwelveMny()!=null){
                            invoiceCompletionMny=invoiceCompletionMny.add(saleReportEntity.getKpFourthTwelveMny());
                        }
                        if(saleReportEntity.getSkFourthTwelveMny()!=null){
                            incomeCompletionMny=incomeCompletionMny.add(saleReportEntity.getSkFourthTwelveMny());
                        }
                    }
                    setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                } else {
                    setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                }

                break;
            }
        }
    }
    private static void setMny2(ForecastLedgerVO child, BigDecimal CompletionMny, BigDecimal invoiceCompletionMny, BigDecimal incomeCompletionMny) {
        child.setSaleCompletionMny(CompletionMny); //销售完成金额
        child.setInvoiceCompletionMny(invoiceCompletionMny);//开票完成金额
        child.setIncomeCompletionMny(incomeCompletionMny);  // 收款完成金额

        child.setSaleCompletionGap(BigDecimal.valueOf(0).subtract(child.getSaleForecastMny()));
        child.setInvoiceCompletionGap(BigDecimal.valueOf(0).subtract(child.getInvoiceForecastMny()));
        child.setIncomeCompletionGap(BigDecimal.valueOf(0).subtract(child.getIncomeForecastMny()));
    }

    private static void setMny1(ForecastLedgerVO child, BigDecimal CompletionMny, BigDecimal invoiceCompletionMny, BigDecimal incomeCompletionMny) {
        BigDecimal incomeCompletionGap;
        BigDecimal invoiceCompletionGap;
        BigDecimal completionGap;
        child.setSaleCompletionMny(CompletionMny); //销售完成金额
        child.setInvoiceCompletionMny(invoiceCompletionMny);//开票完成金额
        child.setIncomeCompletionMny(incomeCompletionMny);  // 收款完成金额

        completionGap = child.getSaleCompletionMny().subtract(child.getSaleForecastMny()); //销售完成差距
        invoiceCompletionGap= child.getInvoiceCompletionMny().subtract(child.getInvoiceForecastMny());//开票完成差距
        incomeCompletionGap= child.getIncomeCompletionMny().subtract(child.getIncomeForecastMny());//收款完成差距

        child.setSaleCompletionGap(completionGap);
        child.setInvoiceCompletionGap(invoiceCompletionGap);
        child.setIncomeCompletionGap(incomeCompletionGap);
    }
}
