package com.ejianc.business.jlincome.report.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlincome.report.bean.CooperationDetailEntity;
import com.ejianc.business.jlincome.report.bean.CooperationPlanEntity;
/**
 * 企院（校）合作工作
 * 
 * @author generator
 * 
 */
 @TableName("ejc_report_cooperation")
public class CooperationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 区域id
    @TableField(value="org_name")
    private String orgName; // 区域名称
    @TableField(value="org_code")
    private String orgCode; // 区域编码
    @TableField(value="report_id")
    private Long reportId; // 填报人id
    @TableField(value="report_name")
    private String reportName; // 填报人名称
    @TableField(value="report_month")
    private Date reportMonth; // 填报月份
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="cooperationDetailService")
    private List<CooperationDetailEntity> cooperationDetailList = new ArrayList<>(); // 企院（校）合作工作开展详情
    @TableField(exist=false)
    @SubEntity(serviceName="cooperationPlanService")
    private List<CooperationPlanEntity> cooperationPlanList = new ArrayList<>(); // 企院（校）合作工作开展计划
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getReportId() {
        return reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }
    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }
    public Date getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(Date reportMonth) {
        this.reportMonth = reportMonth;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<CooperationDetailEntity> getCooperationDetailList() {
        return cooperationDetailList;
    }

    public void setCooperationDetailList(List<CooperationDetailEntity> cooperationDetailList) {
        this.cooperationDetailList = cooperationDetailList;
    }

    public List<CooperationPlanEntity> getCooperationPlanList() {
        return cooperationPlanList;
    }

    public void setCooperationPlanList(List<CooperationPlanEntity> cooperationPlanList) {
        this.cooperationPlanList = cooperationPlanList;
    }
}
