package com.ejianc.business.jlincome.report.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlincome.report.bean.MarketAnalysisDetailEntity;
/**
 * 已合作重点客户单位市场分析
 * 
 * @author generator
 * 
 */
 @TableName("ejc_report_market_analysis")
public class MarketAnalysisEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 区域
    @TableField(value="org_name")
    private String orgName; // 区域名称
    @TableField(value="org_code")
    private String orgCode; // 区域编码
    @TableField(value="employee_id")
    private Long employeeId; // 填报人
    @TableField(value="employee_name")
    private String employeeName; // 填报人名称
    @TableField(value="month")
    private Date month; // 填报月份
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="marketAnalysisDetailService", pidName = "analysisId")
    private List<MarketAnalysisDetailEntity> marketAnalysisDetailList = new ArrayList<>(); // 已合作重点客户单位市场分析明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<MarketAnalysisDetailEntity> getMarketAnalysisDetailList() {
        return marketAnalysisDetailList;
    }

    public void setMarketAnalysisDetailList(List<MarketAnalysisDetailEntity> marketAnalysisDetailList) {
        this.marketAnalysisDetailList = marketAnalysisDetailList;
    }
}
