package com.ejianc.business.jlincome.report.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlincome.report.bean.ReceivableManageDetailEntity;
/**
 * 应收款分类管理
 * 
 * @author generator
 * 
 */
 @TableName("ejc_report_receivable_manage")
public class ReceivableManageEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 区域
    @TableField(value="org_name")
    private String orgName; // 区域名称
    @TableField(value="org_code")
    private String orgCode; // 区域编码
    @TableField(value="employee_id")
    private Long employeeId; // 填报人
    @TableField(value="employee_name")
    private String employeeName; // 填报人名称
    @TableField(value="receivable_date")
    private Date receivableDate; // 填报日期
    @TableField(value="debt_mny")
    private BigDecimal debtMny; // 欠款
    @TableField(value="receivable_mny")
    private BigDecimal receivableMny; // 应收
    @TableField(value="intransit_mny")
    private BigDecimal intransitMny; // 在途
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="receivableManageDetailService", pidName = "manageId")
    private List<ReceivableManageDetailEntity> receivableManageDetailList = new ArrayList<>(); // 应收款分类管理明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getReceivableDate() {
        return receivableDate;
    }

    public void setReceivableDate(Date receivableDate) {
        this.receivableDate = receivableDate;
    }
    public BigDecimal getDebtMny() {
        return debtMny;
    }

    public void setDebtMny(BigDecimal debtMny) {
        this.debtMny = debtMny;
    }
    public BigDecimal getReceivableMny() {
        return receivableMny;
    }

    public void setReceivableMny(BigDecimal receivableMny) {
        this.receivableMny = receivableMny;
    }
    public BigDecimal getIntransitMny() {
        return intransitMny;
    }

    public void setIntransitMny(BigDecimal intransitMny) {
        this.intransitMny = intransitMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<ReceivableManageDetailEntity> getReceivableManageDetailList() {
        return receivableManageDetailList;
    }

    public void setReceivableManageDetailList(List<ReceivableManageDetailEntity> receivableManageDetailList) {
        this.receivableManageDetailList = receivableManageDetailList;
    }
}
