package com.ejianc.business.jlincome.report.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlincome.report.bean.StrategyDetailEntity;
import com.ejianc.business.jlincome.report.bean.StrategyPlanEntity;
/**
 * 战略合作/年度协议
 * 
 * @author generator
 * 
 */
 @TableName("ejc_report_strategy")
public class StrategyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="report_id")
    private Long reportId; // 填报人id
    @TableField(value="report_name")
    private String reportName; // 填报人名称
    @TableField(value="report_month")
    private Date reportMonth; // 填报月份
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="strategyDetailService")
    private List<StrategyDetailEntity> strategyDetailList = new ArrayList<>(); // 战略合作/年度协议详情
    @TableField(exist=false)
    @SubEntity(serviceName="strategyPlanService")
    private List<StrategyPlanEntity> strategyPlanList = new ArrayList<>(); // 战略合作/年度协议计划
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getReportId() {
        return reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }
    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }
    public Date getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(Date reportMonth) {
        this.reportMonth = reportMonth;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<StrategyDetailEntity> getStrategyDetailList() {
        return strategyDetailList;
    }

    public void setStrategyDetailList(List<StrategyDetailEntity> strategyDetailList) {
        this.strategyDetailList = strategyDetailList;
    }

    public List<StrategyPlanEntity> getStrategyPlanList() {
        return strategyPlanList;
    }

    public void setStrategyPlanList(List<StrategyPlanEntity> strategyPlanList) {
        this.strategyPlanList = strategyPlanList;
    }
}
