package com.ejianc.business.jlincome.report.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.report.bean.MarketAnalysisDetailEntity;
import com.ejianc.business.jlincome.report.service.IMarketAnalysisDetailService;
import com.ejianc.business.jlincome.report.vo.MarketAnalysisDetailVO;
import com.ejianc.business.jlincome.report.vo.MarketAnalysisReportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.report.bean.MarketAnalysisEntity;
import com.ejianc.business.jlincome.report.service.IMarketAnalysisService;
import com.ejianc.business.jlincome.report.vo.MarketAnalysisVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 已合作重点客户单位市场分析
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("marketAnalysis")
public class MarketAnalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "YS_MANAGE_CODE";//此处需要根据实际修改

    @Autowired
    private IMarketAnalysisService service;

    @Autowired
    private IMarketAnalysisDetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MarketAnalysisVO> saveOrUpdate(@RequestBody MarketAnalysisVO saveOrUpdateVO) {
    	MarketAnalysisEntity entity = BeanMapper.map(saveOrUpdateVO, MarketAnalysisEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        LambdaQueryWrapper<MarketAnalysisEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MarketAnalysisEntity::getOrgId, saveOrUpdateVO.getOrgId());
        queryWrapper.eq(MarketAnalysisEntity::getMonth, saveOrUpdateVO.getMonth());
        if(null!=entity.getId()){
            queryWrapper.ne(MarketAnalysisEntity::getId, saveOrUpdateVO.getId());
        }
        List<MarketAnalysisEntity> list = service.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("相同区域,月份 只能填报一次！");
        }

    	service.saveOrUpdate(entity, false);
    	MarketAnalysisVO vo = BeanMapper.map(entity, MarketAnalysisVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MarketAnalysisVO> queryDetail(Long id) {
    	MarketAnalysisEntity entity = service.selectById(id);
    	MarketAnalysisVO vo = BeanMapper.map(entity, MarketAnalysisVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/queryDetailByOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MarketAnalysisDetailVO> > queryDetail(Long orgId, String month) {
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        Date mm = null;
        try {
            Date date = dateFormat.parse(month);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(Calendar.MONTH, -1);
            mm = calendar.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }

        LambdaQueryWrapper<MarketAnalysisEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MarketAnalysisEntity::getOrgId, orgId);
        queryWrapper.eq(MarketAnalysisEntity::getMonth, mm);//取上个月信息
        List<MarketAnalysisEntity> list = service.list(queryWrapper);
        List<MarketAnalysisDetailVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            LambdaQueryWrapper<MarketAnalysisDetailEntity> queryWrapper2 = new LambdaQueryWrapper<>();
            queryWrapper2.eq(MarketAnalysisDetailEntity::getAnalysisId, list.get(0).getId());
            List<MarketAnalysisDetailEntity> marketAnalysisEntityList = detailService.list(queryWrapper2);
            marketAnalysisEntityList.forEach(e->{
                e.setAnalysisId(null);
                e.setRowState("add");
            });
            resList = BeanMapper.mapList(marketAnalysisEntityList,MarketAnalysisDetailVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",resList);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MarketAnalysisVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MarketAnalysisVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MarketAnalysisVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MarketAnalysisVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(param.getParams().containsKey("month")){
            String month = param.getParams().get("month").toString();
            param.getParams().put("month", new Parameter(QueryParam.EQ, month+"-01"));
        }
        IPage<MarketAnalysisEntity> page = service.queryPage(param,false);
        IPage<MarketAnalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MarketAnalysisVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryListReport(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        //先找父级  根据分级 分页
        Page<MarketAnalysisReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<MarketAnalysisReportVO> resList = service.queryListAll(page, wrapper);
        //取自己  根据区域+组织 合并树形
        if(CollectionUtils.isNotEmpty(resList)){
            List<MarketAnalysisReportVO> detialList = service.queryDetailAll(resList.stream().map(MarketAnalysisReportVO::getId).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(detialList)){
                resList.addAll(detialList);
            }
        }
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", TreeNodeBUtil.buildTree(resList));
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }
    
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MarketAnalysisEntity> list = service.queryList(param);
        List<MarketAnalysisVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            resList = BeanMapper.mapList(list,MarketAnalysisVO.class);
            resList.forEach(e->{
                e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("MarketAnalysis-export.xlsx", beans, response);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        //先找父级  根据分级 分页
        Page<MarketAnalysisReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<MarketAnalysisReportVO> resList = service.queryListAll(page, wrapper);
        //取自己  根据区域+组织 合并树形
        List<MarketAnalysisReportVO> detialList = service.queryDetailAll(resList.stream().map(MarketAnalysisReportVO::getId).collect(Collectors.toList()));
        if(CollectionUtils.isNotEmpty(detialList)){
            resList.addAll(detialList);
        }
        List<ITreeNodeB> list = new ArrayList<>();
        List<MarketAnalysisReportVO> res= TreeNodeBUtil.buildTree(resList);
        res.forEach(e->{
            list.add(e);
            if(CollectionUtils.isNotEmpty(e.getChildren())){
                list.addAll(e.getChildren());
            }
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", BeanMapper.mapList(list,MarketAnalysisReportVO.class));
        ExcelExport.getInstance().export("MarketAnalysisReport-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refMarketAnalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MarketAnalysisVO>> refMarketAnalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MarketAnalysisEntity> page = service.queryPage(param,false);
        IPage<MarketAnalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MarketAnalysisVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
