package com.ejianc.business.jlincome.report.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.report.vo.ReceivableManageDetailVO;
import com.ejianc.business.jlincome.report.vo.ReceivableManageReportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.report.bean.ReceivableManageEntity;
import com.ejianc.business.jlincome.report.service.IReceivableManageService;
import com.ejianc.business.jlincome.report.vo.ReceivableManageVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 应收款分类管理
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("receivableManage")
public class ReceivableManageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "HZ_MARKET_CODE";//此处需要根据实际修改

    @Autowired
    private IReceivableManageService service;

    @Autowired
    private SessionManager sessionManager;
    @Qualifier("com.ejianc.foundation.share.api.IProjectArchiveApi")
    @Autowired
    private IProjectArchiveApi iProjectArchiveApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReceivableManageVO> saveOrUpdate(@RequestBody ReceivableManageVO saveOrUpdateVO) {
    	ReceivableManageEntity entity = BeanMapper.map(saveOrUpdateVO, ReceivableManageEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ReceivableManageVO vo = BeanMapper.map(entity, ReceivableManageVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReceivableManageVO> queryDetail(Long id) {
    	ReceivableManageEntity entity = service.selectById(id);
    	ReceivableManageVO vo = BeanMapper.map(entity, ReceivableManageVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryListMny 查询详情
     * @param
     */
    @RequestMapping(value = "/queryListMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReceivableManageVO>> queryListMny(Long orgId) {





        return CommonResponse.success("查询详情数据成功！",new ArrayList<>());
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceivableManageVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ReceivableManageVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ReceivableManageVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReceivableManageVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<ReceivableManageEntity> page = service.queryPage(param,false);
        IPage<ReceivableManageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReceivableManageVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryListReport(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        //先找父级  根据分级 分页
        List<ReceivableManageReportVO> resList = new ArrayList<>();
        Map<String,List<ReceivableManageReportVO>> map = new HashMap<>();
        Page<ReceivableManageReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReceivableManageReportVO> RecordVOList = service.queryListAll(page, wrapper);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        if(CollectionUtils.isNotEmpty(RecordVOList)){
            RecordVOList.forEach(e->{
                List<ReceivableManageReportVO> list = new ArrayList<>();
                list.add(e);
                map.put(e.getOrgId().toString()+e.getReceivableDate(),list);
            });
        }
        //取自己  根据区域+组织 合并树形
        String receivableDate = "";
        if(param.getParams().containsKey("receivableDate")){
            receivableDate = param.getParams().get("receivableDate").getValue().toString();
        }
        List<ReceivableManageReportVO> detialList = service.queryDetailAll(receivableDate);
        detialList.forEach(e->{
            String key = e.getOrgId().toString()+e.getReceivableDate();
            if(map.containsKey(key)){
                List<ReceivableManageReportVO> list = map.get(key);
                e.setParentId(list.get(0).getId());//设置父级id  关联上下级关系
                list.add(e);
                map.put(key,list);
            }
        });
        resList = map.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());

        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", TreeNodeBUtil.buildTree(resList));
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReceivableManageEntity> list = service.queryList(param);
        List<ReceivableManageVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            resList = BeanMapper.mapList(list,ReceivableManageVO.class);
            resList.forEach(e->{
                e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("ReceivableManage-export.xlsx", beans, response);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        //先找父级  根据分级 分页
        List<ReceivableManageReportVO> resList = new ArrayList<>();
        Map<String,List<ReceivableManageReportVO>> map = new HashMap<>();
        Page<ReceivableManageReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReceivableManageReportVO> RecordVOList = service.queryListAll(page, wrapper);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        if(CollectionUtils.isNotEmpty(RecordVOList)){
            RecordVOList.forEach(e->{
                List<ReceivableManageReportVO> list = new ArrayList<>();
                list.add(e);
                map.put(e.getOrgId().toString()+sf.format(e.getReceivableDate()),list);
            });
        }
        //取自己  根据区域+组织 合并树形
        String receivableDate = "";
        if(param.getParams().containsKey("receivableDate")){
            receivableDate = param.getParams().get("receivableDate").getValue().toString();
        }
        List<ReceivableManageReportVO> detialList = service.queryDetailAll(receivableDate);
        detialList.forEach(e->{
            String key = e.getOrgId().toString()+sf.format(e.getReceivableDate());
            if(map.containsKey(key)){
                List<ReceivableManageReportVO> list = map.get(key);
                e.setParentId(list.get(0).getId());//设置父级id  关联上下级关系
                list.add(e);
                map.put(key,list);
            }
        });
        resList = map.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());

        List<ITreeNodeB> list = new ArrayList<>();
        List<ReceivableManageReportVO> res= TreeNodeBUtil.buildTree(resList);
        res.forEach(e->{
            list.add(e);
            if(CollectionUtils.isNotEmpty(e.getChildren())){
                list.addAll(e.getChildren());
            }
        });

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", BeanMapper.mapList(list,ReceivableManageReportVO.class));
        ExcelExport.getInstance().export("ReceivableManageReport-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refReceivableManageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReceivableManageVO>> refReceivableManageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ReceivableManageEntity> page = service.queryPage(param,false);
        IPage<ReceivableManageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReceivableManageVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/getReceivableProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReceivableManageDetailVO>> getReceivableProject(Long orgId) {
        CommonResponse<List<OrgVO>> orgRes = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
        if (!orgRes.isSuccess()){
            logger.info("查询本下组织失败：{}",orgRes.getMsg());
            return CommonResponse.error("查询本下组织失败");
        }
        List<Long> orgIds = orgRes.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        logger.info("查询本下组织：{}",orgRes.getData());

        QueryParam param = new QueryParam();
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));
        param.getParams().put("projectStatus", new Parameter(QueryParam.NOT_IN, Arrays.asList(1, 2, 3)));
        CommonResponse<List<ProjectArchiveVO>> projectRes = iProjectArchiveApi.getProjectArchiveByOrgIds(param);
        if (!projectRes.isSuccess()){
            logger.info("查询区域项目失败：{}",orgRes.getMsg());
            return CommonResponse.error("查询区域项目失败");
        }
        List<ProjectArchiveVO> projectList = projectRes.getData();
        if (CollectionUtils.isEmpty(projectList)){
            return CommonResponse.success(new ArrayList<>());
        }
        List<Long> projectIds = projectList.stream().map(ProjectArchiveVO::getId).collect(Collectors.toList());
        List<ReceivableManageDetailVO> receivableManageDetailVOS = service.queryListMny(projectIds);
        Map<Long, ProjectArchiveVO> projectMap = projectList.stream().collect(Collectors.toMap(ProjectArchiveVO::getId, project -> project));
        for (ReceivableManageDetailVO receivable : receivableManageDetailVOS) {
            ProjectArchiveVO project = projectMap.get(receivable.getProjectId());
            receivable.setProjectName(project.getName());
            receivable.setProjectCode(project.getCode());
            receivable.setDetailEmployeeId(project.getSaleLeaderId());
            receivable.setDetailEmployeeName(project.getSaleLeaderName());
            receivable.setCustomerId(project.getCustomId());
            receivable.setCustomerName(project.getCustomName());
            receivable.setCustomerCode(project.getCustomCode());
        }
        return CommonResponse.success(receivableManageDetailVOS);
    }
}
