/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import com.ejianc.business.jlincome.bid.vo.BusinessReportVO;
import com.ejianc.business.jlincome.bid.vo.BusinessVO;
import com.ejianc.business.jlincome.bid.vo.SalePromoteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"business"})
public class BusinessController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BUSINESS";
    @Autowired
    private IBusinessService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BusinessVO> saveOrUpdate(@RequestBody BusinessVO saveOrUpdateVO) {
        CommonResponse projectArchiveRes;
        BusinessEntity oldEntity;
        BusinessEntity entity = (BusinessEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BusinessEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setAbandonFlag(false);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null != entity.getBillState() && (1 == entity.getBillState() || 3 == entity.getBillState()) && (null == (oldEntity = (BusinessEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()))).getBusinessRound() && null != saveOrUpdateVO.getBusinessRound() || null != oldEntity.getBusinessRound() && null != saveOrUpdateVO.getBusinessRound() && oldEntity.getBusinessRound() != saveOrUpdateVO.getBusinessRound()) && !(projectArchiveRes = this.projectArchiveApi.updateBusinessRound(entity.getBusinessRound(), entity.getId())).isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u9879\u76ee\u4fe1\u606f-\u5546\u673a\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
        }
        this.service.saveOrUpdate((Object)entity, false);
        BusinessVO vo = (BusinessVO)BeanMapper.map((Object)((Object)entity), BusinessVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BusinessVO> queryDetail(Long id) {
        BusinessEntity entity = (BusinessEntity)((Object)this.service.selectById(id));
        BusinessVO vo = (BusinessVO)BeanMapper.map((Object)((Object)entity), BusinessVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusinessVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BusinessVO businessVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BusinessVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("customName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("businessRound");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (null != param.getParams().get("selfFlag")) {
            String selfFlag = ((Parameter)param.getParams().get("selfFlag")).getValue().toString();
            param.getParams().remove("selfFlag");
            if ("1".equals(selfFlag)) {
                param.getParams().put("saleLeaderId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
            }
        }
        Long orgId = null;
        if (param.getParams().containsKey("orgId")) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().remove("orgId");
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            orgId = InvocationInfoProxy.getOrgId();
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BusinessVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("customName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("businessRound");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, BusinessVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            e.setAbandonFlagName(null != e.getAbandonFlag() ? "\u662f" : "\u5426");
            e.setBusinessStageName("0".equals(e.getBusinessStage()) ? "\u8ddf\u8e2a" : ("1".equals(e.getBusinessStage()) ? "\u4e2d\u6807" : "\u653e\u5f03"));
            if (null != e.getBusinessRound()) {
                switch (e.getBusinessRound()) {
                    case 0: {
                        e.setBusinessRoundName("\u9879\u76ee\u7acb\u9879");
                        break;
                    }
                    case 1: {
                        e.setBusinessRoundName("\u8bbe\u8ba1\u65b9\u6848");
                        break;
                    }
                    case 2: {
                        e.setBusinessRoundName("\u4e1a\u4e3b\u62db\u6807");
                        break;
                    }
                    case 3: {
                        e.setBusinessRoundName("\u603b\u5305\u62db\u6807");
                        break;
                    }
                    case 4: {
                        e.setBusinessRoundName("\u5408\u540c\u7b7e\u8ba2");
                    }
                }
            }
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("Business-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBusinessData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BusinessVO>> refBusinessData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("saleLeaderPhone");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), BusinessVO.class);
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateAbandonFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateAbandonFlag(Long id, Boolean abandonFlag) {
        return this.service.updateAbandonFlag(id, abandonFlag);
    }

    @RequestMapping(value={"/updateBusinessRound"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateBusinessRound(Long id, Integer businessRound) {
        return this.service.updateBusinessRound(id, businessRound);
    }

    @PostMapping(value={"/checkIsSave"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody BusinessVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/querySalePromoteDataList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalePromoteVO> querySalePromoteDataList(@RequestBody QueryParam param) {
        SalePromoteVO saleReportVO = this.service.querySalePromoteDataList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u9500\u552e\u63a8\u52a8\u6f0f\u6597\u6570\u636e\u6210\u529f\uff01", (Object)saleReportVO);
    }

    @RequestMapping(value={"/queryProjectProductData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectProductData(@RequestBody QueryParam param) {
        JSONObject jsonObject = this.service.queryProjectProductData(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u3001\u4ea7\u54c1\u7c7b\u578b\u5360\u6bd4\u5206\u6790\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/querySjReportTopTen"}, method={RequestMethod.GET})
    public CommonResponse<List<BusinessReportVO>> querySjReportTopTen(String start, String end) {
        Long orgId = 2405220178L;
        List orgList = (List)this.iOrgApi.findChildrenByParentId(orgId).getData();
        HashMap childOrgMap = new HashMap();
        HashMap childOrgsMap = new HashMap();
        orgList.forEach(e -> {
            if (orgId.equals(e.getParentId())) {
                childOrgMap.put(e.getId(), e);
            }
        });
        for (Long key : childOrgMap.keySet()) {
            String korgId = key.toString();
            orgList.forEach(e -> {
                if (e.getInnerCode().contains(korgId)) {
                    if (childOrgsMap.containsKey(key)) {
                        List orgIds = (List)childOrgsMap.get(key);
                        orgIds.add(e.getId());
                        childOrgsMap.put(key, orgIds);
                    } else {
                        ArrayList<Long> orgIds = new ArrayList<Long>();
                        orgIds.add(e.getId());
                        childOrgsMap.put(key, orgIds);
                    }
                }
            });
        }
        ArrayList<BusinessReportVO> sjList = new ArrayList<BusinessReportVO>();
        Integer sjNums = this.service.querySjReportNum(start, end);
        Integer gcbsjNum = 0;
        for (Long key : childOrgsMap.keySet()) {
            BusinessReportVO businessReportVO = new BusinessReportVO();
            businessReportVO.setId(key);
            businessReportVO.setOrgId(key);
            businessReportVO.setOrgName(((OrgVO)childOrgMap.get(key)).getName());
            Integer sjNum = this.service.querySjReportTopTen(start, end, (List)childOrgsMap.get(key));
            if (null != sjNum) {
                gcbsjNum = gcbsjNum + sjNum;
            }
            businessReportVO.setSjNum(sjNum);
            sjList.add(businessReportVO);
        }
        BusinessReportVO businessReportVO = new BusinessReportVO();
        businessReportVO.setId(Long.valueOf(11L));
        businessReportVO.setOrgId(Long.valueOf(11L));
        businessReportVO.setOrgName("\u5176\u4ed6");
        businessReportVO.setSjNum(Integer.valueOf(sjNums - gcbsjNum));
        sjList.add(businessReportVO);
        BusinessController.sjcoll(sjList);
        List sjList2 = sjList.subList(0, Math.min(10, sjList.size()));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", sjList2);
    }

    @RequestMapping(value={"/queryZbReportTopTen"}, method={RequestMethod.GET})
    public CommonResponse<List<BusinessReportVO>> queryZbReportTopTen(String start, String end) {
        Long orgId = 2405220178L;
        List orgList = (List)this.iOrgApi.findChildrenByParentId(orgId).getData();
        HashMap childOrgMap = new HashMap();
        HashMap childOrgsMap = new HashMap();
        orgList.forEach(e -> {
            if (orgId.equals(e.getParentId())) {
                childOrgMap.put(e.getId(), e);
            }
        });
        for (Long key : childOrgMap.keySet()) {
            String korgId = key.toString();
            orgList.forEach(e -> {
                if (e.getInnerCode().contains(korgId)) {
                    if (childOrgsMap.containsKey(key)) {
                        List orgIds = (List)childOrgsMap.get(key);
                        orgIds.add(e.getId());
                        childOrgsMap.put(key, orgIds);
                    } else {
                        ArrayList<Long> orgIds = new ArrayList<Long>();
                        orgIds.add(e.getId());
                        childOrgsMap.put(key, orgIds);
                    }
                }
            });
        }
        ArrayList<BusinessReportVO> zbList = new ArrayList<BusinessReportVO>();
        Integer sjNums = this.service.querySjReportNum(start, end);
        Integer zbNums = this.service.queryZbReportNum(start, end);
        Integer gcbsjNum = 0;
        Integer gcbzbNum = 0;
        for (Long key : childOrgsMap.keySet()) {
            BusinessReportVO businessReportVO = new BusinessReportVO();
            businessReportVO.setId(key);
            businessReportVO.setOrgId(key);
            businessReportVO.setOrgName(((OrgVO)childOrgMap.get(key)).getName());
            Integer sjNum = this.service.querySjReportTopTen(start, end, (List)childOrgsMap.get(key));
            if (null != sjNum) {
                gcbsjNum = gcbsjNum + sjNum;
            }
            businessReportVO.setSjNum(sjNum);
            Integer zbNum = this.service.queryZbReportTopTen(start, end, (List)childOrgsMap.get(key));
            if (null != zbNum) {
                gcbzbNum = gcbzbNum + zbNum;
            }
            businessReportVO.setZbNum(zbNum);
            if (null == sjNum || 0 == sjNum || null == zbNum || 0 == zbNum) {
                businessReportVO.setScale(BigDecimal.ZERO);
            } else {
                businessReportVO.setScale(ComputeUtil.safeDiv((BigDecimal)new BigDecimal(zbNum), (BigDecimal)new BigDecimal(sjNum)).multiply(new BigDecimal(100)).setScale(2, 4));
            }
            zbList.add(businessReportVO);
        }
        BusinessReportVO businessReportVO = new BusinessReportVO();
        businessReportVO.setId(Long.valueOf(11L));
        businessReportVO.setOrgId(Long.valueOf(11L));
        businessReportVO.setOrgName("\u5176\u4ed6");
        businessReportVO.setSjNum(Integer.valueOf(sjNums - gcbsjNum));
        businessReportVO.setZbNum(Integer.valueOf(zbNums - gcbzbNum));
        businessReportVO.setScale(ComputeUtil.safeDiv((BigDecimal)new BigDecimal(zbNums - gcbzbNum), (BigDecimal)new BigDecimal(sjNums - gcbsjNum)).multiply(new BigDecimal(100)).setScale(2, 4));
        zbList.add(businessReportVO);
        BusinessController.zbcoll(zbList);
        List zbList2 = zbList.subList(0, Math.min(10, zbList.size()));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", zbList2);
    }

    public static void sjcoll(List<BusinessReportVO> list) {
        Collections.sort(list, new Comparator<BusinessReportVO>(){

            @Override
            public int compare(BusinessReportVO o1, BusinessReportVO o2) {
                return o2.getSjNum() - o1.getSjNum();
            }
        });
    }

    public static void zbcoll(List<BusinessReportVO> list) {
        Collections.sort(list, new Comparator<BusinessReportVO>(){

            @Override
            public int compare(BusinessReportVO o1, BusinessReportVO o2) {
                return o2.getScale().compareTo(o1.getScale());
            }
        });
    }
}

