/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterDetailEntity;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.bid.service.IResultRegisterDetailService;
import com.ejianc.business.jlincome.bid.service.IResultRegisterService;
import com.ejianc.business.jlincome.bid.service.impl.ResultRegisterBpmServiceImpl;
import com.ejianc.business.jlincome.bid.vo.ResultRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"resultRegister"})
public class ResultRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_RESULT_REGISTER";
    @Autowired
    private IResultRegisterService service;
    @Autowired
    private IResultRegisterDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ResultRegisterBpmServiceImpl resultRegister;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ResultRegisterVO> saveOrUpdate(@RequestBody ResultRegisterVO saveOrUpdateVO) {
        ResultRegisterEntity entity = (ResultRegisterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ResultRegisterEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam;
            CommonResponse billCode;
            if (null == entity.getSourceType()) {
                entity.setSourceType(0);
            }
            if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Boolean sendFlag = false;
        if (null != entity.getBillState() && (1 == entity.getBillState() || 3 == entity.getBillState()) && entity.getRelateInstallFlag().booleanValue() && null != entity.getInstallLeaderId()) {
            ResultRegisterEntity oldEntity = (ResultRegisterEntity)((Object)this.service.selectById(entity.getId()));
            if (oldEntity.getRelateInstallFlag().booleanValue()) {
                if (!oldEntity.getInstallLeaderId().toString().equals(entity.getInstallLeaderId().toString())) {
                    sendFlag = true;
                }
            } else {
                sendFlag = true;
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (sendFlag.booleanValue()) {
            this.service.sendMsgToInstallPerson(entity);
        }
        ResultRegisterVO vo = (ResultRegisterVO)BeanMapper.map((Object)((Object)entity), ResultRegisterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ResultRegisterVO> queryDetail(Long id) {
        ResultRegisterEntity entity = (ResultRegisterEntity)((Object)this.service.selectById(id));
        ResultRegisterVO vo = (ResultRegisterVO)BeanMapper.map((Object)((Object)entity), ResultRegisterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ResultRegisterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ResultRegisterVO resultRegisterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResultRegisterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("bidWinUnitName");
        fuzzyFields.add("saleLeaderName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        if (param.getParams().containsKey("orgId")) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().remove("orgId");
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            orgId = InvocationInfoProxy.getOrgId();
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ResultRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResultRegisterVO>> queryReportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("productTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        Map<Long, ResultRegisterVO> recordMap = BeanMapper.mapList((Iterable)page.getRecords(), ResultRegisterVO.class).stream().collect(Collectors.toMap(BaseVO::getId, item -> {
            if (item.getBidWinFlag().booleanValue()) {
                item.setWinMny(item.getBidWinMny());
            }
            return item;
        }));
        List list = recordMap.isEmpty() ? this.detailService.list() : this.detailService.list((Wrapper)new QueryWrapper().in((Object)"bid_result_register_id", recordMap.keySet().toArray()));
        for (ResultRegisterDetailEntity item2 : list) {
            ResultRegisterVO resultRegisterVO = recordMap.get(item2.getBidResultRegisterId());
            if (Objects.isNull(resultRegisterVO)) continue;
            if (item2.getDetailBidWinFlag().booleanValue()) {
                resultRegisterVO.setWinMny(item2.getDetailBidEntryMny());
            }
            if (resultRegisterVO.getUnitName1() == null) {
                resultRegisterVO.setUnitName1(item2.getCompeteBidUnitName());
                resultRegisterVO.setBidMny1(item2.getDetailBidEntryMny());
                continue;
            }
            if (resultRegisterVO.getUnitName2() == null) {
                resultRegisterVO.setUnitName2(item2.getCompeteBidUnitName());
                resultRegisterVO.setBidMny2(item2.getDetailBidEntryMny());
                continue;
            }
            if (resultRegisterVO.getUnitName3() == null) {
                resultRegisterVO.setUnitName3(item2.getCompeteBidUnitName());
                resultRegisterVO.setBidMny3(item2.getDetailBidEntryMny());
                continue;
            }
            if (resultRegisterVO.getUnitName4() != null) continue;
            resultRegisterVO.setUnitName4(item2.getCompeteBidUnitName());
            resultRegisterVO.setBidMny4(item2.getDetailBidEntryMny());
        }
        pageData.setRecords(new ArrayList<ResultRegisterVO>(recordMap.values()));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("bidWinUnitName");
        fuzzyFields.add("saleLeaderName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, ResultRegisterVO.class);
        voList.forEach(e -> {
            e.setBidWinFlagName(e.getBidWinFlag() != false ? "\u662f" : "\u5426");
            e.setRelateInstallFlagName(e.getRelateInstallFlag() != false ? "\u662f" : "\u5426");
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("ResultRegister-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List resultRegisterEntities = this.service.queryList(param);
        Map<Long, ResultRegisterVO> recordMap = BeanMapper.mapList((Iterable)resultRegisterEntities, ResultRegisterVO.class).stream().collect(Collectors.toMap(BaseVO::getId, item -> {
            if (item.getBidWinFlag().booleanValue()) {
                item.setWinMny(item.getBidWinMny());
            }
            item.setBidWinFlagName(item.getBidWinFlag() != false ? "\u662f" : "\u5426");
            return item;
        }));
        List list = this.detailService.list((Wrapper)new QueryWrapper().in((Object)"bid_result_register_id", recordMap.keySet().toArray()));
        for (ResultRegisterDetailEntity item2 : list) {
            ResultRegisterVO resultRegisterVO = recordMap.get(item2.getBidResultRegisterId());
            if (item2.getDetailBidWinFlag().booleanValue()) {
                resultRegisterVO.setWinMny(item2.getDetailBidEntryMny());
            }
            if (resultRegisterVO.getUnitName1() == null) {
                resultRegisterVO.setUnitName1(item2.getCompeteBidUnitName());
                resultRegisterVO.setBidMny1(item2.getDetailBidEntryMny());
                continue;
            }
            System.out.println(123);
            if (resultRegisterVO.getUnitName2() == null) {
                resultRegisterVO.setUnitName2(item2.getCompeteBidUnitName());
                resultRegisterVO.setBidMny2(item2.getDetailBidEntryMny());
                continue;
            }
            if (resultRegisterVO.getUnitName3() == null) {
                resultRegisterVO.setUnitName3(item2.getCompeteBidUnitName());
                resultRegisterVO.setBidMny3(item2.getDetailBidEntryMny());
                continue;
            }
            if (resultRegisterVO.getUnitName4() != null) continue;
            resultRegisterVO.setUnitName4(item2.getCompeteBidUnitName());
            resultRegisterVO.setBidMny4(item2.getDetailBidEntryMny());
        }
        HashMap<String, ArrayList<ResultRegisterVO>> beans = new HashMap<String, ArrayList<ResultRegisterVO>>();
        beans.put("records", new ArrayList<ResultRegisterVO>(recordMap.values()));
        ExcelExport.getInstance().export("ResultRegisterReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refResultRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ResultRegisterVO>> refResultRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ResultRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/addResultRegisterByBusinessId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ResultRegisterVO> addResultRegisterByBusinessId(@RequestParam Long businessId) {
        ResultRegisterVO vo = this.service.addResultRegisterByBusinessId(businessId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryThirtyDaysData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ResultRegisterVO>> queryThirtyDaysData() {
        QueryParam param = new QueryParam();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        Date endDate = new Date();
        Date startDate = DateUtil.subDays((Date)endDate, (int)30);
        param.getParams().put("create_time", new Parameter("between", (Object)(sim.format(startDate) + "," + sim.format(DateUtil.addDays((Date)endDate, (int)1)))));
        param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(1, 3)));
        param.getOrderMap().put("createTime", "asc");
        List dataList = this.service.queryList(param);
        List registerVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dataList) && dataList.size() > 0) {
            registerVOList = BeanMapper.mapList((Iterable)dataList, ResultRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u67e5\u8be2\u8fd130\u5929\u4e2d\u6807\u9879\u76ee\u6570\u636e\u6210\u529f\uff01", registerVOList);
    }
}

