/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.bid.bean.BidInitiationEntity;
import com.ejianc.business.jlincome.bid.mapper.BidInitiationMapper;
import com.ejianc.business.jlincome.bid.service.IBidInitiationService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bidInitiationService")
public class BidInitiationServiceImpl
extends BaseServiceImpl<BidInitiationMapper, BidInitiationEntity>
implements IBidInitiationService {
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Boolean checkProjectIsExist(BidInitiationEntity bidInitiation) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BidInitiationEntity::getProjectId, (Object)bidInitiation.getProjectId());
        lambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (bidInitiation.getId() != null) {
            lambdaQueryWrapper.ne(BaseEntity::getId, (Object)bidInitiation.getId());
        }
        return super.list((Wrapper)lambdaQueryWrapper).size() > 0;
    }

    @Override
    public CommonResponse<String> pushResultRegisterProjectArchive(String projectStatus, Long projectId) {
        this.logger.info("\u6295\u6807\u7acb\u9879-\u63a8\u9001\u9879\u76ee\u4fe1\u606f\u6570\u636e----projectId = " + projectId.toString() + ",projectStatus" + projectStatus);
        return this.projectArchiveApi.updateProjectStatus(projectStatus, projectId);
    }
}

