/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.bid.mapper.ResultRegisterMapper;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import com.ejianc.business.jlincome.bid.service.IResultRegisterService;
import com.ejianc.business.jlincome.bid.vo.ResultRegisterVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="resultRegisterService")
public class ResultRegisterServiceImpl
extends BaseServiceImpl<ResultRegisterMapper, ResultRegisterEntity>
implements IResultRegisterService {
    @Autowired
    private IBusinessService businessService;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public ResultRegisterVO addResultRegisterByBusinessId(Long businessId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ResultRegisterEntity::getSourceId, (Object)businessId);
        if (super.list((Wrapper)lambda).size() > 0) {
            throw new BusinessException("\u8be5\u5de5\u7a0b\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u91cd\u590d\u5f15\u7528\uff01");
        }
        BusinessEntity businessEntity = (BusinessEntity)((Object)this.businessService.selectById(businessId));
        ResultRegisterVO resultRegisterVO = new ResultRegisterVO();
        resultRegisterVO.setOrgId(businessEntity.getOrgId());
        resultRegisterVO.setOrgName(businessEntity.getOrgName());
        resultRegisterVO.setOrgCode(businessEntity.getOrgCode());
        resultRegisterVO.setProjectName(businessEntity.getProjectName());
        resultRegisterVO.setCustomName(businessEntity.getCustomName());
        resultRegisterVO.setProjectTypeId(businessEntity.getProjectTypeId());
        resultRegisterVO.setProjectTypeName(businessEntity.getProjectTypeName());
        resultRegisterVO.setProductType(businessEntity.getProductType());
        resultRegisterVO.setProductTypeName(businessEntity.getProductTypeName());
        resultRegisterVO.setProductName(businessEntity.getProductName());
        resultRegisterVO.setSpec(businessEntity.getSpec());
        resultRegisterVO.setNum(businessEntity.getNum());
        resultRegisterVO.setSaleLeaderId(businessEntity.getSaleLeaderId());
        resultRegisterVO.setSaleLeaderName(businessEntity.getSaleLeaderName());
        resultRegisterVO.setSaleLeaderPhone(businessEntity.getSaleLeaderPhone());
        resultRegisterVO.setBidFileReceiveDate(businessEntity.getBidFilePlanReceiveDate());
        resultRegisterVO.setBidOpenDate(businessEntity.getPlanBidOpenDate());
        resultRegisterVO.setCustomLinkName(businessEntity.getCustomLinkName());
        resultRegisterVO.setCustomLinkPhone(businessEntity.getCustomLinkPhone());
        resultRegisterVO.setPlanDeliverDate(businessEntity.getPlanDeliverDate());
        resultRegisterVO.setProjectSituation(businessEntity.getProjectSituation());
        resultRegisterVO.setAddress(businessEntity.getDetailedAddress());
        resultRegisterVO.setSourceId(businessEntity.getId());
        resultRegisterVO.setSourceCode(businessEntity.getBillCode());
        resultRegisterVO.setSourceType(Integer.valueOf(1));
        return resultRegisterVO;
    }

    @Override
    public CommonResponse<String> pushResultRegisterProjectArchive(ResultRegisterEntity entity) {
        ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
        projectArchiveVO.setProjectStatus(entity.getBidWinFlag() != false ? ArchiveProjectStatusEnum.\u5df2\u4e2d\u6807.getCode() : ArchiveProjectStatusEnum.\u672a\u4e2d\u6807.getCode());
        projectArchiveVO.setSourceUpdateId(1 == entity.getSourceType() ? entity.getId().toString() : null);
        if (0 == entity.getSourceType()) {
            projectArchiveVO.setSourceType("bid");
            projectArchiveVO.setSourceBillId(entity.getId());
            projectArchiveVO.setSourceBillCode(entity.getBillCode());
        } else if (1 == entity.getSourceType()) {
            projectArchiveVO.setSourceBillId(entity.getSourceId());
        }
        projectArchiveVO.setName(entity.getProjectName());
        projectArchiveVO.setOrgId(entity.getOrgId());
        projectArchiveVO.setOrgCode(entity.getOrgCode());
        projectArchiveVO.setOrgName(entity.getOrgName());
        projectArchiveVO.setProjectTypeId(entity.getProjectTypeId());
        projectArchiveVO.setProjectTypeName(entity.getProjectTypeName());
        projectArchiveVO.setProductType(entity.getProductType());
        projectArchiveVO.setProductTypeName(entity.getProductTypeName());
        projectArchiveVO.setProjectDate(entity.getProjectApprovalDate());
        projectArchiveVO.setBusinessCustomName(entity.getCustomName());
        projectArchiveVO.setCustomLinkName(entity.getCustomLinkName());
        projectArchiveVO.setCustomLinkPhone(entity.getCustomLinkPhone());
        projectArchiveVO.setDesignUnit(entity.getDesignUnit());
        projectArchiveVO.setConstructUnit(entity.getContractingUnit());
        projectArchiveVO.setArea(entity.getArea());
        projectArchiveVO.setAreaName(entity.getAreaName());
        projectArchiveVO.setAddress(entity.getAddress());
        projectArchiveVO.setNationalId(entity.getNationalId());
        projectArchiveVO.setNationalName(entity.getNationalName());
        projectArchiveVO.setProjectHeight(entity.getProjectHeight());
        projectArchiveVO.setProjectSpan(entity.getProjectSpan());
        projectArchiveVO.setBidOpenDate(entity.getBidOpenDate());
        projectArchiveVO.setBidDate(entity.getBidDate());
        projectArchiveVO.setPlanProductDate(entity.getPlanProductDate());
        projectArchiveVO.setPlanDeliverDate(entity.getPlanDeliverDate());
        projectArchiveVO.setProductName(entity.getProductName());
        projectArchiveVO.setSpec(entity.getSpec());
        projectArchiveVO.setNum(entity.getNum());
        projectArchiveVO.setSaleLeaderId(entity.getSaleLeaderId());
        projectArchiveVO.setSaleLeaderName(entity.getSaleLeaderName());
        projectArchiveVO.setSaleLeaderPhone(entity.getSaleLeaderPhone());
        projectArchiveVO.setProjectSituation(entity.getProjectSituation());
        this.logger.info("\u62db\u6807\u7ed3\u679c\u767b\u8bb0-\u63a8\u9001\u9879\u76ee\u4fe1\u606f\u6570\u636e----" + JSONObject.toJSONString((Object)projectArchiveVO));
        return this.projectArchiveApi.pushProjectArchive(projectArchiveVO);
    }

    @Override
    public String sendMsgToInstallPerson(ResultRegisterEntity entity) {
        this.logger.info("\u5f00\u59cb\u7ed9\u5b89\u88c5\u4eba\u5458\u53d1\u9001\u6d88\u606f\uff1a----");
        String msg = this.sendMsg(entity, "\u4e2d\u6807\u4fe1\u606f", entity.getCustomName() + "\uff1a-" + entity.getProjectName() + "-" + entity.getOrgName() + "\uff1a\u5df2\u4e2d\u6807\uff0c\u9700\u8981\u73b0\u573a\u5b89\u88c5\uff0c\u8bf7\u6ce8\u610f\uff01");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u7ed9\u5b89\u88c5\u4eba\u5458\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a" + msg);
        }
        this.logger.info("\u7ed9\u5b89\u88c5\u4eba\u5458\u53d1\u9001\u6d88\u606f\u7ed3\u675f\uff01");
        return msg;
    }

    private String sendMsg(ResultRegisterEntity registerEntity, String subject, String content) {
        Object[] msgRecUserIds = new String[]{registerEntity.getInstallLeaderId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(content);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(registerEntity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}

