/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.bid.bean.TenderEvaluationEntity;
import com.ejianc.business.jlincome.bid.mapper.TenderEvaluationMapper;
import com.ejianc.business.jlincome.bid.service.ITenderEvaluationService;
import com.ejianc.business.jlincome.bid.vo.TenderEvaluationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tenderEvaluationService")
public class TenderEvaluationServiceImpl
extends BaseServiceImpl<TenderEvaluationMapper, TenderEvaluationEntity>
implements ITenderEvaluationService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean checkIsExist(TenderEvaluationVO tenderEvaluationVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(TenderEvaluationEntity::getEngineeringId, (Object)tenderEvaluationVO.getEngineeringId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != tenderEvaluationVO.getId() && tenderEvaluationVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)tenderEvaluationVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> pushProjectArchive(TenderEvaluationEntity tenderEvaluationEntity) {
        ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
        String projectStatus = ArchiveProjectStatusEnum.\u6295\u6807\u9636\u6bb5.getCode();
        Long engineeringId = tenderEvaluationEntity.getEngineeringId();
        this.logger.info("\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1-\u63a8\u9001\u9879\u76ee\u4fe1\u606f\u6570\u636e----" + JSONObject.toJSONString((Object)projectArchiveVO));
        return this.projectArchiveApi.updateProjectStatus(projectStatus, engineeringId);
    }
}

