/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.income.bean.ReviewDetailEntity;
import com.ejianc.business.jlincome.income.bean.ReviewEntity;
import com.ejianc.business.jlincome.income.service.IReviewDetailService;
import com.ejianc.business.jlincome.income.service.IReviewService;
import com.ejianc.business.jlincome.income.vo.ReviewDetailVO;
import com.ejianc.business.jlincome.income.vo.ReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"review"})
public class ReviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "HTPSC";
    @Autowired
    private IReviewService service;
    @Autowired
    private IReviewDetailService detailsService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReviewVO> saveOrUpdate(@RequestBody ReviewVO saveOrUpdateVO) {
        ReviewEntity entity = (ReviewEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReviewEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<ReviewDetailEntity> detailList = entity.getDetailList();
            boolean upFlag = false;
            BigDecimal contractTaxMny = BigDecimal.ZERO;
            BigDecimal contractMny = BigDecimal.ZERO;
            BigDecimal contractTax = BigDecimal.ZERO;
            for (ReviewDetailEntity item : detailList) {
                if (null != item.getRowState() && item.getRowState().equals("del")) continue;
                upFlag = true;
                contractTaxMny = ComputeUtil.safeAdd((BigDecimal)contractTaxMny, (BigDecimal)item.getDetailTaxMny());
                contractMny = ComputeUtil.safeAdd((BigDecimal)contractMny, (BigDecimal)item.getDetailMny());
                contractTax = ComputeUtil.safeAdd((BigDecimal)contractTax, (BigDecimal)item.getDetailTax());
            }
            if (upFlag) {
                entity.setContractTaxMny(contractTaxMny);
                entity.setContractMny(contractMny);
                entity.setContractTax(contractTax);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ReviewVO vo = (ReviewVO)BeanMapper.map((Object)((Object)entity), ReviewVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReviewVO> queryDetail(Long id) {
        ReviewEntity entity = (ReviewEntity)((Object)this.service.selectById(id));
        ReviewVO vo = (ReviewVO)BeanMapper.map((Object)((Object)entity), ReviewVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReviewVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReviewVO reviewVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReviewVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("reviewTitle");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("reviewResult");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List reviewVOS = BeanMapper.mapList((Iterable)page.getRecords(), ReviewVO.class);
        reviewVOS.forEach(reviewVO -> reviewVO.setReviewTypeStr(reviewVO.getReviewType() == 1 ? "100\u4e07\u4ee5\u4e0b" : "100\u4e07\u4ee5\u4e0a"));
        pageData.setRecords(reviewVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReviewDetailVO>> queryDetailList(@RequestBody QueryParam param) {
        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        Map params = param.getParams();
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != params && params.containsKey("reviewDate")) {
            String reviewDate = (String)((Parameter)params.get("reviewDate")).getValue();
            String[] split = reviewDate.split(",");
            String startDate = split[0];
            String endDate = split[1];
            queryParam.put("startDate", startDate);
            queryParam.put("endDate", endDate);
        }
        pageIndex = pageIndex < 1 ? 0 : (pageIndex - 1) * pageSize;
        queryParam.put("orgId", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(e -> e.getId().toString()).collect(Collectors.joining(",")));
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            queryParam.put("searchText", param.getSearchText());
        }
        queryParam.put("orders", param.getOrderMap().get("reviewDate"));
        IPage<ReviewDetailVO> jsonObjectIPage = this.service.queryPage(queryParam, pageIndex, pageSize);
        jsonObjectIPage.setSize((long)pageSize.intValue());
        jsonObjectIPage.setCurrent((long)param.getPageIndex());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", jsonObjectIPage);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/detail/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelDetailExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List records = new ArrayList();
        CommonResponse<IPage<ReviewDetailVO>> iPageCommonResponse = this.queryDetailList(param);
        if (iPageCommonResponse.isSuccess()) {
            records = ((IPage)iPageCommonResponse.getData()).getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("ReviewDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("reviewTitle");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("reviewResult");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List page = this.service.queryList(param, false);
        List reviewVOS = BeanMapper.mapList((Iterable)page, ReviewVO.class);
        reviewVOS.forEach(reviewVO -> {
            reviewVO.setReviewTypeStr(reviewVO.getReviewType() == 1 ? "100\u4e07\u4ee5\u4e0b" : "100\u4e07\u4ee5\u4e0a");
            reviewVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)reviewVO.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", reviewVOS);
        ExcelExport.getInstance().export("Review-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refReviewData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReviewVO>> refReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("reviewTitle");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("reviewResult");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refReviewDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReviewDetailVO>> refReviewDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("detailProductName");
        fuzzyFields.add("detailSpec");
        fuzzyFields.add("detailUnit");
        fuzzyFields.add("detailMemo");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"reviewId")) {
            param.getParams().put("reviewId", new Parameter("eq", (Object)_con.getString("reviewId")));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.detailsService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReviewDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"DepartDetailImport.xlsx", (String)"\u8bc4\u5ba1\u4ea7\u54c1\u6e05\u5355\u660e\u7ec6\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<ReviewDetailVO> successList = new ArrayList<ReviewDetailVO>();
        ArrayList<ReviewDetailVO> errorList = new ArrayList<ReviewDetailVO>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            ReviewDetailVO vo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new ReviewDetailVO();
                vo.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setErrorMsg("\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setDetailProductName((String)datas.get(0));
                vo.setDetailSpec((String)datas.get(1));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setErrorMsg("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setDetailUnit((String)datas.get(2));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                String detailNum = (String)datas.get(3);
                try {
                    vo.setDetailNum(new BigDecimal(detailNum));
                }
                catch (Exception e) {
                    vo.setDetailNum(null);
                    vo.setErrorMsg("\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setErrorMsg("\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                String detailTaxPrice = (String)datas.get(4);
                try {
                    vo.setDetailTaxPrice(new BigDecimal(detailTaxPrice));
                }
                catch (Exception e) {
                    vo.setDetailTaxPrice(null);
                    vo.setErrorMsg("\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setErrorMsg("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    errorList.add(vo);
                    continue;
                }
                String detailRate = (String)datas.get(5);
                try {
                    vo.setDetailRate(new BigDecimal(detailRate));
                }
                catch (Exception e) {
                    vo.setDetailRate(null);
                    vo.setErrorMsg("\u7a0e\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570\uff01");
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    String detailDeliveryDate = (String)datas.get(6);
                    try {
                        Date date = formatter.parse(detailDeliveryDate);
                        vo.setDetailDeliveryDate(date);
                    }
                    catch (ParseException e) {
                        vo.setDetailDeliveryDate(null);
                        vo.setErrorMsg("\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff01");
                        errorList.add(vo);
                        continue;
                    }
                }
                vo.setDetailProductName((String)datas.get(0));
                vo.setDetailMemo((String)datas.get(7));
                BigDecimal decimal = ComputeUtil.safeDiv((BigDecimal)vo.getDetailRate(), (BigDecimal)new BigDecimal(100));
                decimal = ComputeUtil.safeAdd((BigDecimal)decimal, (BigDecimal)BigDecimal.ONE);
                BigDecimal detailPrice = ComputeUtil.safeDiv((BigDecimal)vo.getDetailTaxPrice(), (BigDecimal)decimal);
                vo.setDetailPrice(detailPrice);
                BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)vo.getDetailNum(), (BigDecimal)vo.getDetailTaxPrice());
                BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)vo.getDetailNum(), (BigDecimal)vo.getDetailPrice());
                vo.setDetailTaxMny(taxMny);
                vo.setDetailMny(mny);
                BigDecimal tax = ComputeUtil.safeSub((BigDecimal)vo.getDetailTaxMny(), (BigDecimal)vo.getDetailMny());
                vo.setDetailTax(tax);
                vo.setSourceType(Integer.valueOf(2));
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/queryLastSignDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReviewVO> queryLastSignDate(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ReviewEntity::getProjectId, (Object)projectId);
        queryWrapper.in(ReviewEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(ReviewEntity::getReviewDate);
        queryWrapper.last("limit 1");
        ReviewEntity entity = (ReviewEntity)((Object)this.service.getOne((Wrapper)queryWrapper, false));
        ReviewVO vo = null != entity ? (ReviewVO)BeanMapper.map((Object)((Object)entity), ReviewVO.class) : null;
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

