/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.bean.DeductionEntity;
import com.ejianc.business.jlincome.income.mapper.DeductionMapper;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.IDeductionService;
import com.ejianc.business.jlincome.income.vo.DeductionVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deductionService")
public class DeductionServiceImpl
extends BaseServiceImpl<DeductionMapper, DeductionEntity>
implements IDeductionService {
    @Autowired
    private IContractRegisterService contractRegisterService;

    @Override
    public void hasRecordUp(List<Long> idList, Integer hasRecord) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", idList);
        updateWrapper.set((Object)"has_record", (Object)hasRecord);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public JSONObject queryDeductionRecordByContId(Long contractId) {
        ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(contractId));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", (Object)contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", (Object)contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", (Object)contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", (Object)contractEntity.getChangeStatus());
        jsonObject.put("billState", (Object)contractEntity.getBillState());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DeductionEntity::getContractId, (Object)contractId);
        queryWrapper.in(DeductionEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(DeductionEntity::getDeductionDate);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List deductionVOS = BeanMapper.mapList((Iterable)list, DeductionVO.class);
            deductionVOS.sort(Comparator.comparing(DeductionVO::getDeductionDate));
            jsonObject.put("sumDeductionTaxMny", (Object)deductionVOS.stream().filter(p -> p.getDeductionTaxMny() != null).map(DeductionVO::getDeductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            jsonObject.put("detailList", (Object)deductionVOS);
        }
        return jsonObject;
    }
}

