/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.income.bean.SettleDeductionEntity;
import com.ejianc.business.jlincome.income.bean.SettleEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.IDeductionService;
import com.ejianc.business.jlincome.income.service.ISettleService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settle")
public class SettleBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ISettleService service;
    @Autowired
    private IContractRegisterService contractService;
    @Autowired
    private IDeductionService deductedService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)settleEntity.getContractId());
        settleLambda.ne(BaseEntity::getId, (Object)billId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = this.service.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)settleEntity.getContractId()));
        param.getOrderMap().put("create_time", "desc");
        List settleList = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)settleList) && null != settleList.get(0)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u65b0\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        String projectStatus;
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SettleEntity::getProjectId, (Object)settleEntity.getProjectId());
        lambdaQueryWrapper.in(SettleEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(BaseEntity::getId, (Object)billId);
        String string = projectStatus = settleEntity.getSettleType() == 1 ? ArchiveProjectStatusEnum.\u7ed3\u7b97\u9636\u6bb5.getCode() : ArchiveProjectStatusEnum.\u5b8c\u5de5.getCode();
        Boolean manyFlag = settleEntity.getSettleType() == 1 ? this.service.list((Wrapper)lambdaQueryWrapper).size() > 0 : false;
        CommonResponse projectArchiveRes = this.projectArchiveApi.updateArchiveProjectStatus(projectStatus, settleEntity.getProjectId(), settleEntity.getId(), manyFlag, Boolean.valueOf(false));
        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String projectStatus;
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SettleEntity::getProjectId, (Object)settleEntity.getProjectId());
        lambdaQueryWrapper.in(SettleEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(BaseEntity::getId, (Object)billId);
        String string = projectStatus = settleEntity.getSettleType() == 1 ? ArchiveProjectStatusEnum.\u7ed3\u7b97\u9636\u6bb5.getCode() : ArchiveProjectStatusEnum.\u5b8c\u5de5.getCode();
        Boolean manyFlag = settleEntity.getSettleType() == 1 ? this.service.list((Wrapper)lambdaQueryWrapper).size() > 0 : false;
        CommonResponse projectArchiveRes = this.projectArchiveApi.updateArchiveProjectStatus(projectStatus, settleEntity.getProjectId(), settleEntity.getId(), manyFlag, Boolean.valueOf(true));
        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
        }
        if (settleEntity.getSettleType() == 2) {
            this.contractService.performanceStatusUp(settleEntity.getContractId(), 3);
        }
        if (CollectionUtils.isNotEmpty(settleEntity.getDeductionList())) {
            List<SettleDeductionEntity> detailList = settleEntity.getDeductionList();
            this.deductedService.hasRecordUp(detailList.stream().map(SettleDeductionEntity::getSourceId).collect(Collectors.toList()), 1);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity nodeSettle;
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)settleEntity.getContractId());
        settleLambda.ne(BaseEntity::getId, (Object)billId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = this.service.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)settleEntity.getContractId()));
        param.getOrderMap().put("create_time", "desc");
        List settleList = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)settleList) && null != settleList.get(0) && !(nodeSettle = (SettleEntity)((Object)settleList.get(0))).getId().equals(billId)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u65b0\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity nodeSettle;
        String projectStatus;
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SettleEntity::getProjectId, (Object)settleEntity.getProjectId());
        lambdaQueryWrapper.in(SettleEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(BaseEntity::getId, (Object)billId);
        String string = projectStatus = settleEntity.getSettleType() == 1 ? ArchiveProjectStatusEnum.\u7ed3\u7b97\u9636\u6bb5.getCode() : ArchiveProjectStatusEnum.\u5b8c\u5de5.getCode();
        Boolean manyFlag = settleEntity.getSettleType() == 1 ? this.service.list((Wrapper)lambdaQueryWrapper).size() > 0 : false;
        CommonResponse projectArchiveRes = this.projectArchiveApi.updateArchiveProjectStatus(projectStatus, settleEntity.getProjectId(), settleEntity.getId(), manyFlag, Boolean.valueOf(false));
        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)settleEntity.getContractId());
        settleLambda.ne(BaseEntity::getId, (Object)billId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = this.service.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)settleEntity.getContractId()));
        param.getOrderMap().put("create_time", "desc");
        List settleList = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)settleList) && null != settleList.get(0) && !(nodeSettle = (SettleEntity)((Object)settleList.get(0))).getId().equals(billId)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u65b0\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        if (settleEntity.getSettleType() == 2) {
            this.contractService.performanceStatusUp(settleEntity.getContractId(), 2);
        }
        if (CollectionUtils.isNotEmpty(settleEntity.getDeductionList())) {
            List<SettleDeductionEntity> detailList = settleEntity.getDeductionList();
            this.deductedService.hasRecordUp(detailList.stream().map(SettleDeductionEntity::getSourceId).collect(Collectors.toList()), 0);
        }
        return CommonResponse.success();
    }
}

